/***************************************************************************
                          kdddlldoc.cpp  -  description                              
                             -------------------                                         

    version              : 1.0                                 
    begin                : Thu Feb 25 05:55:16 CET 1999
                                           
    copyright            : (C) 1999 by Uwe Bhme                         
    email                : uwe@hof.baynet.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <kdddlldoc.h>

KDDDLLDoc::KDDDLLDoc(QObject *parent, const char *filename):QObject(parent)
{
  bModified = false;

  connect( this,   SIGNAL(wantOpenedFile(const char *)),    parent, SLOT(slotOpenFile(const char *)) );
  connect( this,   SIGNAL(wantSavedFile(const char *)),     parent, SLOT(slotSaveFile(const char *)) );
  connect( this,   SIGNAL(wantSavedBinary(const char *)),   parent, SLOT(slotSaveBinary(const char *)) );
  connect( this,   SIGNAL(wantPreviewBinary(const char *)), parent, SLOT(slotPreviewBinary(const char *)) );
  connect( parent, SIGNAL(modifiedFile(bool)),              this,   SLOT(slotSetModified(bool)) );
}

KDDDLLDoc::~KDDDLLDoc()
{
}

void KDDDLLDoc::deleteContents()
{
    bModified = false;
}

void KDDDLLDoc::saveFile()
{
    emit wantSavedFile( (const char*)(0) );
}

void KDDDLLDoc::saveFileAs()
{
    QString name =  KFileDialog::getSaveFileName( 0, "*.kdlg" );
    if( name.data() )
        emit wantSavedFile( name.data() );
}

void KDDDLLDoc::saveBinaryFile()
{
    QString name =  KFileDialog::getSaveFileName( 0, "*.pkdlg" );
    if( name.data() )
        emit wantSavedBinary( name.data() );
}

void KDDDLLDoc::previewBinaryFile()
{
    QString name =  KFileDialog::getSaveFileName( 0, "*.pkdlg" );
    if( name.data() )
        emit wantPreviewBinary( name.data() );
}



void KDDDLLDoc::openFile( const char *file )
{
    QString name;
    if( file )
        name = file;
    else
        name = KFileDialog::getOpenFileName( 0, "*.kdlg" );
    if( name.data() )
        emit wantOpenedFile( name.data() );
}

void KDDDLLDoc::slotSetModified(bool m)
{
  bModified = m;
}

