/***************************************************************************
                          kdddllparser.h  -  description                              
                             -------------------                                         

    version              : 0.1pre-alpha
    begin                : Thu Feb 25 05:55:16 CET 1999
                                           
    copyright            : (C) 1999 by Uwe Bhme                         
    email                : uwe@hof.baynet.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef KDDDLLPARSER_H
#define KDDDLLPARSER_H

#include <rx.h>

#include <qstring.h>
#include <qdict.h>
#include <qvector.h>
#include <qtextstream.h>


/** This class is a component of the parser tree.
  * It's associating a attribute of a tag to the assigned
  * attribute value, saved as <EM>QString value</EM>.
  * The type of the attribute is saved as a index into <TT>typelist</TT>.
  */
class KDDDLLAttrValue
{
public:
    /** Constructs a attribute value.
      * @param value The value of the attribute.
      * @param index The attribute index.
      *              For more about this index look the <TT>ATT_</TT> defines.
      */
    KDDDLLAttrValue( const QString &value, int index );
    /** Constructs a attribute value reading a parsed binary
      */
    KDDDLLAttrValue( QIODevice *in = 0 );

    /** Returns the attribute name.
      */
    const char *name() const;
    /** Holds the attribute value.
      */
    QString value;
    /** Identifies the type of the value by index.
      * Look the sourcecode <TT>struct typelist[]</TT>.
      */
    int index; // into typelist[]

    /** Saves the attribute value as part of a binary parsed dialog.
      */
    bool write( QIODevice *out );
};


/** This class is a component of the parser tree.
  * It's gathering together the atrributes and the
  * associated values of a single tag.
  */
class KDDDLLAttrValueList :
    public QDict<KDDDLLAttrValue>
{
public:
    /** Constructs a empty attibute list. */
    KDDDLLAttrValueList() : QDict<KDDDLLAttrValue>( 5, false, true ) {};
    /** Returns the textual value of a attribute
      * @param attr The name of the attribute 
      * @param def The returned dafault value
      *            if the attibute is not in the list.
      */
    const char *getVal( const char *attr, const char *def = 0 ) const;
    /** Returns the converted integer value of a attribute
      * The conversion is defined by the conversion function
      * of the attributes type.
      * @param attr The name of the attribute 
      * @param def The returned dafault value
      *            if the attibute is not in the list.
      */
    int getVal( const char *attr, int def ) const;

    /** Reads the attributes from a parsed binary dialog. */
    void read( QIODevice *in );
    /** Writes the attributes to a parsed binary dialog. */
    bool write( QIODevice *out );
};


/** This class is a component of the parser tree.
  * It representing a single tag with all the associated data.
  */
class KDDDLLTag
{
public:
    KDDDLLTag( int index );
    KDDDLLTag( QIODevice *in );

    const char *name() const;
    KDDDLLAttrValueList attr;
    int index; // into taglist[]

    bool write( QIODevice *out );
};

class KDDDLLTagList :
    public QVector<KDDDLLTag>
{
public:
    KDDDLLTagList( QIODevice *in = 0 );
    bool add( KDDDLLTag *tag );

    bool write( QIODevice *out );
};

/** This class is net jet working. It's intended to
  * work for a later &lt;INTERFACE&gt; tag for
  * detailled description of the user-interface to the
  * dialog.
  */
class KDDDLLData
{
public:
    KDDDLLData( QIODevice *in = 0 );
    KDDDLLTagList *iface;
    KDDDLLTagList *tags;
    bool write( QIODevice *out );
};



#define OUT_INFO  0
#define OUT_WARN  1
#define OUT_ERR   2
#define OUT_FATAL 3

/** parses KDDDLL-file to a KDDDLLTagList.
  */
bool KDDDLLparse( KDDDLLTagList *tagList, QTextStream *source, QTextStream *msg = 0, int msglevel = OUT_ERR );


/** from here on all is a little bit more c-style
  * it simply happened that way
  * Any modification in the patternmatching
  * or in the attributes has to go here
  * Please please please don't stuff the cpp code
  * with stuff like
  * <PRE>
  * if( actattr->name == "MYATTR" )
  *   // do some ugly special private handling
  * </PRE>
  */

/* Attribute Type */
#define ATT_T_NONE        0
#define ATT_T_INT         1
#define ATT_T_BOOL        2
#define ATT_T_ANY         3
#define ATT_T_NAME        4
#define ATT_T_COLOR       5  // In a galaxy far far away, distant future ...
#define ATT_T_HALIGN      6
#define ATT_T_VALIGN      7  // In a galaxy far far away, distant future ...
#define ATT_T_TYPE        8
#define ATT_T_COUNT       9


/* Attributes */
#define ATT_NAME         0
#define ATT_TYPE         1
#define ATT_TITLE        2
#define ATT_BORDER       3
#define ATT_MAXLENGTH    4
#define ATT_COLSPAN      5
#define ATT_ROWSPAN      6
#define ATT_MINROWS      7
#define ATT_CHECKED      8
#define ATT_ID           9
#define ATT_GROUP       10
#define ATT_TEXTCOLOR   11  // In a galaxy far far away, distant future ...
#define ATT_BGCOLOR     12  // In a galaxy far far away, distant future ...
#define ATT_ALIGN       13  // In a galaxy far far away, distant future ...
#define ATT_TEXT        14  // Tagged text (name it the setText value) is handled as be this.
#define ATT_INDEX       15  // Default index of List- and Comboboxes
#define ATT_COUNT       16


/* tags */
#define TAG_KDDDL        0
#define TAG_E_KDDL       1
#define TAG_GROUP        2
#define TAG_E_GROUP      3
#define TAG_BOOK         4
#define TAG_E_BOOK       5
#define TAG_PAGE         6
#define TAG_E_PAGE       7
#define TAG_LABEL        8
#define TAG_BUTTON       9
#define TAG_CHECKBOX    10
#define TAG_RADIOBUTTON 11
#define TAG_LINEEDIT    12
#define TAG_LISTBOX     13
#define TAG_E_LISTBOX   14
#define TAG_COMBOBOX    15
#define TAG_E_COMBOBOX  16
#define TAG_LI          17
#define TAG_BR          18
#define TAG_SKIP        19
#define TAG_COUNT       20

/* Attribute Scope */
#define ATT_S_MAY         0
#define ATT_S_MUST        1

#define TAG_C_TEXT        0
#define TAG_C_IMPLICIT    1
#define TAG_C_ANYWHERE    2
#define TAG_C_CLOSE       3

#define TAG_MAXATTR       10

#endif
