/***************************************************************************
                          kdddllview.h  -  description                              
                             -------------------                                         

    version              : 1.0                                  
    begin                : Thu Feb 25 05:55:16 CET 1999
                                           
    copyright            : (C) 1999 by Uwe Bhme                         
    email                : uwe@hof.baynet.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef KDDDLLVIEW_H 
#define KDDDLLVIEW_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <kapp.h>
#include <qwidget.h>

#include <keditcl.h>

/**
  * This class provides an incomplete base for your application view. 
  * This also requires a new implementation of resizeEvent so your view is
  * displayed correctly.  Your View Widget should provide methods to handle
  * the users actions on the view and interact with the doc class of the
  * application to set the modified flag for the document. 
  * Example:  You decided to use a QMultilineEdit widget in your view. This
  * Widget emits a signal textChaged() if the user changes the text. Then, you
  * could use this signal to connect to the slot of the doc class to set the
  * modified flag (which then enables the save and save as items.   */ 

class KDDDLLView : public QWidget
{
  Q_OBJECT

 public:
  /** Constructor for the main view */
  KDDDLLView(QWidget *parent = 0, const char *name = 0);
  /** Destructor for the main view */
  virtual ~KDDDLLView();

  void previewFile();

  const char *getName();
  public slots:
    /** put the marked text/object into the clipboard and remove 
     *	it from the document */
    void slotEditCut(); 
    /** put the marked text/object into the clipboard*/
    void slotEditCopy(); 
    /** paste the clipboard into the document*/
    void slotEditPaste();  

    void slotOpenFile( const char * );
    void slotSaveFile( const char * );
    void slotSaveBinary( const char * );
    void slotPreviewBinary( const char * );
    void slotFileChanged();

 signals:
    void modifiedFile( bool );

 protected:
  /** resizeEvent for the main view */
  virtual void resizeEvent(QResizeEvent *evt);


 private:

  ////////////////////////////////////////////////////////
  // TODO: Add your individual application widgets here
  KEdit * widget;
};

#endif // KDDDLLVIEW_H 
