/***************************************************************************
                          resource.h  -  description                              
                             -------------------                                         

    version              : 0.1pre-alpha
    begin                : Thu Feb 25 05:55:16 CET 1999
                                           
    copyright            : (C) 1999 by Uwe Bhme                         
    email                : uwe@hof.baynet.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef RESSOURCE_H
#define RESSOURCE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

///////////////////////////////////////////////////////////////////
// resource.h  -- contains macros used for commands


///////////////////////////////////////////////////////////////////
// COMMAND VALUES FOR MENUBAR AND TOOLBAR ENTRIES


///////////////////////////////////////////////////////////////////
// File-menu entries
#define ID_FILE_NEW_WINDOW          10010
#define ID_FILE_NEW                 10020
#define ID_FILE_OPEN                10030
#define ID_FILE_RECENT              10040

#define ID_FILE_SAVE                10050
#define ID_FILE_SAVE_AS             10060
#define ID_FILE_SAVE_BINARY         10070

#define ID_FILE_PREVIEW             10080
#define ID_FILE_PREVIEW_BINARY      10090

#define ID_FILE_CLOSE_WINDOW        10100


///////////////////////////////////////////////////////////////////
// Edit-menu entries
#define ID_EDIT_UNDO                11010
#define ID_EDIT_REDO                11020
#define ID_EDIT_COPY                11030
#define ID_EDIT_CUT                 11040
#define ID_EDIT_PASTE               11050
#define ID_EDIT_SELECT_ALL          11060


///////////////////////////////////////////////////////////////////
// View-menu entries                    
#define ID_VIEW_TOOLBAR_0           12010
#define ID_VIEW_STATUSBAR           12020
#define ID_VIEW_OPTIONS             12030



///////////////////////////////////////////////////////////////////
// General application values
#define ID_APP_EXIT                 1000      
#define ID_STATUS_MSG               1001
#define ID_HELP                     1002

#define IDS_DEFAULT                 "Ready."

#define IDS_APP_ABOUT               "KLayout\nVersion " VERSION






///////////////////////////////////////////////////////////////////
// MACROS FOR THE CONNECT OF YOUR SIGNALS TO CORRESPONDENT SLOTS 
// IN YOUR MAIN IMPLEMENTATION OF MENUBAR AND TOOLBAR


///////////////////////////////////////////////////////////////////
// MENU CONNECTS
#define CONNECT_CMD(submenu)           connect(submenu, SIGNAL(activated(int)), SLOT(commandCallback(int)));connect(submenu,SIGNAL(highlighted(int)), SLOT(statusCallback(int)))


///////////////////////////////////////////////////////////////////
// TOOLBAR CONNECT  
#define CONNECT_TOOLBAR(ToolBar)        connect(ToolBar, SIGNAL(clicked(int)), SLOT(commandCallback(int)));connect(ToolBar, SIGNAL(highlighted(int,bool)), SLOT(statusCallback(int)))


///////////////////////////////////////////////////////////////////
// MACROS FOR GENERATING THE SWITCH CONSTRUCTION OF THE commandCallback(int) METHOD


///////////////////////////////////////////////////////////////////
// Create class member in implementation for commandCallback
#define BEGIN_CMD(class)         void class::commandCallback(int id_){ switch (id_){

///////////////////////////////////////////////////////////////////
// Create cases for entries and connect them with their functions
#define ON_CMD(id, cmd_class_function, message)   case id:slotStatusMsg(message);cmd_class_function; slotStatusMsg(IDS_DEFAULT);break;   

/////////////////////////////////////////////////////////////////// 
// End class member in implementation for commandCallback 
#define END_CMD()      }}




///////////////////////////////////////////////////////////////////
// MACROS FOR GENERATING THE SWITCH CONSTRUCTION OF THE statusCallback(int) METHOD

///////////////////////////////////////////////////////////////////
// Create class member in implementation for statusCallback
#define BEGIN_STATUS_MSG(class) void class::statusCallback(int id_){ switch (id_){

///////////////////////////////////////////////////////////////////
// Create cases for entries and connect them to change statusBar entry
#define ON_STATUS_MSG(id, message)     case id:  slotStatusHelpMsg(message);break;
 
///////////////////////////////////////////////////////////////////
// End class member in implementation for statusCallback
#define END_STATUS_MSG()         default: slotStatusMsg(IDS_DEFAULT); }}

#endif // RESOURCE_H









