
/******************************************************************************
**         File: $RCSfile$
**
**  Description:
**
**      Created: $Date$
**
**      Changes: $Revision$
**   $Log$ 
**
** Distribution: $Name$ 
******************************************************************************/
/*-----------------------------------------------------------------------------
-- SYSTEM INCLUDE FILE DECLARATIONS
-----------------------------------------------------------------------------*/
#include <unistd.h>
#include <assert.h>
#include <qpopmenu.h>
#include <qkeycode.h>
#include <kmsgbox.h>
#include <kfiledialog.h>
#include <kfontdialog.h>
#include <kcolordlg.h>
#include <kstdaccel.h>
#include <iostream.h>


/*-----------------------------------------------------------------------------
-- PRIVATE INCLUDE FILE DECLARATIONS
-----------------------------------------------------------------------------*/
#include "config.h"
#include "kdiffTopLevel.h"
#include "kdiff.h"
#include "kdiffColorDialog.h"
#include "kdiffDiffOptionsDialog.h"
#include "DebugInfo.h"

/*-----------------------------------------------------------------------------
-- DEFINITIONS
-----------------------------------------------------------------------------*/
// Toolbar-Button and Menubar - IDS
#define OPENLEFT_TBBTN   1
#define OPENRIGHT_TBBTN  2
#define DODIFF_TBBTN     3
#define PREV_TBBTN       4
#define NEXT_TBBTN       5

// Statusbar-Text-IDS
#define STATUSBAR_ONE       1
#define STATUSBAR_DIFFCOUNT 2
#define STATUSBAR_PERCSHOW  3

/*-----------------------------------------------------------------------------
-- TYPE DEFINITIONS
-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
-- GLOBAL VARIABLES
-----------------------------------------------------------------------------*/

kDiffCfg_t kdiffCfg;

/*-----------------------------------------------------------------------------
-- IMPLEMENTATION
-----------------------------------------------------------------------------*/

KdiffTopLevel::KdiffTopLevel(KApplication * thisAppl, const char *name)
:KTopLevelWidget(name)
{

	QString pixdir;
	QPixmap pixmap;

	dprintf("KdiffTopLevel( >%p<, >%s< ) \n", thisAppl, name);

	application = thisAppl;
	config = thisAppl->getKApplication()->getConfig();

	KStdAccel kaccel(config);

	leftKfmConnection = 0;
	rightKfmConnection = 0;
	rightKurl = 0;
	leftKurl = 0;
	lastPath = QString("\0");
	differences = new KDiff();


	/* MenuBar
	   ---------- */
	menuBar = new KMenuBar(this, "kdiffMenuBar");

	filePm = new QPopupMenu();
	filePm->insertItem(i18n("&Open left ..."), this, SLOT(openLeft()), CTRL + Key_L);
	filePm->insertItem(i18n("Open &right ..."), this, SLOT(openRight()), CTRL + Key_R);
	filePm->insertSeparator();
	filePm->insertItem(i18n("&Quit"), this, SLOT(quitDiff()), kaccel.quit());
	menuBar->insertItem(i18n("&File"), filePm);

	diffPm = new QPopupMenu();
	doDiffID = diffPm->insertItem(i18n("&Do"), this, SLOT(doDiff()));
	prevDiffID = diffPm->insertItem(i18n("&Previous"), this, SLOT(prevDiff()), kaccel.prior());
	nextDiffID = diffPm->insertItem(i18n("&Next"), this, SLOT(nextDiff()), kaccel.next());
	menuBar->insertItem(i18n("&Difference"), diffPm);

	optionPm = new QPopupMenu();
	optionPm->insertItem(i18n("&Font ..."), this, SLOT(selDiffFont()));
	optionPm->insertItem(i18n("&Colors ..."), this, SLOT(selDiffColors()));
	optionPm->insertItem(i18n("&Diff options ..."), this,SLOT(changeDiffOpt()));
	showLineNrID = optionPm->insertItem(i18n("&Show Line Numbers"), this, SLOT(showLineNr()));
	optionPm->setItemChecked(showLineNrID, TRUE);
	optionPm->setCheckable(TRUE);
	optionPm->insertSeparator();
	optionPm->insertItem(i18n("&Save Options"), this, SLOT(writeKDiffConfig()));
	menuBar->insertItem(i18n("&Options"), optionPm);

	menuBar->insertSeparator();


	helpPm = new QPopupMenu();
	helpPm->insertItem(i18n("Contents ..."), this, SLOT(helpContents()), kaccel.help());
	// helpPm->insertItem( i18n("Index ... "), this, SLOT(helpIndex()));
	helpPm->insertSeparator();
	helpPm->insertItem(i18n("About ..."), this, SLOT(helpAbout()));
	menuBar->insertItem(i18n("&Help"), helpPm);

	setMenu(menuBar);


	/* ToolBar
	   ---------- */
	toolBar = new KToolBar(this, "kdiffToolbar");

	pixdir = application->kde_datadir() + "/kdiff/toolbar/";

	pixmap.load(pixdir + "openleft.xpm");
	toolBar->insertButton(pixmap, OPENLEFT_TBBTN, SIGNAL(clicked()), this, SLOT(openLeft()),
			      TRUE, i18n("Open left"));
  

	pixmap.load(pixdir + "openright.xpm");
	toolBar->insertButton(pixmap, OPENRIGHT_TBBTN, SIGNAL(clicked()), this, SLOT(openRight()),
			      TRUE, i18n("Open right"));

	pixmap.load(pixdir + "dodiff.xpm");
	toolBar->insertButton(pixmap, DODIFF_TBBTN, SIGNAL(clicked()), this, SLOT(doDiff()),
			      TRUE, i18n("Do differences"));

	pixmap.load(pixdir + "prev.xpm");
	toolBar->insertButton(pixmap, PREV_TBBTN, SIGNAL(clicked()), this, SLOT(prevDiff()),
			 TRUE, i18n("Previous difference"));

	pixmap.load(pixdir + "next.xpm");
	toolBar->insertButton(pixmap, NEXT_TBBTN, SIGNAL(clicked()), this, SLOT(nextDiff()),
			      TRUE, i18n("Next difference"));

	addToolBar(toolBar);



	/* MainView
	   ----------- */
	mainView = new QFrame(this);
        mainView->setFrameStyle(QFrame::NoFrame);
	grBox = new QGroupBox("", mainView);
	this->setBoxTitle();
	diffDisplay = new kdiffDisplay(grBox, "diffDisplay");

	setView(mainView);

	/* StatusBar
	   ------------ */
	statusBar = new KStatusBar(this, "status bar");
      statusBar->setInsertOrder(KStatusBar::RightToLeft);
	statusBar->insertItem("diff#:       ", STATUSBAR_DIFFCOUNT);
	statusBar->insertItem("100 %", STATUSBAR_PERCSHOW);
	statusBar->changeItem(" ", STATUSBAR_PERCSHOW);
	statusBar->insertItem("KDIFF-Application", STATUSBAR_ONE);
	statusBar->setAlignment(STATUSBAR_DIFFCOUNT, AlignRight);
	setStatusBar(statusBar);

	diffDisplay->setForeColor(application->windowTextColor);
	diffDisplay->setBackColor(application->windowColor);


	/* set values and read configuration
	   ------------------------------------- */
  readKDiffConfig();  // also assign the values

	/* slots for signals
	   --------------------- */
	connect(this->application, SIGNAL(kdisplayPaletteChanged()),
		this, SLOT(displayPaletteChanged()));

	connect(differences, SIGNAL(proceedState(int)),
		this, SLOT(slotProgressState(int)));


	/* KFM-Drop-Connection
	   ---------------------- */
	connect(diffDisplay, SIGNAL(leftDropAction(KDNDDropZone *)),
		this, SLOT(leftDropEvent(KDNDDropZone *)));

	connect(diffDisplay, SIGNAL(rightDropAction(KDNDDropZone *)),
		this, SLOT(rightDropEvent(KDNDDropZone *)));


	/* Filearguments ? 
	   ------------------ */
	for (int i = 1; i < application->argc(); i++) 
  {
		if (*(application->argv()[i]) != '-') 
    {
			QString f(application->argv()[i], 1024);

			if (f.find(":/") == -1 && f.left(1) != "/") 
      {
				char buffer[1024];
				getcwd(buffer, 1023);
				f.sprintf("file:%s/%s", buffer, application->argv()[i]);
			}
//     else
//				f.sprintf("file:%s", application->argv()[i]);


			if (leftKurl == 0)
				leftKurl = new KURL(f.data());
			else 
      {
        if (rightKurl == 0)
 				  rightKurl = new KURL(f.data());
			  else
				  break;	// left and right filename given
      }

		}// if (*(application->argv()[i]) != '-') 
	} //for (int i = 1; i < application->argc(); i++)     


  // left: file or ftp ?? 
  // -------------------- 
	if (leftKurl != 0) 
  {
    if ( strcmp( leftKurl->protocol(), "file" ) == 0 )
		{  
  		if (differences->setLeftFile(leftKurl) != 0) 
      {	KMsgBox errDialog(this, i18n("Error"), i18n("Error opening File:") + leftKurl->url(), KMsgBox::EXCLAMATION, "OK");
		  	errDialog.show();
			  delete leftKurl;
  			leftKurl = 0;
		  }
    }
    else
    { char leftTmpFname[128];

      if (leftKfmConnection != 0)
			  delete leftKfmConnection;

		  leftKfmConnection = new KFM;
		  leftUrl = leftKurl->path();
		  connect(leftKfmConnection, SIGNAL(finished()), this, SLOT(slotLeftKFMJobDone()));

		  sprintf(leftTmpFname, "file:/tmp/leftfile_%d", getpid());
		  leftKfmConnection->copy( leftKurl->url(), leftTmpFname);
    }
	}

  // right: file or ftp ?? 
  // -------------------- 
	if ( rightKurl != 0) 
  {
    if ( strcmp( rightKurl->protocol(), "file" ) == 0 )
		{  
       if (differences->setRightFile(rightKurl) != 0) 
       { KMsgBox errDialog(this, i18n("Error"), i18n("Error opening File:") + rightKurl->url(), KMsgBox::EXCLAMATION, "OK");
			   errDialog.show();
			   delete rightKurl;
			   rightKurl = 0;
		   }
    }
    else
    { char rightTmpFname[128];

      if (rightKfmConnection != 0)
			  delete rightKfmConnection;

		  rightKfmConnection = new KFM;
		  rightUrl = rightKurl->path();
		  connect(rightKfmConnection, SIGNAL(finished()), this, SLOT(slotRightKFMJobDone()));

		  sprintf(rightTmpFname, "file:/tmp/rightfile_%d", getpid());
		  rightKfmConnection->copy( rightKurl->url(), rightTmpFname);
    }
	} // if (rightKurl != 0) 



	this->setBoxTitle();
	this->setSensitive();


	/* execute diff
	   --------------- */
//	if (leftKurl != 0 && rightKurl != 0)
//		this->doDiff();


	dprintf("KdiffTopLevel( ... )=><\n");

}


//
// Name: void KdiffTopLevel::~KdiffTopLevel()
//
// Comment:
//
// Parameter:
//
// ReturnValue:
//
KdiffTopLevel::~KdiffTopLevel()
{
	if (differences != 0)
		delete differences;

}


//
// Name: void KdiffTopLevel::closeEvent( QCloseEvent *e )
//
// Comment:
//
// Parameter:
//
// ReturnValue:
//
void KdiffTopLevel::closeEvent(QCloseEvent * e)
{
	dprintf("closeEvent(>%p<)\n", e);
	application->quit();
	dprintf("closeEvent(...)=>void<\n");
}


//
// Name: void KdiffTopLevel::resizeEvent( QResizeEvent *e )
//
// Comment:
//
// Parameter:
//
// ReturnValue:
//
void KdiffTopLevel::resizeEvent(QResizeEvent * re)
{
	dprintf("resizeEvent(>%p<)\n", re);
	this->setBusy(TRUE);
      KTopLevelWidget::resizeEvent(re);
	grBox->setGeometry(5, 5, mainView->width() - 5, mainView->height() - 5);
	diffDisplay->setGeometry(5, 15, (diffDisplay->parentWidget())->width() - 10,
			   (diffDisplay->parentWidget())->height() - 20);
	this->setBusy(FALSE);
	dprintf("resizeEvent(...)=>void<\n");
}


//
// Name: void KdiffTopLevel::openLeft() 
//
// Comment: Slot for Menu "File->Open left()"
//
// Parameter:
//
// ReturnValue:
//
void KdiffTopLevel::openLeft()
{

	dprintf("START::openLeft()\n");

	KFileDialog openDia((const char *) lastPath, 0, this, "lopen", true, true);
	openDia.setCaption(i18n("Open left file"));

	openDia.show();
	if (openDia.result()) {

		this->setBusy(TRUE);

		if (!openDia.selectedFile().isEmpty()) {
			lastPath = openDia.dirPath();
			if (leftKurl != 0)
				delete leftKurl;

			leftKurl = new KURL(openDia.selectedFileURL());
			if (differences->setLeftFile(leftKurl) != 0) {

				KMsgBox errDialog(this, i18n("Error"),
						  i18n("Error opening File:") + openDia.selectedFile(),
					     KMsgBox::EXCLAMATION, "OK");

				errDialog.show();
				delete leftKurl;
				leftKurl = 0;
			}
			this->setBoxTitle();
			diffDisplay->clearDisplay();
		}
		this->setBusy(FALSE);

	}
	this->setSensitive();

	dprintf("END::openLeft()=>void<\n");
}				// End of Member: void KdiffTopLevel::openLeft()


//
// Name: void KdiffTopLevel::openRight() 
//
// Comment: Slot for Menu "File->Open right()"
//
// Parameter: void
//
// ReturnValue: void
//
void KdiffTopLevel::openRight()
{
	dprintf("START::openRight()\n");

	KFileDialog openDia((const char *) lastPath, 0, this, "ropen", true, true);

	openDia.setCaption(i18n("Open right file"));
	openDia.show();

	if (openDia.result()) {
		this->setBusy(TRUE);

		if (!openDia.selectedFile().isEmpty()) {
			lastPath = openDia.dirPath();

			if (rightKurl != 0)
				delete rightKurl;

			rightKurl = new KURL(openDia.selectedFileURL());
			if (differences->setRightFile(rightKurl) != 0) {
				KMsgBox errDialog(this, i18n("Error"),
						  i18n("Error opening File:") + openDia.selectedFile(),
					     KMsgBox::EXCLAMATION, "OK");
				errDialog.show();
				delete rightKurl;
				rightKurl = 0;
			}
			this->setBoxTitle();
			diffDisplay->clearDisplay();
		}
		this->setBusy(FALSE);

	}
	this->setSensitive();


	dprintf("END::openRight()=>void<\n");
}				// End of Member: void KdiffTopLevel::openRight()


//
// Name: void KdiffTopLevel::quitDiff()
//
// Comment: Slot for Menu "File->Quit()"
//
// Parameter: void
//
// ReturnValue: void
//
void KdiffTopLevel::quitDiff()
{
	dprintf("KdiffTopLevel::quitDiff()\n");
	application->quit();
	dprintf("KdiffTopLevel::quitDiff(...)=>void<\n");
}


//
// Name: void KdiffTopLevel::doDiff()
//
// Comment: Slot for Menu "Difference->Do"
//
// Parameter: void
//
// ReturnValue: void 
//
void KdiffTopLevel::doDiff()
{
	int i;

	dprintf("START::doDiff()\n");

	this->setBusy(TRUE);

	i = differences->doDifferences();

	dprintf("i=>%d<\n", i);

	switch (i) {
	case 0:
		// Ok
		diffDisplay->setText(differences);
		setSensitive();
		break;
	case -1:
		{
			KMsgBox errDialog1(this, i18n("Error"),
				 i18n("No left file given"),
					   KMsgBox::EXCLAMATION, "OK");
			errDialog1.show();
		}
		break;
	case -2:
		{
			KMsgBox errDialog2(this, i18n("Error"),
				i18n("No right file given"),
					   KMsgBox::EXCLAMATION, "OK");
			errDialog2.show();
		}
		break;
	case -3:
	default:
		{
			KMsgBox errDialog3(this, i18n("Error"),
			   i18n("Executing 'diff' command"),
					   KMsgBox::EXCLAMATION, "OK");
			errDialog3.show();
		}
		break;
	}

	this->setBusy(FALSE);

	dprintf("END::doDiff()=>void<\n");
}


//
// Name: void KdiffTopLevel::prevDiff()
//
// Comment: Slot for Menu "Difference->Previous"
//
// Parameter: void
//
// ReturnValue: void
//
void KdiffTopLevel::prevDiff()
{
	dprintf("START::prevDiff()\n");
	this->setBusy(TRUE);
	diffDisplay->displayPrevDiff();
	this->setBusy(FALSE);
	dprintf("END::prevDiff()=>void<\n");
}


//
// Name: void KdiffTopLevel::nextDiff()
//
// Comment: Slot for Menu "Difference->Next"
//
// Parameter: void
//
// ReturnValue: void
//
void KdiffTopLevel::nextDiff()
{
	dprintf("START::nextDiff()\n");
	this->setBusy(TRUE);
	diffDisplay->displayNextDiff();
	this->setBusy(FALSE);
	dprintf("END::nextDiff()=>void<\n");
}

//
// Name: void KdiffTopLevel::changeIgnoreOpt
//
// Comment: Slot for Menu 'options'->'diff options'
//
// Paramter: void
//
// Return Value: void
//
void KdiffTopLevel::changeDiffOpt()
{
	kDiffOptTD *diffOptTD = new kDiffOptTD( this , "diffOptDialog" );
	diffOptTD->show();
	delete diffOptTD;
}


//
// Name: void KdiffTopLevel::selDiffFont
//
// Comment: Slot for Menu "Options->Font"
//
// Parameter: void
//
// ReturnValue: void
//
void KdiffTopLevel::selDiffFont()
{
	dprintf("START::selDiffFont()\n");

	KFontDialog fontDialog(this, "fontDialog", TRUE);
	fontDialog.setFont(kdiffCfg.drawFontCfg);

	fontDialog.show();
	if (fontDialog.result()) {
		kdiffCfg.drawFontCfg = fontDialog.font();
		diffDisplay->setDisplayFont(kdiffCfg.drawFontCfg);
	}
	dprintf("END::selDiffFont()=>void<\n");
}


//
// Name: void KdiffTopLevel::selDiffColors()
//
// Comment: Slot for Menu "Options->Colors"
//
// Parameter: void
//
// ReturnValue: void
//
void KdiffTopLevel::selDiffColors()
{
	dprintf("START::selDiffColors\n");

	kdiffColorDialog kdcd(this, kdiffCfg.insertColorCfg, kdiffCfg.deleteColorCfg, kdiffCfg.changeColorCfg);
	kdcd.show();
	if (kdcd.result() == 1)	// if ( kdcd.result() )
 {
		kdiffCfg.insertColorCfg = kdcd.newInsertColor;
		kdiffCfg.changeColorCfg = kdcd.newChangeColor;
		kdiffCfg.deleteColorCfg = kdcd.newDeleteColor;
		diffDisplay->setInsertColor(kdiffCfg.insertColorCfg);
		diffDisplay->setChangeColor(kdiffCfg.changeColorCfg);
		diffDisplay->setDeleteColor(kdiffCfg.deleteColorCfg);
	}
	dprintf("END::selDiffColors()=>void<\n");
}


//
// Name: void KdiffTopLevel::showLineNr()
//
// Comment: Slot for Menu "Options->Show line numbers"
//
// Parameter: void
//
// ReturnValue: void
//
void KdiffTopLevel::showLineNr()
{
	this->setBusy(TRUE);
	optionPm->setItemChecked(showLineNrID, !optionPm->isItemChecked(showLineNrID));

	if (optionPm->isItemChecked(showLineNrID) == TRUE)
		kdiffCfg.showLineCfg = "T";
	else
		kdiffCfg.showLineCfg = "F";

	diffDisplay->showLineNr(optionPm->isItemChecked(showLineNrID));

	this->setBusy(FALSE);
}


//
// Name: void KdiffTopLevel::helpContents()
//
// Comment: Slot for Menu "Help->Contents"
//
// Parameter: void
//
// ReturnValue: void
//
void KdiffTopLevel::helpContents()
{
	dprintf("START::helpContents()\n");
	QString filename(APPNAME "/" APPNAME ".html");

	application->invokeHTMLHelp(filename, "");

	dprintf("END::helpContents()=>void<\n");
}


//
// Name: void KdiffTopLevel::helpIndex()
//
// Comment: 
//
// Parameter:
//
// ReturnValue:
//
void KdiffTopLevel::helpIndex()
{
	dprintf("START::helpIndex()\n");
	QString filename(APPNAME "/" APPNAME ".html");
	QString topic;

	application->invokeHTMLHelp(filename, "");
	dprintf("END::helpIndex()=>void<\n");
}


//
// Name: void KdiffTopLevel::helpAbout()
//
// Comment: Slot for Menu "Help->About"
//
// Parameter:
//
// ReturnValue:
//
void KdiffTopLevel::helpAbout()
{
	char aboutMsg[256];
	dprintf("START::helpAbout()\n");

	sprintf(aboutMsg, "%s %s\n" \
		"%s\n" \
		"by Matthias Hipp\n" \
		"mailto:matthias.hipp@gmx.de\n" \
		"http://home.braunschweig.netsurf.de/~matthias.hipp",
		APPNAME, APPVERS, i18n(APPCAPT));
	KMsgBox aboutDialog(this, i18n("About"),
			    aboutMsg, KMsgBox::INFORMATION, "OK");

	aboutDialog.show();

	dprintf("END::helpAbout()=>void<\n");
}


//
// Name: void KdiffTopLevel::displayPaletteChanged()
//
// Comment: Slot. Connected with kapplication->kdisplayPaletteChanged.
//
// Parameter:
//
// ReturnValue:
//
void KdiffTopLevel::displayPaletteChanged()
{
	dprintf("START::displayPaletteChanged()\n");

	diffDisplay->setBackColor(application->windowColor);

	dprintf("END::displayPaletteChanged()=>void<\n");

}


//
// Name: void KdiffTopLevel::leftDropEvent(KDNDDropZone *dropZone)
//
// Comment:
//
// Parameter:
//
// ReturnValue:
//
void KdiffTopLevel::leftDropEvent(KDNDDropZone * dropZone)
{

	QString dropped = dropZone->getData();

	dprintf("START::leftDropEvent(>%p<)\n", dropZone);

	if (leftKurl != 0)
		delete leftKurl;

	leftKurl = new KURL(dropped);

	this->setBusy(TRUE);

	if (strcmp(leftKurl->protocol(), "file") == 0) {
		differences->setLeftFile(leftKurl);
		diffDisplay->clearDisplay();
		this->setBoxTitle();
		this->setSensitive();
		this->setBusy(FALSE);
	} else {
		char leftTmpFname[128];

		if (leftKfmConnection != 0)
			delete leftKfmConnection;

		leftKfmConnection = new KFM;
		leftUrl = leftKurl->path();
		connect(leftKfmConnection, SIGNAL(finished()),
			this, SLOT(slotLeftKFMJobDone()));

		sprintf(leftTmpFname, "file:/tmp/leftfile_%d", getpid());
		leftKfmConnection->copy(dropped.data(), leftTmpFname);

	}

	dprintf("END::rightDropEvent()=>void<\n");
}


//
// Name: void KdiffTopLevel::rightDropEvent(KDNDDropZone *dropZone)
//
// Comment:user dropped a file in the right file area. if this file
//         dropped from the localhost the rightKurl will be filled
//         directly. Otherwise a ftp connection will be opened to 
//         get the file from the remote host.
//
// Parameter:
//
// ReturnValue:
//
void KdiffTopLevel::rightDropEvent(KDNDDropZone * dropZone)
{
	QString dropped = dropZone->getData();

	dprintf("START::rightDropEvent(>%p<)\n", dropZone);

	if (rightKurl != 0)
		delete rightKurl;

	rightKurl = new KURL(dropped);

	this->setBusy(TRUE);

	if (strcmp(rightKurl->protocol(), "file") == 0) {
		differences->setRightFile(rightKurl);
		diffDisplay->clearDisplay();
		this->setBoxTitle();
		this->setSensitive();
		this->setBusy(FALSE);
	} else {
		char rightTmpFname[128];

		if (rightKfmConnection != 0)
			delete rightKfmConnection;

		rightKfmConnection = new KFM;
		rightUrl = rightKurl->path();
		connect(rightKfmConnection, SIGNAL(finished()),
			this, SLOT(slotRightKFMJobDone()));

		sprintf(rightTmpFname, "file:/tmp/rightfile_%d", getpid());
		rightKfmConnection->copy(dropped.data(), rightTmpFname);

	}


	dprintf("END::rightDropEvent()=>void<\n");

}

//
// Name: void KdiffTopLevel::slotLeftKFMJobDone() 
//
// Comment:
//
// Parameter:
//
// ReturnValue:
//
void KdiffTopLevel::slotLeftKFMJobDone()
{
	char leftTmpFname[128];

	dprintf("START::slotLeftKFMJobDone()\n");

	delete leftKfmConnection;
	leftKfmConnection = 0;

	if (leftKurl != 0)
		delete leftKurl;

	sprintf(leftTmpFname, "file:/tmp/leftfile_%d", getpid());
	leftKurl = new KURL(leftTmpFname);

	if (differences->setLeftFile(leftKurl) != 0) {
		KMsgBox errDialog(this, i18n("Error"),
				  i18n("Error opening File:") + leftKurl->url(),
				  KMsgBox::EXCLAMATION, "OK");
		errDialog.show();
		delete leftKurl;
		leftKurl = 0;
	}
	this->setBoxTitle();
	diffDisplay->clearDisplay();
	this->setSensitive();

	this->setBusy(FALSE);

	dprintf("END::slotLeftKFMJobDone()=>void<\n");
}


//
// Name: void KdiffTopLevel::slotRightKFMJobDone() 
//
// Comment:
//
// Parameter:
//
// ReturnValue:
//
void KdiffTopLevel::slotRightKFMJobDone()
{
	char rightTmpFname[128];

	dprintf("START::slotRightKFMJobDone()\n");

	delete rightKfmConnection;
	rightKfmConnection = 0;

	if (rightKurl != 0)
		delete rightKurl;

	sprintf(rightTmpFname, "file:/tmp/rightfile_%d", getpid());
	rightKurl = new KURL(rightTmpFname);

	if (differences->setRightFile(rightKurl) != 0) {
		KMsgBox errDialog(this, i18n("Error"),
				  i18n("Error opening File:") + rightKurl->url(),
				  KMsgBox::EXCLAMATION, "OK");
		errDialog.show();
		delete rightKurl;
		rightKurl = 0;
	}
	this->setBoxTitle();
	diffDisplay->clearDisplay();
	this->setSensitive();

	this->setBusy(FALSE);

	dprintf("END::slotRightKFMJobDone()=>void<\n");
}


//
// Name: void KdiffTopLevel::slotProgressState() 
//
// Comment:
//
// Parameter:
//
// ReturnValue:
//
void KdiffTopLevel::slotProgressState(int percent)
{
	char str[25];

	dprintf("START::slotProgressState(>%d<)\n", percent);


	if (percent != PS_NOTHING_DONE) {
		sprintf(str, "%3d %%", percent);
	} else {
		strcpy(str, "     ");
	}

	statusBar->changeItem(str, STATUSBAR_PERCSHOW);
	application->processEvents();	//refresh it

	dprintf("END::slotProgressState()=>void<\n");
}


//
// Name: void KdiffTopLevel::setSensitive()
//
// Comment: Set menuentries and toolbar buttons sensitiv or insensitive
//          to reflect the current application state
//
// Parameter: void
//
// ReturnValue: void
//
void KdiffTopLevel::setSensitive()
{
	int diffcount;
	char statusBarTxt[64];
	dprintf("START::setSensitive()\n");
	if (diffDisplay->diffText != 0) {
		if ((diffcount = diffDisplay->diffText->hasDifferences()) > 0) {
			toolBar->setItemEnabled(PREV_TBBTN, TRUE);
			toolBar->setItemEnabled(NEXT_TBBTN, TRUE);
			diffPm->setItemEnabled(prevDiffID, TRUE);
			diffPm->setItemEnabled(nextDiffID, TRUE);

			sprintf(statusBarTxt, "diff#: %5d", diffcount);
			statusBar->changeItem(statusBarTxt, STATUSBAR_DIFFCOUNT);
		}
	} else {
		toolBar->setItemEnabled(PREV_TBBTN, FALSE);
		toolBar->setItemEnabled(NEXT_TBBTN, FALSE);
		diffPm->setItemEnabled(prevDiffID, FALSE);
		diffPm->setItemEnabled(nextDiffID, FALSE);
		statusBar->changeItem("diff#:     ", STATUSBAR_DIFFCOUNT);

	}

	if (differences->canDoDifferences() == TRUE) {
		toolBar->setItemEnabled(DODIFF_TBBTN, TRUE);
		diffPm->setItemEnabled(doDiffID, TRUE);
	} else {
		toolBar->setItemEnabled(DODIFF_TBBTN, FALSE);
		diffPm->setItemEnabled(doDiffID, FALSE);
	}

	dprintf("END::setSensitive()=>void<\n");
}


//
// Name: void KdiffTopLevel::readKDiffConfig()
//
// Comment: write the current configuration values to the application
//          config file.  ( ~/.kde/share/config/kdiffrc )
//
// Parameter:
//
// ReturnValue:
//
void KdiffTopLevel::readKDiffConfig()
{
	dprintf("START::readKDiffConfig()\n");

  assert( config != NULL );

 	config->setGroup("kdiff");
 	kdiffCfg.insertColorCfg = QColor("#5050F0");
 	kdiffCfg.insertColorCfg = config->readColorEntry("insertColor", &kdiffCfg.insertColorCfg);
 	if ( diffDisplay != NULL )
    diffDisplay->setInsertColor(kdiffCfg.insertColorCfg);
  
 	kdiffCfg.changeColorCfg = QColor("#50F050");
 	kdiffCfg.changeColorCfg = config->readColorEntry("changeColor", &kdiffCfg.changeColorCfg);
 	if ( diffDisplay != NULL )
   	diffDisplay->setChangeColor(kdiffCfg.changeColorCfg);
  
 	kdiffCfg.deleteColorCfg = QColor("#F05050");
 	kdiffCfg.deleteColorCfg = config->readColorEntry("deleteColor", &kdiffCfg.deleteColorCfg);
 	if ( diffDisplay != NULL )
 	  diffDisplay->setDeleteColor(kdiffCfg.deleteColorCfg);
  
 	kdiffCfg.showLineCfg = config->readBoolEntry("showLines", TRUE );
 	if ( diffDisplay != NULL )
   	diffDisplay->showLineNr(kdiffCfg.showLineCfg );
  
 	kdiffCfg.drawFontCfg = QFont("Courier", 12);
 	kdiffCfg.drawFontCfg = config->readFontEntry("displayFont", &kdiffCfg.drawFontCfg );
 	if ( diffDisplay != NULL )
 	  diffDisplay->setDisplayFont(kdiffCfg.drawFontCfg);
 
  kdiffCfg.differencesOnly = config->readBoolEntry ( "differencesOnly" ); 
 	kdiffCfg.ignoreCase =  config->readBoolEntry ( "ignoreCase" ); 
  kdiffCfg.ignoreSpaces =   config->readBoolEntry ( "ignoreSpaces" );
 	kdiffCfg.ignoreAllSpaces = config->readBoolEntry ( "ignoreAllSpaces" ); 
 	kdiffCfg.ignoreBlankLines =  config->readBoolEntry ( "ignoreBlankLines" ); 
 	kdiffCfg.ignoreRegExpLines =  config->readBoolEntry ( "ignoreRegExpLines" );
 	kdiffCfg.RegExp = config->readEntry ( "RegExp" );

  kdiffCfg.minimalDifferences = config->readBoolEntry ("minimalDifferences" );
  kdiffCfg.largeFiles = config->readBoolEntry ("largeFiles" );
	
  dprintf("END::readKDiffConfig()=>void<\n");

} // void KdiffTopLevel::readKDiffConfig()


//
// Name: void KdiffTopLevel::writeKDiffConfig()
//
// Comment: write the current configuration values to the application
//          config file.  ( ~/.kde/share/config/kdiffrc )
//
// Parameter:
//
// ReturnValue:
//
void KdiffTopLevel::writeKDiffConfig()
{
	dprintf("START::writeKDiffConfig()\n");

	config->setGroup("kdiff");
             
	(void) config->writeEntry("insertColor", kdiffCfg.insertColorCfg );
	(void) config->writeEntry("changeColor", kdiffCfg.changeColorCfg );
	(void) config->writeEntry("deleteColor", kdiffCfg.deleteColorCfg );
	(void) config->writeEntry("showLines",   kdiffCfg.showLineCfg );
	(void) config->writeEntry("displayFont", kdiffCfg.drawFontCfg );

  (void) config->writeEntry("ignoreCase",  kdiffCfg.ignoreCase );
  (void) config->writeEntry("ignoreBlankLines", kdiffCfg.ignoreBlankLines );
  (void) config->writeEntry("ignoreAllSpaces", kdiffCfg.ignoreAllSpaces );
  (void) config->writeEntry("ignoreSpaces", kdiffCfg.ignoreSpaces );
  (void) config->writeEntry("ignoreRegExpLines", kdiffCfg.ignoreRegExpLines );
  (void) config->writeEntry("RegExp", kdiffCfg.RegExp );
  (void) config->writeEntry("minimalDifferences", kdiffCfg.minimalDifferences );
  (void) config->writeEntry("largeFiles", kdiffCfg.largeFiles );
     
	config->sync();
 
	dprintf("END::writeKDiffConfig()=>void<\n");
}
 

 
//
// Name: void KdiffTopLevel::setBoxTitle()
//
// Comment:
//
// Parameter:
//
// ReturnValue:
//
void KdiffTopLevel::setBoxTitle()
{
	char title[512];

	dprintf("START::setBoxTitle()\n");


	strcpy(title, i18n("left file:"));
	if (leftKurl != 0)
		strcat(title, leftKurl->path());

	strcat(title, "  ");

	strcat(title, i18n("right file:"));
	if (rightKurl != 0)
		strcat(title, rightKurl->path());

	grBox->setTitle(title);

	dprintf("END::setBoxTitle()=>void<\n");
}

//
// Name: void KdiffTopLevel::setBusy()
//
// Comment:
//
// Parameter:
//
// ReturnValue:
//
void KdiffTopLevel::setBusy(bool busy)
{
	static bool Busy = FALSE;

	dprintf("START::setBusy( %d )\n", busy);
	if (busy != Busy) {
		if (busy == TRUE)
			this->setCursor(QCursor(waitCursor));
		else
			this->setCursor(QCursor(arrowCursor));
		Busy = busy;
	}
	dprintf("END::setBusy()=>void<\n");
}






