/******************************************************************************
**         File: $RCSfile$
**
**  Description:
**
**      Created: $Date$
**
**      Changes: $Revision$
**   $Log$ 
**
** Distribution: $Name$ 
******************************************************************************/
#ifndef KDIFFTOPLEVEL_H
#define KDIFFTOPLEVEL_H

#include "kdiff.h"

/*-----------------------------------------------------------------------------
-- SYSTEM INCLUDE FILE DECLARATIONS
-----------------------------------------------------------------------------*/
#include <kfm.h>
#include <kapp.h>
#include <ktopwidget.h>
#include <kconfig.h>
#include <kmenubar.h>
#include <ktoolbar.h>
#include <kstatusbar.h>
#include <kurl.h>

#include <qscrbar.h>
#include <qframe.h>
#include <qgrpbox.h>
#include <qfont.h>

/*-----------------------------------------------------------------------------
-- PRIVATE INCLUDE FILE DECLARATIONS
-----------------------------------------------------------------------------*/
#include "kdiff.h"
#include "kdiffDisplay.h"


/*-----------------------------------------------------------------------------
-- DEFINITIONS
-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
-- TYPE DEFINITIONS
-----------------------------------------------------------------------------*/
typedef struct {
	QColor insertColorCfg;
	QColor changeColorCfg;
	QColor deleteColorCfg;
	QFont drawFontCfg;

	bool showLineCfg;

	bool differencesOnly;


	bool ignoreCase;
	bool ignoreBlankLines;
	bool ignoreAllSpaces;
	bool ignoreSpaces;
	bool ignoreRegExpLines;
	QString RegExp;
	
	bool minimalDifferences;
	bool largeFiles;
} kDiffCfg_t;


class KdiffTopLevel : public KTopLevelWidget
{
	Q_OBJECT;

	public:
	KdiffTopLevel(KApplication * thisAppl, const char *name = 0);
	~KdiffTopLevel();

	void setBusy(bool busy);

  protected:


  public slots:

	void openLeft();	// Open first file ( left window )

	void openRight();	// Open second file ( right window )

	void quitDiff();	// Quit the application

	void doDiff();		// Execute the diff - command

	void prevDiff();	// show previous difference

	void nextDiff();	// show next difference

	void changeDiffOpt();	// change options for the diff program

	void selDiffFont();
	void selDiffColors();
	void showLineNr();

  void readKDiffConfig(); // Read and write the Configurationvalues.
	void writeKDiffConfig(); // Configvalues are in glob. var. kdiffCfg

	void helpContents();	// Call KDE-Help 

	void helpIndex();
	void helpAbout();	// Show About Dialog


	void displayPaletteChanged();	// Signal from KApplication


	void leftDropEvent(KDNDDropZone * dropZone);	// get file from kfm

	void rightDropEvent(KDNDDropZone * dropZone);	// get file from kfm

	void slotLeftKFMJobDone();	// get file done

	void slotRightKFMJobDone();	// get file done

	void slotProgressState(int percent);

	 private:

	KApplication * application;
	KConfig *config;



	// Toplevel-Widget-Items
	KMenuBar *menuBar;
	QPopupMenu *filePm;
	QPopupMenu *diffPm;
	QPopupMenu *optionPm;
	QPopupMenu *helpPm;

	KToolBar *toolBar;

	QFrame *mainView;
	QGroupBox *grBox;
	kdiffDisplay *diffDisplay;

	KStatusBar *statusBar;

	// Menubar and Toolbar ID's
	int doDiffID, prevDiffID, nextDiffID;
	int showLineNrID;


	KURL *leftKurl;
	KURL *rightKurl;
	QString lastPath;

	// KFM-Communication
	KFM *leftKfmConnection;
	const char *leftUrl;
	KFM *rightKfmConnection;
	const char *rightUrl;


	// the Difference - Class
	KDiff *differences;


	void setSensitive();
	void setBoxTitle();


	protected:
	 virtual void closeEvent(QCloseEvent * e);
	 virtual void resizeEvent(QResizeEvent * e);


};

#endif

