/******************************************************************************
**         File: $RCSfile$
**
**  Description:
**
**      Created: $Date$
**
**      Changes: $Revision$
**   $Log$ 
**
** Distribution: $Name$ 
******************************************************************************/   
#ifndef KDIFF_H
#define KDIFF_H

/*-----------------------------------------------------------------------------
-- SYSTEM INCLUDE FILE DECLARATIONS
-----------------------------------------------------------------------------*/
#include <qobject.h>
#include <qstring.h>
#include <kurl.h> 
#include <kprocess.h>

/*-----------------------------------------------------------------------------
-- PRIVATE INCLUDE FILE DECLARATIONS
-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
-- DEFINITIONS
-----------------------------------------------------------------------------*/

// Display Attributes for kDisplayText
#define DISPLAY_NORMAL  1
#define DISPLAY_DELETE  2
#define DISPLAY_INSERT  3
#define DISPLAY_CHANGE  4

// Definitions for Emitter proceedState
#define PS_NOTHING_DONE 0
#define PS_DIFF_START 10
#define PS_DIFF_FINISHED 30 
#define PS_OUTPUT_MERGED 50
#define PS_OUTPUT_LEFTTEXT 75
#define PS_OUTPUT_RIGHTTEXT 100
#define PS_DIFF_COMPLETE_FINISHED 100


/*-----------------------------------------------------------------------------
-- TYPE DEFINITIONS
-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
-- GLOBAL VARIABLES
-----------------------------------------------------------------------------*/


class kDifference
{
  public:
    kDifference( char *diffOutputLine );

    ~kDifference();   

    int type;
    int leftS, leftE, rightS, rightE;

  private:

 
  protected:

};

class kDisplayText
{
  public:
    kDisplayText( char *line, int fline, int dline, short attr );
    ~kDisplayText();
   
    unsigned int   fLine;    // Line in File
    unsigned int   dLine;    // Line in Display
    char  *lineStr;
    short attribut;  

};


class KDiff: public QObject
{
  Q_OBJECT
   public:

     KDiff ( KURL *leftFile = 0, KURL *rightFile = 0 );       
     //Destructor
     ~KDiff ();
     
     int setLeftFile( KURL *leftFile );
     int setRightFile( KURL *rightFile );

     bool canDoDifferences();

     /* 0 = done, list is ready; */
     /* -1 = leftFile */
     /* -2 = rightFile */
     /* -5 = execute error */
     int doDifferences();

     int hasDifferences();

     kDisplayText *getLeftFileText( unsigned int flineNr );
     kDisplayText *getLeftDisplayText( unsigned int dlineNr );
     kDisplayText *getRightFileText( unsigned int flineNr );
     kDisplayText *getRightDisplayText( unsigned int dlineNr );

     int getLeftLineCount();
     int getRightLineCount();
    
     int getMaxLeftLineLenght();
     int getMaxRightLineLenght();
    
     int getPrevDiffLine( unsigned int startDline );
     int getNextDiffLine( unsigned int startDline );


   signals:
     void proceedState( int percent ); // 10 diff started
                                       // 30 diff finished
                                       // 50 diff output to dList
                                       // 75 dlist merged with file to leftTextList
                                       // 100 dlist merged with file to rightTextList


   private:
     int loadFile( const char *fname, QString& dest );
     char *getLine( char *str ); // delete the resulting string
     void parseDiffOutput( const char *leftTxt, const char *rightTxt, const char *diffOutStr );

     kDifference *leftDifferenceType( int lineNr );
     kDifference *rightDifferenceType( int lineNr );

     KURL *lFile, *rFile;   

     QString leftText, rightText;       // Text from loaded files (lFile & rFile)
     QString diffStdoutStr;             // STDOUT from diff-process
     QString diffStderrStr;             // STDERR from diff-process

     KProcess *diffProcess;             // Instance to start diff


     QList<kDifference> *dList;         // list with rebuild diff-output
     QList<kDisplayText> *leftTextList; // merged diff-output and file contents
     QList<kDisplayText> *rightTextList;// this text-lists will be displayed

   protected:

   public slots:
     void diffStdout( KProcess*, char*, int );
     void diffStderr( KProcess*, char*, int );

};


#endif
