 /*
      This file is or will be part of KDE desktop environment
 */

#include <qtimer.h>
#include <qstrlist.h>

#include <kapp.h>
#include <kfm.h>

#include "kdirwatch.h"

#define NO_NOTIFY (time_t) 0

 // CHANGES:
 // Mar 28. 1998 - Created - sven <sven@lisa.exp.univie.ac.at>

 // Mar 29. 1998 - added docs, stop/restart for particular Dirs and
 // deep copies for list of dirs - sven <sven@lisa.exp.univie.ac.at>


KDirWatch *KDirWatch::mySelf = 0L;

KDirWatch::KDirWatch (int _freq)
{
  kfm = new KFM();
  timer = new QTimer(this);
  dirList = new QStrList(true); //deep copies - better safe then segfault
  connect (timer, SIGNAL(timeout()), this, SLOT(slotRescan()));
  freq=_freq;
  mySelf = this;
}

KDirWatch::~KDirWatch()
{
  timer->stop();
  delete timer;
  delete dirList;
  delete kfm;
}

void KDirWatch::addDirListEntry(const char *url)
{
  int i;

  i=dirList->find(url);
  if (i != -1)
      return; // i.e. we have it allready
  dirList->append(url);
  stat (&url[5], &statbuff);
  ctime[dirList->at()] = statbuff.st_ctime;
  if (dirList->count() == 1) // if this was first entry (=timer was stopped)
    timer->start(freq);      // then start the timer
}

void KDirWatch::removeDirListEntry(const char *url)
{
  if (dirList->isEmpty())
    return;
  
  int i;
  
  i=dirList->find(url);
  if (i == -1)
    return; // we don't have it
  dirList->remove(dirList->at());
  if (dirList->isEmpty())
    timer->stop(); // stop timer if list empty
}

bool KDirWatch::stopDirScan(const char *_url)
{
  if (dirList->isEmpty())
    return false;

  int i;

  i=dirList->find(_url);
  if (i == -1)
    return false; // we don't have it
  ctime[i] = NO_NOTIFY;
  return true;
}

bool KDirWatch::restartDirScan(const char *_url)
{
  if (dirList->isEmpty())
    return false;

  int i;

  i=dirList->find(_url);
  if (i == -1)
    return false; // we don't have it
  stat (&_url[5], &statbuff);
  ctime[i] = statbuff.st_ctime;
  return true;
}

void KDirWatch::stopScan()
{
  timer->stop();
}

void KDirWatch::startScan(bool notify, bool skippedToo)
{
  if (!notify)
    resetList(skippedToo);
  timer->start(freq);
}

QStrList *KDirWatch::getDirlist()
{
  return dirList;
}

// Protected:

void KDirWatch::resetList(bool skippedToo)
{
  if (dirList->isEmpty())
    return;
  
  char *dir;
  for (dir = dirList->first(); dir; dir = dirList->next())
  {
    if (ctime[dirList->at()] != NO_NOTIFY || skippedToo)
    stat (&dir[5], &statbuff);
    ctime[dirList->at()] = statbuff.st_ctime;
  }
}

void KDirWatch::slotRescan()
{
  char *dir;
  for (dir = dirList->first(); dir; dir = dirList->next())
  {
    stat (&dir[5], &statbuff);
    if (statbuff.st_ctime != ctime[dirList->at()])
      if (ctime[dirList->at()] != NO_NOTIFY)
      {
        notifyKFM(dir);
        ctime[dirList->at()] = statbuff.st_ctime;
      }
      else
      {
        debug ("changed but skipped:");
        debug(dir);
      }
  }
}

void KDirWatch::notifyKFM (const char *url)
{
  kfm->refreshDirectory(url);
  debug ("Notified:");
  debug (url);
}

/*******************************************************************/

int main (int argc, char **argv)
{

  debug ("You must create directory test in your home");
  debug ("Directory test will be watched, but skipped");
  debug ("When test is changed, you will be notified on console");
  debug ("Open kfms on home and test and move/copy files between them and root");
  debug ("Note that there will allways be output for test");

  KDirWatch *dirwatch;

  KApplication a(argc, argv);
  dirwatch = new KDirWatch();

  QString home = getenv ("HOME");
  QString desk = getenv ("HOME");
  home.prepend("file:");
  desk.prepend("file:");
  desk.append("/Desktop/");
  home.append("/");
  debug ("Watching:");
  debug (home.data());
  debug (desk.data());
  dirwatch->addDirListEntry(home.data());
  home.append("test/");
  dirwatch->addDirListEntry(home.data());
  dirwatch->addDirListEntry(desk.data());
  debug ("Watching: (but skipped)");
  debug (home.data());

  dirwatch->startScan();
  if (!dirwatch->stopDirScan(home.data()))
    debug ("stopDirScan: error");
  
  return a.exec();
}

#include <kdirwatch.moc>

//sven