/*
	main.cpp - part of KDiskCat the KDE Disk Catalog.

	Copyright (c) 1998,1999 Balzs Ternyi <terenyi@freemail.c3.hu>

	KDiskCat is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
			
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
					
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <kapp.h>
#include <kwm.h>
#include "kdiskcat.h"
#include "prefs.h"

//GLOBAL DEFINITIONS, AND VARIABLES

const QString applet_name="KDiskCat";
QString kdiskcat_data_dir=".kdiskcat";
const char* KDISKCAT_VERSION_INFO="KDISKCAT1.0";
const char* VERSION_NUMBER="0.5.3";
char list_separator='|';
Kdiskcat* kdiskcat;
CatHandler* cat;
CategoryHandler* cathandler;
Prefs* prefs;

void micro(QString* the_text)
{
   if (kdiskcat != 0)
   {
      kdiskcat->statusBar()->changeItem(i18n((const char*) *the_text),kdiskcat->STATUSBAR_TEXT);
      kdiskcat->statusBar()->repaint();
      kapp->processEvents();
   }
}

/*void setDiskStatus(bool onoff)
{
   if (kdiskcat != 0)
   {
      if (onoff)
      {
         kdiskcat->statusBar()->changeItem(i18n("DISK"),kdiskcat->STATUSBAR_DISK);
         kdiskcat->statusBar()->repaint();
         kapp->processEvents();
      }
      else
      {
         kdiskcat->statusBar()->changeItem("",kdiskcat->STATUSBAR_DISK);
         kdiskcat->statusBar()->repaint();
         kapp->processEvents();
      }
   }
}*/

void setTitle(const char * the_text)
{
   if (kdiskcat != 0)
   {
      if (strlen(the_text)==0)
      {
         kdiskcat->setCaption((const char*) applet_name);
      }
      else
      {
         kdiskcat->setCaption((const char*) (applet_name+" - "+the_text));
      }
   }
}

int main(int argc, char* argv[])
{
  KApplication a(argc,argv,"kdiskcat");  
 
  if (a.isRestored())
  {
	 RESTORE(Kdiskcat);
  }
  else {
    kdiskcat = new Kdiskcat;
    a.setMainWidget(kdiskcat);
    a.setTopWidget(kdiskcat);
    setTitle("");
    kdiskcat->show();
  }
  return a.exec();
}