/***************************************************************************
                          kdu.cpp  -  description
                             -------------------
    begin                : Wed Nov 24 11:21:57 EST 1999
    copyright            : (C) 1999 by David Beattie
    email                : dbeattie@softhome.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for QT
#include <qdir.h>
#include <qstrlist.h>
#include <qprinter.h>
#include <qpainter.h>

// include files for KDE
#include <kiconloader.h>
#include <kmsgbox.h>
#include <kfiledialog.h>

// application specific includes
#include "kdu.h"
#include "kduview.h"
#include "resource.h"


KduApp::KduApp()
{
  config=kapp->getConfig();

  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initMenuBar();
  initToolBar();
  initStatusBar();
  initKeyAccel();
  initView();
	
  readOptions();

  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar items at startup
  disableCommand(ID_FILE_PRINT);
 	
  disableCommand(ID_EDIT_CUT);
  disableCommand(ID_EDIT_COPY);
  disableCommand(ID_EDIT_PASTE);
}

KduApp::~KduApp()
{

}

void KduApp::initKeyAccel()
{
  keyAccel = new KAccel(this);
	
  // fileMenu accelerators
  keyAccel->connectItem(KAccel::Close, this, SLOT(slotFileClose()));
  keyAccel->connectItem(KAccel::Print, this, SLOT(slotFilePrint()));
  keyAccel->connectItem(KAccel::Quit, this, SLOT(slotFileQuit()));
  // editMenu accelerators
  //keyAccel->connectItem(KAccel::Cut, this, SLOT(slotEditCut()));
  //keyAccel->connectItem(KAccel::Copy, this, SLOT(slotEditCopy()));
  //keyAccel->connectItem(KAccel::Paste, this, SLOT(slotEditPaste()));

  keyAccel->connectItem(KAccel::Help, kapp, SLOT(appHelpActivated()));
			
  keyAccel->changeMenuAccel(fileMenu, ID_FILE_CLOSE, KAccel::Close);
  keyAccel->changeMenuAccel(fileMenu, ID_FILE_PRINT, KAccel::Print);
  keyAccel->changeMenuAccel(fileMenu, ID_FILE_QUIT, KAccel::Quit);

  //keyAccel->changeMenuAccel(editMenu, ID_EDIT_CUT, KAccel::Cut);
  //keyAccel->changeMenuAccel(editMenu, ID_EDIT_COPY, KAccel::Copy);
  //keyAccel->changeMenuAccel(editMenu, ID_EDIT_PASTE, KAccel::Paste);

  keyAccel->readSettings();	
}

void KduApp::initMenuBar()
{
  ///////////////////////////////////////////////////////////////////
  // MENUBAR

  ///////////////////////////////////////////////////////////////////
  // menuBar entry fileMenu
  fileMenu = new QPopupMenu();
  fileMenu->insertItem(kapp->getMiniIcon(), i18n("New &Window"), ID_FILE_NEW_WINDOW);
  fileMenu->insertSeparator();
  fileMenu->insertItem(i18n("&Close"), ID_FILE_CLOSE);
  fileMenu->insertSeparator();
  fileMenu->insertItem(Icon("fileprint.xpm"), i18n("&Print..."), ID_FILE_PRINT);
  fileMenu->insertSeparator();
  fileMenu->insertItem(i18n("E&xit"), ID_FILE_QUIT);
	
  ///////////////////////////////////////////////////////////////////
  // menuBar entry editMenu
  //editMenu = new QPopupMenu();
  //editMenu->insertItem(Icon("editcut.xpm"), i18n("Cu&t"), ID_EDIT_CUT);
  //editMenu->insertItem(Icon("editcopy.xpm"), i18n("&Copy"), ID_EDIT_COPY);
  //editMenu->insertItem(Icon("editpaste.xpm"), i18n("&Paste"), ID_EDIT_PASTE);

  ///////////////////////////////////////////////////////////////////
  // menuBar entry viewMenu
  viewMenu = new QPopupMenu();
  viewMenu->setCheckable(true);
  viewMenu->insertItem(i18n("&Toolbar"), ID_VIEW_TOOLBAR);
  viewMenu->insertItem(i18n("&Statusbar"), ID_VIEW_STATUSBAR);
	viewMenu->insertItem(i18n("Sort by &Name"), ID_VIEW_SORTBYNAME);
	viewMenu->insertItem(i18n("Sort by Si&ze"), ID_VIEW_SORTBYSIZE);

  ///////////////////////////////////////////////////////////////////
  // menuBar entry helpMenu
  QString aboutstring=kapp->appName()+" "+VERSION+"\n\n";

  helpMenu = new QPopupMenu();
  helpMenu = kapp->getHelpMenu(true, aboutstring);

  ///////////////////////////////////////////////////////////////////
  // MENUBAR CONFIGURATION
  // insert your popup menus with the according menubar entries in the order
  // they will appear later from left to right
  menuBar()->insertItem(i18n("&File"), fileMenu);
  //menuBar()->insertItem(i18n("&Edit"), editMenu);
  menuBar()->insertItem(i18n("&View"), viewMenu);

  menuBar()->insertSeparator();
  menuBar()->insertItem(i18n("&Help"), helpMenu);

  ///////////////////////////////////////////////////////////////////
  // CONNECT THE MENU SLOTS WITH SIGNALS
  // for execution slots and statusbar messages

  connect(fileMenu, SIGNAL(activated(int)), SLOT(commandCallback(int)));
  connect(fileMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));

  //connect(editMenu, SIGNAL(activated(int)), SLOT(commandCallback(int)));
  //connect(editMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));

  connect(viewMenu, SIGNAL(activated(int)), SLOT(commandCallback(int)));
  connect(viewMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));

}

void KduApp::initToolBar()
{

  ///////////////////////////////////////////////////////////////////
  // TOOLBAR
  //toolBar()->insertButton(Icon("fileprint.xpm"), ID_FILE_PRINT, true, i18n("Print"));
  //toolBar()->insertSeparator();
  //toolBar()->insertButton(Icon("editcut.xpm"), ID_EDIT_CUT, true, i18n("Cut"));
  //toolBar()->insertButton(Icon("editcopy.xpm"), ID_EDIT_COPY, true, i18n("Copy"));
  //toolBar()->insertButton(Icon("editpaste.xpm"), ID_EDIT_PASTE, true, i18n("Paste"));
  //toolBar()->insertSeparator();
  //toolBar()->insertButton(Icon("help.xpm"), ID_HELP_CONTENTS, SIGNAL(clicked()),
  //				kapp, SLOT(appHelpActivated()), true,i18n("Help"));

  ///////////////////////////////////////////////////////////////////
  // INSERT YOUR APPLICATION SPECIFIC TOOLBARS HERE WITH toolBar(n)


  ///////////////////////////////////////////////////////////////////
  // CONNECT THE TOOLBAR SLOTS WITH SIGNALS - add new created toolbars by their according number
  // connect for invoking the slot actions
  //connect(toolBar(), SIGNAL(clicked(int)), SLOT(commandCallback(int)));
  // connect for the status help on holing icons pressed with the mouse button
  //connect(toolBar(), SIGNAL(pressed(int)), SLOT(statusCallback(int)));
	toolBar();
}

void KduApp::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  // STATUSBAR
  // TODO: add your own items you need for displaying current application status.
  statusBar()->insertItem(i18n(IDS_STATUS_DEFAULT), ID_STATUS_MSG);
}

void KduApp::initView()
{ 
  ////////////////////////////////////////////////////////////////////
  // create the main widget here that is managed by KTMainWindow's view-region and
  // connect the widget to your document to display document contents.

  view = new KduView(this);
  setView(view);
  QString caption=kapp->getCaption();	
  setCaption(caption);

}

void KduApp::enableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // enable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_, true);
  toolBar()->setItemEnabled(id_, true);
}

void KduApp::disableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_, false);
  toolBar()->setItemEnabled(id_, false);
}

void KduApp::addRecentFile(const QString &file)
{
  if(recentFiles.find(file) == -1)
  {
    if( recentFiles.count() < 5)
    {
      recentFiles.insert(0, file);
    }
    else
    {
      recentFiles.remove(4);
      recentFiles.insert(0, file);
    }
    recentFilesMenu->clear();
    for ( int i=0 ; i < (int) recentFiles.count(); i++)
    {
      recentFilesMenu->insertItem(recentFiles.at(i));
    }
  }
}

KduView *KduApp::getView() const
{
	return view;
}

void KduApp::saveOptions()
{	
  config->setGroup("General Options");
  config->writeEntry("Geometry", size());
  config->writeEntry("Show Toolbar", toolBar()->isVisible());
  config->writeEntry("Show Statusbar",statusBar()->isVisible());
	config->writeEntry("Sort By",viewMenu->isItemChecked(ID_VIEW_SORTBYNAME) ? "Name" :
	                             viewMenu->isItemChecked(ID_VIEW_SORTBYSIZE) ? "Size" : "None");
  config->writeEntry("MenuBarPos", (int) menuBar()->menuBarPos());
  config->writeEntry("ToolBarPos", (int) toolBar()->barPos());
  config->writeEntry("Recent Files", recentFiles);
}


void KduApp::readOptions()
{
	
  config->setGroup("General Options");

  // bar status settings
  bool bViewToolbar = config->readBoolEntry("Show Toolbar", false);
  viewMenu->setItemChecked(ID_VIEW_TOOLBAR, bViewToolbar);
  if(!bViewToolbar)
  {
     enableToolBar(KToolBar::Hide);
  }
	
  bool bViewStatusbar = config->readBoolEntry("Show Statusbar", true);
  viewMenu->setItemChecked(ID_VIEW_STATUSBAR, bViewStatusbar);
  if(!bViewStatusbar)
  {
    enableStatusBar(KStatusBar::Hide);
  }

	QString sSortBy = config->readEntry("Sort By", "None");
	if (sSortBy == "Name") {
		viewMenu->setItemChecked(ID_VIEW_SORTBYNAME, true);
		view->setSorting(0);
	} else if (sSortBy == "Size") {
		viewMenu->setItemChecked(ID_VIEW_SORTBYSIZE, true);
		view->setSorting(1,false);
	} else {
		view->setSorting(-1);
	}

  // bar position settings
  KMenuBar::menuPosition menuBarPos;
  menuBarPos=(KMenuBar::menuPosition) config->readNumEntry("MenuBarPos", KMenuBar::Top);

  KToolBar::BarPosition toolBarPos;
  toolBarPos=(KToolBar::BarPosition) config->readNumEntry("ToolBarPos", KToolBar::Top);

  menuBar()->setMenuBarPos(menuBarPos);
  toolBar()->setBarPos(toolBarPos);
	
  // initialize the recent file list
  recentFiles.setAutoDelete(TRUE);
  config->readListEntry("Recent Files", recentFiles);
	
  for (int i=0; i < (int) recentFiles.count(); i++)
  {
    recentFilesMenu->insertItem(recentFiles.at(i));
  }

  QSize size=config->readSizeEntry("Geometry");
  if(!size.isEmpty())
  {
    resize(size);
  }
}

void KduApp::saveProperties(KConfig *_cfg)
{

}


void KduApp::readProperties(KConfig* _cfg)
{
  QString caption=kapp->getCaption();	
  setCaption(caption);
}		

bool KduApp::queryExit()
{
  saveOptions();
  return true;
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

void KduApp::slotFileNewWindow()
{
  slotStatusMsg(i18n("Opening a new application window..."));
	
  KduApp *new_window= new KduApp();
  new_window->show();

  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

void KduApp::slotFileClose()
{
  slotStatusMsg(i18n("Closing file..."));
	
  close();
  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

void KduApp::slotFilePrint()
{
  slotStatusMsg(i18n("Printing..."));

  QPrinter printer;
  if (printer.setup(this))
  {
    view->print(&printer);
  }

  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

void KduApp::slotFileQuit()
{
  slotStatusMsg(i18n("Exiting..."));
  saveOptions();
  // close the first window, the list makes the next one the first again.
  // This ensures that queryClose() is called on each window to ask for closing
  KTMainWindow* w;
  if(memberList)
  {
    for(w=memberList->first(); w!=0; w=memberList->first())
    {
      // only close the window if the closeEvent is accepted. If the user presses Cancel on the saveModified() dialog,
      // the window and the application stay open.
      if(!w->close())
	break;
    }
  }	
  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

void KduApp::slotEditCut()
{
  slotStatusMsg(i18n("Cutting selection..."));

  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

void KduApp::slotEditCopy()
{
  slotStatusMsg(i18n("Copying selection to clipboard..."));

  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

void KduApp::slotEditPaste()
{
  slotStatusMsg(i18n("Inserting clipboard contents..."));

  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

void KduApp::slotViewToolBar()
{
  slotStatusMsg(i18n("Toggle the toolbar..."));
  ///////////////////////////////////////////////////////////////////
  // turn Toolbar on or off
  if( viewMenu->isItemChecked(ID_VIEW_TOOLBAR))
  {
    viewMenu->setItemChecked(ID_VIEW_TOOLBAR, false);
    enableToolBar(KToolBar::Hide);
  }
  else
  {
    viewMenu->setItemChecked(ID_VIEW_TOOLBAR, true);
    enableToolBar(KToolBar::Show);
  }		

  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

void KduApp::slotViewStatusBar()
{
  slotStatusMsg(i18n("Toggle the statusbar..."));
  ///////////////////////////////////////////////////////////////////
  //turn Statusbar on or off
  if( viewMenu->isItemChecked(ID_VIEW_STATUSBAR))
  {
    viewMenu->setItemChecked(ID_VIEW_STATUSBAR, false);
    enableStatusBar(KStatusBar::Hide);
  }
  else
  {
    viewMenu->setItemChecked(ID_VIEW_STATUSBAR, true);
    enableStatusBar(KStatusBar::Show);
  }

  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}


void KduApp::slotStatusMsg(const QString &text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  statusBar()->clear();
  statusBar()->changeItem(text, ID_STATUS_MSG);
}


void KduApp::slotStatusHelpMsg(const QString &text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message of whole statusbar temporary (text, msec)
  statusBar()->message(text, 2000);
}



void KduApp::commandCallback(int id_)
{
  switch (id_)
  {
    case ID_FILE_NEW_WINDOW:
         slotFileNewWindow();
    	 break;

    case ID_FILE_CLOSE:
         slotFileClose();
         break;

    case ID_FILE_PRINT:
         slotFilePrint();
         break;

    case ID_FILE_QUIT:
         slotFileQuit();
         break;

    case ID_EDIT_CUT:
         slotEditCut();
         break;

    case ID_EDIT_COPY:
         slotEditCopy();
         break;

    case ID_EDIT_PASTE:
         slotEditPaste();
         break;
  
    case ID_VIEW_TOOLBAR:
         slotViewToolBar();
         break;

    case ID_VIEW_STATUSBAR:
         slotViewStatusBar();
         break;

		case ID_VIEW_SORTBYNAME:
         slotViewSortByName();
         break;

		case ID_VIEW_SORTBYSIZE:
         slotViewSortBySize();
         break;

    default:
         break;
  }
}

void KduApp::statusCallback(int id_)
{
  switch (id_)
  {
    case ID_FILE_NEW_WINDOW:
         slotStatusHelpMsg(i18n("Opens a new application window"));
         break;

    case ID_FILE_CLOSE:
         slotStatusHelpMsg(i18n("Closes the actual document"));
         break;

    case ID_FILE_PRINT:
         slotStatusHelpMsg(i18n("Prints out the actual document"));
         break;

    case ID_FILE_QUIT:
         slotStatusHelpMsg(i18n("Quits the application"));
         break;

    case ID_EDIT_CUT:
         slotStatusHelpMsg(i18n("Cuts the selected section and puts it to the clipboard"));
         break;

    case ID_EDIT_COPY:
         slotStatusHelpMsg(i18n("Copies the selected section to the clipboard"));
         break;

    case ID_EDIT_PASTE:
         slotStatusHelpMsg(i18n("Pastes the clipboard contents to actual position"));
         break;

    case ID_VIEW_TOOLBAR:
         slotStatusHelpMsg(i18n("Enables/disables the toolbar"));
         break;

    case ID_VIEW_STATUSBAR:
         slotStatusHelpMsg(i18n("Enables/disables the statusbar"));
         break;

		case ID_VIEW_SORTBYNAME:
         slotStatusHelpMsg(i18n("Sorts the display by name"));
         break;

    case ID_VIEW_SORTBYSIZE:
         slotStatusHelpMsg(i18n("Sorts the display by disk usage"));
         break;

    default:
         break;
  }
}

/**  */
void KduApp::slotViewSortByName()
{
  slotStatusMsg(i18n("Sort by name..."));
  ///////////////////////////////////////////////////////////////////
  //turn sorting by name on or off
  if( viewMenu->isItemChecked(ID_VIEW_SORTBYNAME))
  {
    viewMenu->setItemChecked(ID_VIEW_SORTBYNAME, false);
		view->setSorting(-1);
  }
  else
  {
    viewMenu->setItemChecked(ID_VIEW_SORTBYNAME, true);
		viewMenu->setItemChecked(ID_VIEW_SORTBYSIZE, false);
    view->setSorting(0);
  }
  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}
/**  */
void KduApp::slotViewSortBySize()
{
  slotStatusMsg(i18n("Sort by disk usage..."));
  ///////////////////////////////////////////////////////////////////
  //turn sorting by size on or off
  if( viewMenu->isItemChecked(ID_VIEW_SORTBYSIZE))
  {
    viewMenu->setItemChecked(ID_VIEW_SORTBYSIZE, false);
		view->setSorting(-1);
  }
  else
  {
    viewMenu->setItemChecked(ID_VIEW_SORTBYSIZE, true);
		viewMenu->setItemChecked(ID_VIEW_SORTBYNAME, false);
    view->setSorting(1,false);
  }
  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

