/*************************************************************************
 *                                                                       *
 *  KDu - KDisk Free V0.9.5                                              *
 *                                                                       *
 * Copyright(c) 1998-99 Christian Poulter.                               *
 *                                                                       *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation - version 2.                             *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License in file COPYING for more details.          *
 *                                                                       *
 * You should have received a copy of the GNU General Public License     *
 * along with this program; if not, write to the Free Software           *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
 *                                                                       *
 *  On the Net at http://www.wilhelmshaven-online.de/benutzer/cpoulter   *
 *  Email to virtual-dynamics@gmx.net                                    *
 *                                                                       *
 *************************************************************************/

#include "global.h"
#include "kdconfig.h"

#include <kapp.h>

KDConfig::~KDConfig(){
	save();
}

KDConfig::KDConfig(){
	unknown_fs=false;
	load();
}

void KDConfig::save(){
	QString entry;

	KConfigBase *config;
	config=	KApplication::getKApplication()->getConfig();
	config->setGroup("Global");

	if (unknown_fs == true) entry = "yes"; else entry = "no";
  	config->writeEntry("Unknown_FS", entry);
	config->writeEntry("Update_Freq",update_freq);

	config->setGroup("Icons");
	config->writeEntry("unknown",icon_unknown);
	config->writeEntry("minix",icon_minix);
	config->writeEntry("ext2",icon_ext2);
	config->writeEntry("vfat_fd",icon_vfat_fd);
	config->writeEntry("vfat_hd",icon_vfat_hd);
	config->writeEntry("nfs",icon_nfs);
	config->writeEntry("smbfs",icon_smbfs);
	config->writeEntry("iso9660",icon_iso9660);
	config->writeEntry("msdos",icon_msdos);
	config->writeEntry("hfs",icon_hfs);
	config->writeEntry("unmounted",icon_unmounted);

	config->setGroup("Dock_MPs");
	config->writeEntry("dock_mp_1",dock_mp[0]);
	config->writeEntry("dock_mp_2",dock_mp[1]);
	config->writeEntry("dock_mp_3",dock_mp[2]);
	config->writeEntry("dock_mp_4",dock_mp[3]);

	config->setGroup("Colors");
	config->writeEntry("Disk_Free",color_disk_free);
	config->writeEntry("Disk_Full",color_disk_full);
	config->writeEntry("Disk_Unmounted",color_disk_umounted);

	config->sync();
}

void KDConfig::load(){
	QString entry;

	KConfigBase *cfg;
	cfg=	KApplication::getKApplication()->getConfig();
	cfg->setGroup("Global");

	entry = "no";
	if ( cfg->readEntry("Unknown_FS", entry) == entry)
		unknown_fs=false;
	else
		unknown_fs=true;

	update_freq=cfg->readNumEntry("Update_Freq",DEFAULT_UPDATE_FREQ);

	cfg->setGroup("Icons");
	icon_unknown=cfg->readEntry("unknown",DEFAULT_ICON_UNKNOWN);
	icon_minix=cfg->readEntry("minix",DEFAULT_ICON_MINIX);
	icon_ext2=cfg->readEntry("ext2",DEFAULT_ICON_EXT2);
	icon_vfat_fd=cfg->readEntry("vfat_fd",DEFAULT_ICON_FD);
	icon_vfat_hd=cfg->readEntry("vfat_hd",DEFAULT_ICON_HD);
	icon_nfs=cfg->readEntry("nfs",DEFAULT_ICON_NFS);
	icon_smbfs=cfg->readEntry("smbfs",DEFAULT_ICON_SMBFS);
	icon_iso9660=cfg->readEntry("iso9660",DEFAULT_ICON_ISO9660);
	icon_msdos=cfg->readEntry("msdos",DEFAULT_ICON_MSDOS);
	icon_hfs=cfg->readEntry("hfs",DEFAULT_ICON_HFS);
	icon_unmounted=cfg->readEntry("unmounted",DEFAULT_ICON_UNMOUNTED);

	cfg->setGroup("Dock_MPs");
	dock_mp[0]=cfg->readEntry("dock_mp_1",DEFAULT_DOCK_MP_1);
	dock_mp[1]=cfg->readEntry("dock_mp_2",DEFAULT_DOCK_MP_2);
	dock_mp[2]=cfg->readEntry("dock_mp_3",DEFAULT_DOCK_MP_3);
	dock_mp[3]=cfg->readEntry("dock_mp_4",DEFAULT_DOCK_MP_4);

	cfg->setGroup("Colors");
	color_disk_free=cfg->readColorEntry("Disk_Free",new QColor(darkMagenta));
	color_disk_full=cfg->readColorEntry("Disk_Full",new QColor(blue));
	color_disk_umounted=cfg->readColorEntry("Disk_Unmounted",new QColor(gray));
}




