/***************************************************************************
                          KFLog.cpp  -  description
                             -------------------
    begin                : Sun Jun  6 11:42:22 CEST 1999

    copyright            : (C) 1999 by Heiner Lamprecht
    email                : heiner@kijumfo.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <ktmainwindow.h>
#include <qlayout.h>

#include <kflog.h>
#include <map.h>
#include <mapcalc.h>
#include <resource.h>
#include <tablet.h>

//#include <iostream>

KFLogApp::KFLogApp()
{
  setCaption("KFLog " VERSION);

  ///////////////////////////////////////////////////////////////////
  // read the config file options
  readOptions();

  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initMenuBar();
  initToolBar();
  initStatusBar();

  ///////////////////////////////////////////////////////////////////
  // set the Geometry an the Minimum-Size
  setMinimumSize(850,520);
  // Note: The size is determined without the frame of the window
  // Therefor these values are a few pixeles smaller than the desired
  // size of 1024x768.
  resize(1016,740);

  ///////////////////////////////////////////////////////////////////
  // enable bars dependend on config file setups
  if (!bViewToolbar)
    enableToolBar(KToolBar::Hide,0);
  if (!bViewStatusbar)
    enableStatusBar(KStatusBar::Hide);

  menuBar()->setMenuBarPos(menu_bar_pos);
  toolBar()->setBarPos(tool_bar_pos);

  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar items at startup

  ///////////////////////////////////////////////////////////////////
  // now set the main view
  initView();
}

KFLogApp::~KFLogApp()
{

}

void KFLogApp::enableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // enable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_,true);
  toolBar()->setItemEnabled(id_,true);
}

void KFLogApp::disableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_,false);
  toolBar()->setItemEnabled(id_,false);
}


void KFLogApp::initMenuBar()
{

  ///////////////////////////////////////////////////////////////////
  // MENUBAR

  ///////////////////////////////////////////////////////////////////
  // menuBar entry file_menu
  fileMenu = new QPopupMenu();
  fileMenu->insertItem(Icon("fileopen.xpm"), i18n("&Open flight"),
                       ID_FILE_OPEN );
  fileMenu->insertSeparator();
  fileMenu->insertItem(i18n("&View map"), ID_FILE_MAP);
  fileMenu->insertItem(Icon("mini/tablet.xpm"), i18n("&Create map"),
                       ID_FILE_CREATE);
  fileMenu->insertSeparator();
  fileMenu->insertItem(Icon("fileprint.xpm"), i18n("&Print"), ID_FILE_PRINT );
  fileMenu->insertSeparator();
  fileMenu->insertItem(i18n("E&xit"), ID_FILE_QUIT );

  // file_menu key accelerators
  fileMenu->setAccel(CTRL+Key_O, ID_FILE_OPEN);
  fileMenu->setAccel(CTRL+Key_P, ID_FILE_PRINT);
  fileMenu->setAccel(CTRL+Key_Q, ID_FILE_QUIT);


  ///////////////////////////////////////////////////////////////////
  // menuBar entry view_menu
  viewMenu = new QPopupMenu();
  viewMenu->setCheckable(true);
  viewMenu->insertItem(i18n("Tool&bar"), ID_VIEW_TOOLBAR);
  viewMenu->insertItem(i18n("&Statusbar"), ID_VIEW_STATUSBAR );

  viewMenu->setItemChecked(ID_VIEW_TOOLBAR, bViewToolbar);
  viewMenu->setItemChecked(ID_VIEW_STATUSBAR, bViewStatusbar);

  ///////////////////////////////////////////////////////////////////
  // menuBar entry help_menu
  helpMenu = new QPopupMenu();
  // help_menu = kapp->getHelpMenu(true, i18n(IDS_APP_ABOUT));


  ///////////////////////////////////////////////////////////////////
  // Hier wurde eigener Info-Text eingesetzt. Kann eventuell noch
  // erweitert werden ...
  helpMenu = kapp->getHelpMenu(true,
               i18n(
           "KFLog Version " VERSION
           "\n\nby Heiner Lamprecht (heiner@kijumfo.de)"
           "\n\nThis program is free software; you can redistribute it and/or"
           "\nmodify it under the terms of the GNU General Public License"
           "\nas published by the Free Software Foundation, either version"
           "\n2 of the license, or (at your option) any later version."
           ));

  ///////////////////////////////////////////////////////////////////
  // MENUBAR CONFIGURATION
  // set menuBar() the current menuBar and the position due to config file
  menuBar()->insertItem(i18n("&File"), fileMenu);
  menuBar()->insertItem(i18n("&View"), viewMenu);
  menuBar()->insertSeparator();
  menuBar()->insertItem(i18n("&Help"), helpMenu);

  ///////////////////////////////////////////////////////////////////
  // CONNECT THE SUBMENU SLOTS WITH SIGNALS

  CONNECT_CMD(fileMenu);
  CONNECT_CMD(viewMenu);
}

void KFLogApp::initToolBar()
{

  ///////////////////////////////////////////////////////////////////
  // TOOLBAR
  // set toolBar() the current toolBar and the position due to config file
  toolBar()->insertButton(Icon("fileopen.xpm"), ID_FILE_OPEN,
                          true, i18n("Open Flight"));
  toolBar()->insertButton(Icon("fileprint.xpm"), ID_FILE_PRINT,
                          true, i18n("Print"));
  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("mini/mini-turn.xpm"), ID_REDRAW,
                          true, i18n("Redraw Map"));
  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("mini/zoomin.xpm"), ID_ZOOM_IN,
                          true, i18n("Zoom in"));
  toolBar()->insertButton(Icon("mini/zoomout.xpm"), ID_ZOOM_OUT,
                          true, i18n("Zoom out"));
}

void KFLogApp::initStatusBar()
{

  ///////////////////////////////////////////////////////////////////
  //STATUSBAR
  statusBar()->insertItem(IDS_COORD_DEFAULT_H, ID_STATUS_COORD_H);
  statusBar()->insertItem(IDS_COORD_DEFAULT_R, ID_STATUS_COORD_R);
  statusBar()->insertItem(IDS_DEFAULT, ID_STATUS_MSG );
  statusBar()->setInsertOrder(KStatusBar::RightToLeft);
}

void KFLogApp::initView()
{
  enableCommand(ID_ZOOM_IN);
  enableCommand(ID_ZOOM_OUT);

  // was soll das???
  KApplication::getKApplication();

  ///////////////////////////////////////////////////////////////////
  //
  // Creating the widgets for the main window
  //
  //  view = new KFLogView(this, mapFrame, tabFrame);
  view = new KFLogView(this);
  setFrameBorderWidth(5);
  setView(view);
  mapObjectList = new MapObjectList(mapFile);

  view->setMOList(mapObjectList);

  // inserting the map:
  Map* map = new Map(view->getMapFrame(), this);
  QVBoxLayout* mapLayout = new QVBoxLayout(view->getMapFrame(),5,1);
  mapLayout->addWidget(map);
  mapLayout->activate();
}

bool KFLogApp::queryExit()
{
  return true;
}

void KFLogApp::saveOptions()
{
  KConfig* config = kapp->getConfig();

  config->setGroup("General");
  config->writeEntry("MapFile", mapFile);

  config->setGroup("Appearance");
  config->writeEntry("ShowToolbar",toolBar()->isVisible());
  config->writeEntry("ShowStatusbar",statusBar()->isVisible());
  config->writeEntry("MenuBarPos", (int)menuBar()->menuBarPos());
  config->writeEntry("ToolBar_Pos", (int)toolBar()->barPos());
}

void KFLogApp::readOptions()
{
  ///////////////////////////////////////////////////////////////////
  // read the config file entries
  KConfig *config = kapp->getConfig();

  config->setGroup("General");
  if(config->hasKey("MapFile")) {
    mapFile = config->readEntry("MapFile");
  } else {
    mapFile = kapp->kde_datadir();
    mapFile += "/kflog/map.wld";
  }

  config->setGroup("Appearance");
  bViewToolbar = config->readBoolEntry("ShowToolbar", true);
  bViewStatusbar = config->readBoolEntry("ShowStatusbar", true);
  menu_bar_pos = (KMenuBar::menuPosition)config->readNumEntry("MenuBarPos",
                                                              KMenuBar::Top);
  tool_bar_pos = (KToolBar::BarPosition)config->readNumEntry("ToolBar_Pos",
                                                             KToolBar::Top);
}

void KFLogApp::showCoords(QPoint coord)
{
  QString X, Y;
  X.sprintf("R: %d", coord.x());
  Y.sprintf("H: %d", coord.y());

  statusBar()->clear();
  statusBar()->changeItem(X, ID_STATUS_COORD_R);
  statusBar()->changeItem(Y, ID_STATUS_COORD_H);
}

MapObjectList* KFLogApp::getMapObjectList()
{
  return mapObjectList;
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

void KFLogApp::slotShowMap()
{
  /* show the map-view and enable some toolbar-buttons */
  view->showMapFrame();
  enableCommand(ID_ZOOM_IN);
  enableCommand(ID_ZOOM_OUT);
  enableCommand(ID_REDRAW);
}

void KFLogApp::slotShowDig()
{
  // hiding the other widgets and disable some toolbar-buttons
  disableCommand(ID_ZOOM_IN);
  disableCommand(ID_ZOOM_OUT);
  disableCommand(ID_REDRAW);
  // show the widgets for digitising
  view->showTabFrame();
}

void KFLogApp::slotFileOpen()
{
  slotStatusMsg(i18n("Opening file..."));

  slotStatusMsg(IDS_DEFAULT);
}

void KFLogApp::slotFilePrint()
{
  slotStatusMsg(i18n("Printing..."));

  QPrinter printer;
  if (printer.setup(this)) {
    QPainter painter;
    painter.begin( &printer );

    ///////////////////////////////////////////////////////////////////
    // TODO: Define printing by using the QPainter methods here

    painter.end();
  };

  slotStatusMsg(IDS_DEFAULT);
}

void KFLogApp::slotFileQuit()
{

  ///////////////////////////////////////////////////////////////////
  // exits the Application
  if(this->queryExit()) {
    saveOptions();
    KTMainWindow::deleteAll();
    kapp->quit();
  } else {
    slotStatusMsg(IDS_DEFAULT);
  }
  return;
}

void KFLogApp::slotViewToolBar()
{
  ///////////////////////////////////////////////////////////////////
  // turn Toolbar on or off
  bViewToolbar=!bViewToolbar;
  menuBar()->setItemChecked(ID_VIEW_TOOLBAR, bViewToolbar);
  enableToolBar(KToolBar::Toggle,0);
  enableToolBar(KToolBar::Toggle,ID_PRIV_TOOLBAR);
  slotStatusMsg(IDS_DEFAULT);

}

void KFLogApp::slotViewStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //turn Statusbar on or off
  bViewStatusbar=!bViewStatusbar;
  menuBar()->setItemChecked(ID_VIEW_STATUSBAR, bViewStatusbar);
  enableStatusBar();
  slotStatusMsg(IDS_DEFAULT);
}


void KFLogApp::slotStatusMsg(const char* text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  statusBar()->clear();
  statusBar()->changeItem(text, ID_STATUS_MSG );
}


void KFLogApp::slotStatusHelpMsg(const char* text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message of whole statusbar temporary (text, msec)
  statusBar()->message(text, 2000);
}

void KFLogApp::commandCallback(int id_){
  switch (id_){
    ON_CMD(ID_FILE_OPEN,                slotFileOpen())
    ON_CMD(ID_FILE_MAP,                 slotShowMap())
    ON_CMD(ID_FILE_CREATE,              slotShowDig())
    ON_CMD(ID_FILE_PRINT,               slotFilePrint())
    ON_CMD(ID_FILE_QUIT,                slotFileQuit())

    ON_CMD(ID_VIEW_TOOLBAR,             slotViewToolBar())
    ON_CMD(ID_VIEW_STATUSBAR,           slotViewStatusBar())
  }
}

void KFLogApp::statusCallback(int id_){
  switch (id_){
    ON_STATUS_MSG(ID_FILE_OPEN,
                  i18n("Opens an existing flight"))
    ON_STATUS_MSG(ID_FILE_PRINT,
                  i18n("Prints the current map"))
    ON_STATUS_MSG(ID_FILE_QUIT,
                  i18n("Exits the program"))
    ON_STATUS_MSG(ID_VIEW_TOOLBAR,
                  i18n("Enables / disables the actual Toolbar"))
    ON_STATUS_MSG(ID_VIEW_STATUSBAR,
                  i18n("Enables / disables the Statusbar"))
  }
}




































