/***************************************************************************
                          map.cpp  -  description
                             -------------------
    begin                : Mon Jun 7 1999
    copyright            : (C) 1999 by Heiner Lamprecht
    email                : heiner@kijumfo.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//#include <iostream>
#include <cmath>

#include <kapp.h>
#include <kconfig.h>
#include <qbitmap.h>
#include <qpainter.h>

#include <map.h>
#include <mapcalc.h>
#include <kflog.h>

void Map::map2Lambert(double x, double y, Location* loc)
{
  double lat, lon;
  lat = -asin(
              ( -4.0 * pow(cos(v1), 2.0) - 4.0 * pow(sin(v1), 2.0)
                -4.0 * sin(v1) * sin(v2)
                + y * y * pow(sin(v1), 2.0) + pow(sin(v1), 2.0)* x * x
                + 2.0 * y * y * sin(v1) * sin(v2) + 2.0 * sin(v1)
                * sin(v2) * x * x + y * y * pow(sin(v2), 2.0)
                + pow(sin(v2), 2.0) * x * x
                ) /
              ( sin(v1) + sin(v2) ) / 4 );

  lon = 2.0 * atan( y / x ) / ( sin(v1) + sin(v2) );

  loc->setLat(radToNum(lat));
  loc->setLon(radToNum(lon));
}

void Map::map2Mercator(double x, double y, Location* loc)
{

}

void Map::setProjection(const char* procType)
{

}

bool Map::isLambert()
{
  ////////////////////////////////////////////////////////////
  //
  // AUS IRGENDEINEM GRUND WIRD DIE PROJEKTIONSART
  // NICHT KORREKT ERKANNT!
  //
  ////////////////////////////////////////////////////////////
  return true;
//  return ( projectionType == "Lambert" );
}

bool Map::isMercator()
{
  return ( projectionType == "Mercator" );
}

void Map::mouseMoveEvent(QMouseEvent* event)
{
  // remember the current mouse position
  _current = event->pos();

        // show the position in the statusbar
  app->showCoords(_current);
  //    app->showCoords(event->pos());
}

void Map::mousePressEvent(QMouseEvent* event)
{
  if(event->button() == 4) {
    // middle-button pressed

    double mapX, mapY;

    if(isLambert()) {
      mapX = calc_X_Lambert(numToRad(mapCenterLat), 0, v1, v2);
      mapY = calc_Y_Lambert(numToRad(mapCenterLat), 0, v1, v2);
    } else {
      mapX = calc_X_Mercator(numToRad(mapCenterLat), 0);
      mapY = calc_Y_Mercator(numToRad(mapCenterLat), 0);
    }

    double dX = ( this->width() / 2 ) - ( mapX * scale );
    double dY = ( this->height() / 2 ) - ( mapY * scale );

    // auch hier mssen die Koordinaten vertauscht werden !!!
    QPoint current = event->pos();
    double x = current.y();
    double y = current.x();

    x = ( x - dX ) / scale;
    y = ( y - dY ) / scale;

    Location* loc = new Location();

    map2Lambert(x, y, loc);

    mapCenterLat = loc->getLat();
    mapCenterLon += loc->getLon();

    redrawMap();
  }
}

void Map::paintEvent(QPaintEvent* event)
{
  // restore the current map
  bitBlt(this, 0, 0, &_buffer);
}

void Map::setScale(int newScale = 0)
{
  scale = newScale;
}

void Map::smallScaleAdd()
{
  if((scale * 1.01) <= maxScale) {
    //          scale *= 1.01;
  }
}

void Map::smallScaleSub()
{
  if((scale - 250) >= minScale) {
    scale -= 250;
    //          redrawMap();
  }
}

void Map::bigScaleAdd()
{
  if((scale * 2) <= maxScale) {
    scale *= 2;
    redrawMap();
  }
}

void Map::bigScaleSub()
{
  if((scale / 2) >= minScale) {
    scale /= 2;
    redrawMap();
  }
}

void Map::drawMap(QPainter* bP)
{
  MapObjectList* moList = app->getMapObjectList();

  int drawX, drawY;

  long temp;

  double latitude, longitude, mapX, mapY, projX, projY;

  if(isLambert()) {
    mapX = calc_X_Lambert(numToRad(mapCenterLat), 0, v1, v2);
    mapY = calc_Y_Lambert(numToRad(mapCenterLat), 0, v1, v2);
  } else {
    mapX = calc_X_Mercator(numToRad(mapCenterLat), 0);
    mapY = calc_Y_Mercator(numToRad(mapCenterLat), 0);
  }

  double dX = ( this->width() / 2 ) - ( mapX * scale );
  double dY = ( this->height() / 2 ) - ( mapY * scale );

  MapObject* _current;

  for(unsigned int loop = 0; loop < moList->getListLength(); loop++) {
    _current = moList->getObject(loop);

    const long* latList = _current->getLatList();
    const long* lonList = _current->getLonList();

    QPointArray pointArray(_current->getLocLength());

    for(int i = 0; i < _current->getLocLength() ; i++) {
      temp = lonList[i] - mapCenterLon;
      latitude = numToRad(latList[i]);
      longitude = numToRad(temp);
      if(isLambert()) {
        projX = calc_X_Lambert(latitude,longitude, v1, v2);
        projY = calc_Y_Lambert(latitude,longitude, v1, v2);
      } else {
        projX = calc_X_Mercator(latitude,longitude);
        projY = calc_Y_Mercator(latitude,longitude);
      }
      drawX = (projX * scale) + dX;
      drawY = (projY * scale) + dY;

      // Hier wurden X und Y vertauscht !!!
      // Andernfalls wird die Karte gedreht
      // und gespiegelt dargestellt!
      pointArray.setPoint(i, drawY, drawX);
    }

    QString type = _current->getType();

    if(type == "ctr") {
      bP->setBrush(QBrush(QColor(255,255,100),Dense5Pattern));
      bP->setPen(QPen(QColor(0,0,0), 1));
      bP->drawPolygon(pointArray);
    } else if(type == "int-airport") {
      bP->setBrush(QBrush(QColor(50,50,120)));
      bP->setPen(QPen(QColor(50,50,120), 1));
      bP->drawPolygon(pointArray);
//
///////////////////////////////////////////////////////////////////////
//
// nur Typ "city" darf berleben ...
    } else if((type == "town") || (type == "city")) {
//
///////////////////////////////////////////////////////////////////////
//
      temp = _current->getAtLon() - mapCenterLon;
      latitude = numToRad(_current->getAtLat());
      longitude = numToRad(temp);

      if(isLambert()) {
        projX = calc_X_Lambert(latitude,longitude, v1, v2);
        projY = calc_Y_Lambert(latitude,longitude, v1, v2);
      } else {
        projX = calc_X_Mercator(latitude,longitude);
        projY = calc_Y_Mercator(latitude,longitude);
      }

      drawX = projX * scale + dX;
      drawY = projY * scale + dY;

      bP->setBrush(QBrush(QColor(240,240,0),Dense1Pattern));
      bP->setPen(QPen(QColor(0,0,0), 1));
      bP->drawPolygon(pointArray);

      // Hier wurden X und Y vertauscht !!!
      // Andernfalls wird die Karte gedreht und
      // gespiegelt dargestellt!
      bP->drawText(drawY, drawX, _current->getName());
    } else if(type == "river") {
      bP->setBrush(NoBrush);
      bP->setPen(QPen(QColor(100,100,255), 4));
      bP->drawPolyline(pointArray);
    } else if(type == "cvfr") {
      bP->setBrush(NoBrush);
      bP->setPen(QPen(QColor(255,100,100), 4));
      bP->drawPolygon(pointArray);
    } else if(type == "lake") {
      temp = _current->getAtLon() - mapCenterLon;
      latitude = numToRad(_current->getAtLat());
      longitude = numToRad(temp);

      if(isLambert()) {
        projX = calc_X_Lambert(latitude,longitude, v1, v2);
        projY = calc_Y_Lambert(latitude,longitude, v1, v2);
      } else {
        projX = calc_X_Mercator(latitude,longitude);
        projY = calc_Y_Mercator(latitude,longitude);
      }

      drawX = projX * scale + dX;
      drawY = projY * scale + dY;

      bP->setBrush(QBrush(QColor(100,100,244),Dense1Pattern));
      bP->setPen(QPen(QColor(50,50,255), 1));
      bP->drawPolygon(pointArray);

      // Hier wurden X und Y vertauscht !!!
      // Andernfalls wird die Karte gedreht und
      // gespiegelt dargestellt!
      bP->drawText(drawY, drawX, _current->getName());
    }
  }
}

void Map::resizeEvent(QResizeEvent* event)
{
  // when called the first time, don't draw the map, because the widget
  // will be resized again!
  if(!isEnabled) {
    isEnabled = true;
    return;
  }

  // restore the current map
  _buffer.resize(event->size());

  redrawMap();
}

void Map::redrawMap()
{
  // reset the current map
  _buffer.fill(white);

  ///////////////////////////////////////////////////////////////////
  //
  // create a QPainter object for drawing onto the window
  // and another for buffering the drawing
  QPainter mapPainter;
  QPainter buffPainter;

  ///////////////////////////////////////////////////////////////////
  //
  // starting painting
  mapPainter.begin(this);
  buffPainter.begin(&_buffer);

  mapPainter.eraseRect(0,0,this->width(),this->height());

  drawMap(&mapPainter);
  drawMap(&buffPainter);

  mapPainter.end();
  buffPainter.end();
}

void Map::slotScaleAdd()
{
  bigScaleAdd();
}

void Map::slotScaleSub()
{
  bigScaleSub();
}

Map::Map(QWidget *parent, KFLogApp *main)
  : QWidget(parent)
{

  KConfig *config = kapp->getConfig();

  config->setGroup("General");
  scale = config->readNumEntry("MapScale", 20000);
  if(config->hasKey("MapProjection")) {
    projectionType = config->readEntry("MapProjection");
  } else {
    projectionType = "Lambert";
  }
  mapCenterLon = config->readNumEntry("MapCenterX",
      degreeToNum("0600,0000\"E"));
  mapCenterLat = config->readNumEntry("MapCenterY",
      degreeToNum("5130,0000\"N"));
  v1 = numToRad(config->readNumEntry("Parallel1",
      degreeToNum(DEFAULT_V1)));
  v2 = numToRad(config->readNumEntry("Parallel2",
      degreeToNum(DEFAULT_V2)));

  app = main;

  // disable drawing the map. Drawing will be enabled, when the window
  // is opened.
  isEnabled = false;

  // defining the cursor for the map:
  static unsigned char cross_bits[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00,
    0x00, 0x80, 0x01, 0x00, 0x00, 0xe0, 0x07, 0x00, 0x00, 0x98, 0x19, 0x00,
    0x00, 0x8c, 0x31, 0x00, 0x00, 0x86, 0x61, 0x00, 0x00, 0x83, 0xc1, 0x00,
    0x00, 0xc1, 0x83, 0x00, 0x80, 0x60, 0x06, 0x01, 0x80, 0x30, 0x0c, 0x01,
    0xe0, 0x9f, 0xf9, 0x07, 0xe0, 0x9f, 0xf9, 0x07, 0x80, 0x30, 0x0c, 0x01,
    0x80, 0x60, 0x06, 0x01, 0x00, 0xc1, 0x83, 0x00, 0x00, 0x83, 0xc1, 0x00,
    0x00, 0x86, 0x61, 0x00, 0x00, 0x8c, 0x31, 0x00, 0x00, 0x98, 0x19, 0x00,
    0x00, 0xe0, 0x07, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x80, 0x01, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
  };
  QBitmap cross(32, 32, cross_bits, true);
  QCursor crossCursor(cross, cross);

  this->setMouseTracking(true);
  this->setBackgroundColor(QColor(255,255,255));
  this->setCursor(crossCursor);

  KToolBarButton* zoomout = app->toolBar()->getButton(ID_ZOOM_OUT);
  KToolBarButton* zoomin = app->toolBar()->getButton(ID_ZOOM_IN);

  this->connect(zoomout, SIGNAL(clicked()), this, SLOT(slotScaleSub()));
  this->connect(zoomin, SIGNAL(clicked()), this, SLOT(slotScaleAdd()));
}

Map::~Map()
{
  KConfig *config = kapp->getConfig();

  config->setGroup("General");
  config->writeEntry("MapScale", scale);
  config->writeEntry("MapProjection", projectionType);
  config->writeEntry("MapCenterX", mapCenterLon);
  config->writeEntry("MapCenterY", mapCenterLat);
  if((v1 != numToRad(degreeToNum("5400'0000\"N"))) ||
     (v2 != numToRad(degreeToNum("5000'0000\"N")))) {
    config->writeEntry("Parallel1", radToNum(v1));
    config->writeEntry("Parallel2", radToNum(v2));
  }
}
















