/***************************************************************************
             mapcalc.cpp  -  functions for calc. mapprojections
                             -------------------
    begin                : 26. July 1999
    copyright            : (C) 1999 by Heiner Lamprecht
    email                : heiner@kijumfo.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <iostream>

#include <cmath>
#include <mapcalc.h>
#include <qregexp.h>

#define PI 3.141592654

long degreeToNum(const char* degree)
{
  long deg = 0, min = 0, sec = 0;
  long result;
  int count = 0;
  char direction = 'N';

  QRegExp number("^[0-9]+$");
  QRegExp deg1("[.]");
  QRegExp deg2(",");
  QRegExp deg3("'");
  if(number.match(degree) != -1) {
    result = degree[0] - '0';
    for(unsigned int loop = 1; loop < strlen(degree); loop++) {
      result = 10 * result + (degree[loop] - '0');
    }
    return result;
  }
  switch(deg1.match(degree)) {
    case 1:
      deg = degree[0] - '0';
      degree += 2;
      break;
    case 2:
      deg = 10 * (degree[0] - '0') + (degree[1] - '0');
      degree += 3;
      break;
    case 3:
      deg = 100 * (degree[0] - '0') + 10 * (degree[1] - '0')
            + (degree[2] - '0');
      degree += 4;
      break;
    default:
      if(deg1.match(degree) > 3) return 0;    // << degree is not correct!
      switch(strlen(degree)) {
        case 1:
          deg = degree[0] - '0';
          break;
        case 2:
          deg = 10 * (degree[0] - '0') + (degree[1] -'0');
          break;
        case 3:
          deg = 100 * (degree[0] - '0') + 10 * (degree[1] - '0')
                + (degree[2] - '0');
          break;
        default:
          return 0;                           // << degree is not correct!
      }
  }
  if(deg2.match(degree) != -1) {
    // Minuten mit Nachkommastellen!
    switch(deg2.match(degree)) {
      case 1:
        min = degree[0] - '0';
        for(unsigned int loop = 2; loop < strlen(degree); loop++) {
          if((degree[loop] >= '0') && (degree[loop] <= '9')) {
            sec = 10 * sec + (degree[loop] - '0');
            count++;
          }
        }
        break;
      case 2:
        min = 10 * (degree[0] - '0') + (degree[1] -'0');
        for(unsigned int loop = 3; loop < strlen(degree); loop++) {
          if((degree[loop] >= '0') && (degree[loop] <= '9')) {
            sec = (degree[loop] - '0') + (sec / 10);
            count++;
          }
        }
        break;
      default:
        if((deg2.match(degree) > 2) ||
           (deg2.match(degree) == 0))
          return 0;    // << degree is not correct!
    }
  } else if(deg3.match(degree) != -1) {
    // es folgen nich "echte" Sekunden
    switch(deg3.match(degree)) {
      case 1:
        min = degree[0] - '0';
        for(unsigned int loop = 2; loop < strlen(degree); loop++) {
          if((degree[loop] >= '0') && (degree[loop] <= '9')) {
            sec = sec * 10 + (degree[loop] - '0');
            count++;
          }
        }
        break;
      case 2:
        min = 10 * (degree[0] - '0') + (degree[1] -'0');
        for(unsigned int loop = 3; loop < strlen(degree); loop++) {
          if((degree[loop] >= '0') && (degree[loop] <= '9')) {
            sec = sec * 10 + (degree[loop] - '0');
            count++;
          }
        }
        break;
      default:
        if((deg2.match(degree) > 2) ||
           (deg2.match(degree) == 0))
          return 0;    // << degree is not correct!
    }
  }

  result = (600000 * deg) + (10000 * min) + (sec * pow(10,-count));
  if( direction == 'S' || direction == 'W' ) {
    return -result;
  }
  return result;
}

double numToRad(long internal)
{
  return ( PI * internal ) / 108000000.0;
}

long radToNum(double radial)
{
  return (radial * 108000000.0 / PI );
}

double calc_X_Lambert(double latitude, double longitude,
                      double v1, double v2)
{
  double x1;

  x1 = 2*(sqrt(cos(v1)*cos(v1)+(sin(v1)-sin(latitude))
               *(sin(v1)+sin(v2)))/(sin(v1)+sin(v2)))
    *cos((sin(v1)+sin(v2))*longitude/2);

  // pi / 2 => 90
  latitude = PI / 2.0 - latitude;
  return x1 ;
}

double calc_Y_Lambert(double latitude, double longitude,
                      double v1, double v2)
{
  double y1;

  y1 = 2*(sqrt(cos(v1)*cos(v1)+(sin(v1)-sin(latitude))
               *(sin(v1)+sin(v2)))/(sin(v1)+sin(v2)) )
    *sin((sin(v1)+sin(v2))*longitude/2);
  return y1 ;

}

double calc_X_Mercator(double latitude, double longitude)
{
  return 0;
}

double calc_Y_Mercator(double latitude, double longitude)
{
  return 0;
}
/*
void map2Lambert(double x, double y, long* latitude, long* longitude,
                 double v1, double v2)
{
  double lat, lon;
  lat = -asin(
              ( -4.0 * pow(cos(v1), 2.0) - 4.0 * pow(sin(v1), 2.0)
                -4.0 * sin(v1) * sin(v2)
                + y * y * pow(sin(v1), 2.0) + pow(sin(v1), 2.0)* x * x
                + 2.0 * y * y * sin(v1) * sin(v2) + 2.0 * sin(v1)
                * sin(v2) * x * x + y * y * pow(sin(v2), 2.0)
                + pow(sin(v2), 2.0) * x * x
                ) /
              ( sin(v1) + sin(v2) ) / 4 );

  lon = 2.0 * atan( y / x ) / ( sin(v1) + sin(v2) );

  latitude = radToNum(lat);
  longitude = radToNum(lon)
}
*/

long map2LambertLat(double x, double y, double v1, double v2)
{
  double lat;
  lat = -asin(
              ( -4.0 * pow(cos(v1), 2.0) - 4.0 * pow(sin(v1), 2.0)
                -4.0 * sin(v1) * sin(v2)
                + y * y * pow(sin(v1), 2.0) + pow(sin(v1), 2.0)* x * x
                + 2.0 * y * y * sin(v1) * sin(v2) + 2.0 * sin(v1)
                * sin(v2) * x * x + y * y * pow(sin(v2), 2.0)
                + pow(sin(v2), 2.0) * x * x
                ) /
              ( sin(v1) + sin(v2) ) / 4 );
  return radToNum(lat);
}

long map2LambertLon(double x, double y, double v1, double v2)
{
  double lon;

  lon = 2.0 * atan( y / x ) / ( sin(v1) + sin(v2) );
  return radToNum(lon);

}



