/***************************************************************************
                                 resource.h
                             -------------------
    begin                : Sun Jun  6 11:42:22 CEST 1999
    copyright            : (C) 1999 by Heiner Lamprecht
    email                : heiner@kijumfo.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef RESSOURCE_H
#define RESSOURCE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

///////////////////////////////////////////////////////////////////
// resource.h  -- contains macros used for commands

#define DEFAULT_V1                 "5400,0000N"
#define DEFAULT_V2                 "5000,0000N"

///////////////////////////////////////////////////////////////////
// COMMAND VALUES FOR MENUBAR AND TOOLBAR ENTRIES
#define ID_PRIV_TOOLBAR             1

///////////////////////////////////////////////////////////////////
// File-menu entries
#define ID_FILE_OPEN                10010
#define ID_FILE_MAP                 10020
#define ID_FILE_CREATE              10030
#define ID_ZOOM_IN                  10050
#define ID_ZOOM_OUT                 10060
#define ID_FILE_PRINT               10080
#define ID_FILE_QUIT                10100
#define ID_REDRAW                   10110

///////////////////////////////////////////////////////////////////
// View-menu entries                    
#define ID_VIEW_TOOLBAR             12010
#define ID_VIEW_STATUSBAR           12020
#define ID_VIEW_OPTIONS             12030

///////////////////////////////////////////////////////////////////
// Help-menu entries
#define ID_HELP                     1002

///////////////////////////////////////////////////////////////////
// General application values
#define ID_STATUS_MSG               1001

#define IDS_DEFAULT                 "Ready."

#define IDS_APP_ABOUT               "KFLog\nVersion " VERSION

#define ID_STATUS_COORD_R           10011
#define ID_STATUS_COORD_H           10012

#define IDS_COORD_DEFAULT_R         "R:      0"
#define IDS_COORD_DEFAULT_H         "H:      0"

///////////////////////////////////////////////////////////////////
// MENU CONNECTS
#define CONNECT_CMD(submenu)           connect(submenu, SIGNAL(activated(int)), SLOT(commandCallback(int)));connect(submenu,SIGNAL(highlighted(int)), SLOT(statusCallback(int)))


///////////////////////////////////////////////////////////////////
// TOOLBAR CONNECT  
#define CONNECT_TOOLBAR(ToolBar)        connect(ToolBar, SIGNAL(clicked(int)), SLOT(commandCallback(int)));connect(ToolBar, SIGNAL(highlighted(int,bool)), SLOT(statusCallback(int)))

///////////////////////////////////////////////////////////////////
// Create cases for entries and connect them with their functions
#define ON_CMD(id, cmd_class_function)   case id:cmd_class_function ;break;

///////////////////////////////////////////////////////////////////
// Create cases for entries and connect them to change statusBar entry
#define ON_STATUS_MSG(id, message)     case id:  slotStatusHelpMsg(message);break;

#endif // RESOURCE_H
