/***********************************************************************
**
**   intairport.h
**
**   This file is part of KFLog
**
************************************************************************
**
**   Copyright (c):  2000 by Heiner Lamprecht, Florian Ehinger
**
**
**   This program is free software; you can redistribute it and/or
**   modify it under the terms of the GNU General Public License as
**   published by the Free Software Foundation; either version 2 of
**   the License, or (at your option) any later version.
**
**   This program is distributed in the hope that it will be useful,
**   but WITHOUT ANY WARRANTY; without even the implied warranty of
**   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
**   GNU General Public License for more details.
**
**   You should have received a copy of the GNU General Public
**   License along with this program; if not, write to the Free
**   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
***********************************************************************/

#ifndef INTAIRPORT_H
#define INTAIRPORT_H

#include <areaelement.h>
#include <runway.h>

/**
  * This class is used for the international airports.
  *
  * @author Heiner Lamprecht, Florian Ehinger
  * @version 0.1
  */

class IntAirport : public AreaElement
{
 public:
  /**
    * Creates a new international airport. n is the name of the airport,
    * a the alias, length contains the number of positions, latList and
    * longlist contain the coordinates. elev gives the elevation of the
    * airport, f the frequency.
    */
  IntAirport(QString n, QString a,
              unsigned int length, long* latList, long* lonList,
              unsigned int elev, QString f, bool vdf = false,
              struct intrunway* rwDat = 0, unsigned int rwN = 0);
  /** */
  ~IntAirport();
  /**
    * Draws the airport into the given painter.
    */
  virtual QRegion* drawRegion(QPainter* targetPainter,
        double dX, double dY, long mapCenterLon);
  /**
    * Virtual function for writing the airport-data into the given
    * binary-map-file.
    */
  virtual bool writeElementBin(const char* fileName);
  /**
    * Virtual function for writing the airport-data into the given
    * ascii-map-file.
    */
  virtual bool writeElementAscii(const char* fileName);


 private:
  /** The alias of the airport. */
  QString alias;
  /** The elevation */
  unsigned int elevation;
  /** The frequency */
  QString frequency;
  /** */
  bool vdf;
  /** Contains the runway-data. */
  struct intrunway* rwData;
  /** Contains the number of runways. */
  unsigned int rwNum;
};

#endif
