/***********************************************************************
**
**   kflogview.h
**
**   This file is part of KFLog
**
************************************************************************
**
**   Copyright (c):  1999 by Heiner Lamprecht ( heiner@kijumfo.de )
**   begin        :  Sun Jun  6 1999
**
**
**   This program is free software; you can redistribute it and/or
**   modify it under the terms of the GNU General Public License as
**   published by the Free Software Foundation; either version 2 of
**   the License, or (at your option) any later version.
**
**   This program is distributed in the hope that it will be useful,
**   but WITHOUT ANY WARRANTY; without even the implied warranty of
**   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
**   GNU General Public License for more details.
**
**   You should have received a copy of the GNU General Public
**   License along with this program; if not, write to the Free
**   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
***********************************************************************/

#ifndef KFLOGVIEW_H
#define KFLOGVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include app-specific header
#include <flight.h>
#include <mapcontents.h>
#include <kapp.h>

// include kde- and qt-header
#include <kcombo.h>
#include <kintegerline.h>
#include <krestrictedline.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qwidget.h>

/**
  * Base class for the mainwindow of KFLog. This class provides the two
  * different main-views: the map-view and the view for digitizing the
  * map.
  * @author Heiner Lamprecht
  * @version 0.4
  */
class KFLogView : public QWidget
{
  Q_OBJECT

 public:
  /**
    * Creates the mainview for both displaying the map and flight data or
    * digitizing the map.
    * @see TabletDialog
    * @see Map
    */
  KFLogView(QWidget* parent, MapContents* molist);
  /**
    * Destructor for the main view
    */
  ~KFLogView();
  /**
    * Shows the widget of the map.
    * @see Map
    */
  void showMapFrame();
  /**
    * Shows the widget for digitizing.
    * @see TabletDialog
    */
  void showTabFrame();
  /**
    * Returns a pointer to the frame containing the widgets for displaying
    * the map.
    * @see mapView
    */
  QFrame* getMapView();
  /**
    * Returns a pointer to the frame containing the widgets for digitizing
    * the map.
    * @see tabView
    */
  QFrame* getTabView();
  /**
    * Returns a pointer to the frame containing map.
    * @see mapFrame
    */
  QFrame* getMapFrame();
  /** */
  void showFlightData(Flight* flight);
  /** */
  void delWPListView();

 public slots:
  /**
    * Selects a type of map-elements and enables all needed input-widgets
    * for digitizing the mapelement.
    */
  void selectMapElement(QListViewItem* item);
  /**
    * Add a runway to the list. If object-type is "int-airport", the user
    * has to digitize two points per runway.
    */
  void slotAddRunway();
  /**
    * Deletes a selected runway from the list.
    */
  void slotDelRunway();
  /**
    * Controls all given input-data and enables digitizing if no data is
    * missing. Otherwise a dialog-window appears to show the empty
    * data-fields.
    */
  void startInput();
  /**
    * Enables digitizing the runway for an international airport.
    */
  void startRunwayInput(long* runwayPointList);

 private:
  /**
    * Checks the entryfields, if all required fields are filled out.
    */
  bool checkInputFields();
  /**
    * Creates a new mapelement, appends it to the mapcontents and writes
    * the element into the ascii-file.
    */
  void createMapElement(long* latitude, long* longitude, unsigned int length);
  /**
    * Creates a new struct-array which contains the runwaydata of an
    * international airport.
    */
  struct intrunway* createIntRunway();
  /**
    * Creates a new struct-array which contains the runwaydata of an
    * airport or airfield
    */
  struct runway* createRunway();
  /**
    * The frame containing the map.
    */
  QFrame* mapFrame;
  /**
    * The frame containing all widgets for displaying the map.
    */
  QFrame* mapView;
  /**
    * The frame containing all widgets for digitizing.
    */
  QFrame* tabView;
  QLabel* typLabel;
  bool pointList;
  long* latitude;
  long* longitude;
  unsigned int type;
  QWidget* parent;
  // the widgets for entering the map-object-data:
  QListView* digitList;
  QLineEdit* nameE;
  KRestrictedLine* abkE;
  QPushButton* addB;
  QPushButton* delB;
  KIntegerLine* dirE;
  KIntegerLine* elevE;
  KIntegerLine* lowerE;
  KCombo* lowerT;
  KCombo* uppT;
  KRestrictedLine* freqE;
  KCombo* gliderT;
  KIntegerLine* runwE;
  QListView* runwList;
  QComboBox* runwtE;
  KIntegerLine* uppE;
  QCheckBox* vdfE;
  MapContents* mapContents;

  QLabel* text1;
  QLabel* text2;
  QLabel* text3;
  QListView* wpList;
};

#endif
