/***********************************************************************
**
**   radiopoint.cpp
**
**   This file is part of KFLog
**
************************************************************************
**
**   Copyright (c):  2000 by Heiner Lamprecht, Florian Ehinger
**
**
**   This program is free software; you can redistribute it and/or
**   modify it under the terms of the GNU General Public License as
**   published by the Free Software Foundation; either version 2 of
**   the License, or (at your option) any later version.
**
**   This program is distributed in the hope that it will be useful,
**   but WITHOUT ANY WARRANTY; without even the implied warranty of
**   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
**   GNU General Public License for more details.
**
**   You should have received a copy of the GNU General Public
**   License along with this program; if not, write to the Free
**   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
***********************************************************************/

#include "radiopoint.h"

#include <mapcalc.h>

#include <kapp.h>
#include <kiconloader.h>
#include <qdatastream.h>
#include <qfile.h>
#include <qtextstream.h>

bool RadioPoint::writeElementBin(const char* fileName)
{
  QFile outputFile(fileName);
  if(!outputFile.open(IO_WriteOnly | IO_Append)) {
    return false;
  }
  QDataStream out(&outputFile);

  out << (Q_UINT8) typeID;
  out << (const char*) name;
  out << (const char*) alias;
  out << (Q_INT32) latitude;
  out << (Q_INT32) longitude;
  out << (const char*) frequency;

  outputFile.close();

  return true;
}

bool RadioPoint::writeElementAscii(const char* fileName)
{
  QFile mapFile(fileName);
  if(!mapFile.open(IO_ReadWrite)) {
    return false;
  }
  mapFile.at(mapFile.size());
  QTextStream mapOut(&mapFile);

  mapOut << "[NEW]\n"
         << "TYPE=" << typeID << endl
         << "NAME=" << name << endl
         << "ALIAS=" << alias << endl
         << "AT=" << latitude << " " << longitude << endl
         << "FREQUENCY=" << frequency << endl
         << "[END]\n";
  mapFile.close();

  return true;
}

void RadioPoint::drawMapElement(QPainter* targetPainter,
          double dX, double dY, long mapCenterLon)
{
  extern double _scale[];
  extern double _currentScale;
  double lat, lon, projX, projY, drawX, drawY;

  /********************************************************************
   *                                                                  *
   * ACHTUNG: Alle kleinen Objekte knnen prinzipiell                 *
   * Wegpunkte werden! Dies mu noch irgendwie implementiert werden!  *
   *                                                                  *
   ********************************************************************/

  lat = numToRad(latitude);
  lon = numToRad(longitude - mapCenterLon);

  projX = calc_X_Lambert(lat,lon);
  projY = calc_Y_Lambert(lat,lon);

  drawX = projX * RADIUS / _currentScale + dX;
  drawY = projY * RADIUS / _currentScale + dY;

  // ACHTUNG: Alle Icons mssen die gleiche Gre bekommen!
//  QPixmap* pixmap;

  targetPainter->setPen(QPen(QColor(0,0,0), 2));
  char* kflog_dir = "/kflog/map";
  if(_currentScale > _scale[3]) {
    kflog_dir = "/kflog/map/small";
  }

  switch (typeID) {
    case VOR:
    case VORDME:
    case VORTAC:
    case NDB:
      break;
  }
}

RadioPoint::RadioPoint(QString n, unsigned int t, long latPos,
          long lonPos, QString f = 0, QString a = 0)
    : SinglePoint(n, t, latPos, lonPos)
{
  name = n;
  latitude = latPos;
  longitude = lonPos;
  typeID = t;
  frequency = f;
  alias = a;
}

RadioPoint::~RadioPoint()
{

}
