/***********************************************************************
**
**   singlepoint.h
**
**   This file is part of KFLog
**
************************************************************************
**
**   Copyright (c):  2000 by Heiner Lamprecht, Florian Ehinger
**
**
**   This program is free software; you can redistribute it and/or
**   modify it under the terms of the GNU General Public License as
**   published by the Free Software Foundation; either version 2 of
**   the License, or (at your option) any later version.
**
**   This program is distributed in the hope that it will be useful,
**   but WITHOUT ANY WARRANTY; without even the implied warranty of
**   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
**   GNU General Public License for more details.
**
**   You should have received a copy of the GNU General Public
**   License along with this program; if not, write to the Free
**   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
***********************************************************************/

#ifndef SINGLEPOINT_H
#define SINGLEPOINT_H

#include <basemapelement.h>
#include <wp.h>

/**
  * Mapelement used for small objects. The object can be one of:
  * ClosedAirfield, UltraLight, HangGlider, Parachute, Ballon, Village,
  * Oiltank, Factory, Castle, Church, Tower, HighwayEntry, RailwayBridge,
  * Station, Dam, Lock.
  * Consists only of a name and a position.
  *
  * @see BaseMapElement#objectType
  * @see Airport
  * @see ElevPoint
  * @see GliderSite
  * @see RadioPoint
  *
  * @author Heiner Lamprecht, Florian Ehinger
  * @version 0.1
  */
class SinglePoint : public BaseMapElement
{
 public:
	/**
	  * Creates a new "SinglePoint". n is the name of the element, t is the typeID,
	  * latPos and lonPos give the position of the element.
	  */
  SinglePoint(QString n, unsigned int t, long latPos = 0,
            long lonPos = 0, bool isW = false);
	/**
	  *
	  */
  ~SinglePoint();
  /**
    * Draws the element into the given painter.
    */
  virtual void drawMapElement(QPainter* targetPainter,
        double dX, double dY, long mapCenterLon);
  /**
    * Virtual function for writing the element-data into the given
    * binary-map-file.
    */
  virtual bool writeElementBin(const char* fileName);
  /**
    * Virtual function for writing the element-data into the given
    * ascii-map-file.
    */
  virtual bool writeElementAscii(const char* fileName);
  /**
    * Returns the position of the element.
    */
  virtual struct point getPosition();
  /**
    * Sets <TT>isWaypoint</TT> to <TT>isW</TT>.
    */
  virtual void setWaypoint(bool isW);
  /**
    * Returns <TT>true</TT>, if the element is a waypoint.
    */
  virtual bool isWayPoint();

 protected:
  /**
    * The name of the mapelement.
    */
  QString name;
  /**
    * The latitude.
    */
  long latitude;
  /**
    * The longitude.
    */
  long longitude;
  /** <TT>true</TT>, if the element is used as a waypoint. */
  bool isWaypoint;
};

#endif
