/***************************************************************************
 *                               kfsstatus.h                               *
 *                            -------------------                          *
 *                     Header file for KFSStatus                           *
 *               -A program to analyse mounted filesystems                 *
 *                                                                         *
 *               KFSStatus is part of the KDE-Project                      *
 *                         http://www.kde.org                              *
 *                                                                         *
 *   Copyright (C) Feb - Dec 1997 Markus Wuebben                           *
 *                  E-Mail: markus.wuebben@kde.org                         *
 *                     Web: http://math.cornell.edu/~wuebben/markus/       * 
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          * 
 *                                                                         *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software           *
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
 *                                                                         *
 ***************************************************************************/

#ifndef KFSSTATUS_H
#define KFSSTATUS_H

#include <qwidget.h>
#include <qgrpbox.h>
#include <qpainter.h>
#include <qevent.h>
#include <qfile.h>
#include <qpen.h>
#include <qpushbt.h>
#include <qbrush.h>
#include <qlabel.h>
#include <qframe.h>
#include <qpixmap.h>
#include <qmsgbox.h>
#include <qcombo.h>
#include <qtstream.h>
#include <qdstream.h>
#include <qlist.h>
#include <qtabdlg.h>
#include <kapp.h>
#include <kcolordlg.h>
#include <iostream.h>
#include <stdio.h>
#include <string.h>
#include <sys/vfs.h>
#include <mntent.h>
#include <unistd.h>

class Device 
{
public:
  Device(const char *devName) {deviceName = devName;}
  const char *text() const {return deviceName;}

private:
  QString deviceName;
};


class KFSStatus : public QDialog
{
Q_OBJECT
public:
  KFSStatus(QWidget *parent=0, const char *name = 0);
 ~KFSStatus();
 void getFsStat(char *fs);
 int setFsInfos();
 int getFileSystems();

private:
  int availAngle;
  int usedAngle;
  void exception();
  QComboBox *device;
  QPopupMenu *m_help;
  QPopupMenu *m_options;
  QPopupMenu *m_file;
  QMenuBar *menubar;
  QLabel *fstype;
  QLabel *fsid;
  QLabel *fsmounted;
  struct statfs mystat; // structure for getting free blocks etc.
  struct mntent *mymntent; // structure for accessing /etc/mtab
  int availPerc; // % of Filesystem free
  int usedPerc; //% of Filesystem used 
			   
  QGroupBox *theBox;
  QColor freeColor;
  QColor usedColor;
  QColor freeColorOld;
  QColor usedColorOld;
  KColorDialog *colorDialog;
  QPushButton *okColorBt;
  QPushButton *cancelColorBt;
  QLabel *freeColorLabel;
  QLabel *usedColorLabel;
  QPushButton *configFree;
  QPushButton *configUsed;
  
  QString tempUsedColor;
  QString tempFreeColor;
  
  QFrame *usedFrame, *freeFrame;
  QFrame *frei_f, *belegt_f;
  KConfig *config;
  
  // KLinkedList *theDeviceList;
  QList<Device>  *theList;

protected:
  void paintEvent(QPaintEvent *pevent);
  
public slots:
  int deviceChange(int);
  void deviceChangeI();
};



class KFSSetup : public QDialog
{
Q_OBJECT
public:
  KFSSetup(QWidget *parent, const char *name);

private:
  KConfig *config;  
  QColor usedColorOld;
  QColor freeColorOld;
  QColor usedColor;
  QColor freeColor;
  QFrame *usedFrame;
  QFrame *freeFrame;
  QGroupBox *box;

protected:
  void paintEvent(QPaintEvent *e);

 
public slots:
  void configureColorFree();
  void configureColorUsed();   
  void okColorSlot();
  void recoverColorSlot();
  
}; 


class KFSAbout : public QDialog
{
Q_OBJECT
public:
  KFSAbout(QWidget *parent=0, const char *name=0);

private:
  QGroupBox *box;

protected:
  void paintEvent(QPaintEvent *e);

public slots:
  void startKdehelp();

};

class KFSMainWidget : public QDialog
{
Q_OBJECT
public:
  KFSMainWidget(QWidget *parent=0, const char *name=0);

private:
  QTabDialog *tabDialog;
  KFSStatus *topLevel;
  KFSSetup *setupWidget;
  KFSAbout *aboutWidget;
 
};

#endif


















































































