
// Standard headers
#include <iostream.h>

// QT headers
#include <qsize.h>

// KDE headers
#include <kapp.h>

// Homemade headers
#include "listview.h"

#define LOC i18n

CListView::CListView(QWidget* parent, const char* name) : QListView(parent, name)
{
  addColumn("    ");
  addColumn( LOC( "Device             " ));
  addColumn( LOC( "Mount point           " ));
  addColumn( LOC( "Filesystem         " ));
  addColumn( LOC( "Options  " ));
  addColumn( LOC( "Dump  " ));
  addColumn( LOC( "Fsck  " ));
  addColumn( LOC( "Comment" ));
  setAllColumnsShowFocus( TRUE );
  
}

CListView::~CListView()
{
  
}

void CListView::updateColumnSize()
{
  int totalColSize = 0;
   
  totalColSize += columnWidth(0);
  totalColSize += columnWidth(1);
  totalColSize += columnWidth(2);
  totalColSize += columnWidth(3);
  totalColSize += columnWidth(4);
  totalColSize += columnWidth(5);
  totalColSize += columnWidth(6);

  setColumnWidth(7, this->width() - totalColSize);
}


void CListView::saveOptions()
{
 
  
}

void CListView::resizeEvent ( QResizeEvent * e )
{
  QListView::resizeEvent(e);

  updateColumnSize();
}

#include "listview.moc"
