/*****************************************************************************
 * This software is distributed under the terms of the General Public License.
 *
 * Program : kfstab
 * Authors : Dirk Holtwick & Andreas Reuter
 * E-Mail  : holtwick@uni-duisburg.de
 *           Andreas.Reuter@munich.netsurf.de
*****************************************************************************/

#ifndef _KFSTAB_MWIN_H
#define _KFSTAB_MWIN_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif  

/**
 * Solaris uses /etc/vfstab as other Unix systems e.g. Linux use /etc/fstab
**/
#ifdef _OS_SOLARIS_
#define FSTAB "/etc/vfstab"
#else
#define FSTAB "/etc/fstab"
#endif

// QT Header Files
#include <qlistview.h>

// KDE Header Files
#include <ktmainwindow.h>
#include <kprocess.h>
#include <kiconloader.h>

// Application Header Files
#include "optpref.h"
#include "devpref.h"
#include "listview.h"
#include "testmount.h"

/**
 * This is the class definition of KFstab a KTopLevelWidget.
 *
 * It provides all necessary methods we need to make Kfstab work.
 */
class KFstab : public KTMainWindow
{
  Q_OBJECT

 public:
  /**
   * This is the constructor of class KFstab.
   * Draws the widget.
   * Each button calls a module that checks if theres a
   * device that can be mounted.
   * Also the options on each filesystem can be set.
   */
  KFstab( const char *name=0 );
  /**
   * This is called when the application is closed using any other
   * possiblities then File-Exit.
   */
  void closeEvent( QCloseEvent *e );

//  const int STATUS_FILENAME = 1;
  /**
   * In this public member we store when a item has changed.
   */
  bool itemsChanged;

 private:
/*   int childCount;
   int actualChild;
   int *disabledPtr;
*/
   KProcess kdfProc;
   KProcess kduProc;

   KMenuBar *menuBar;

   CListView *list;

   QLineEdit *str_device;
   QLineEdit *str_mpoint;
   QLineEdit *str_options;
   QLineEdit *str_comment;

// for future use
   QCheckBox *QCBDisabled;
     
   QComboBox *str_filesys;
   QComboBox *str_dump;
   QComboBox *str_fsck;

   QPushButton *but_add;
   QPushButton *but_del;
   QPushButton *but_rel;
   QPushButton *but_sav;
   QPushButton *but_prt;
   QPushButton *but_hlp;
   QPushButton *but_ext;
   QPushButton *but_mnt;
   QPushButton *QPBDevPreferences;
   QPushButton *QPBMPointPreferences;
   QPushButton *QPBOptPreferences;

  QListViewItem *item;

  void setIcon( QListViewItem *lvi );
  
  int menu_file_saveID;
  int menu_edit_addID;
  int menu_edit_deleteID;
  OptPreferences *op;
  DevPreferences *dp;
  TestMount *tm;

  QPrinter *printer;

 protected slots:
   /**
    * Calls closeEvent to close the window.
    */
   void closeWindow();
   /**
    * This method opens the fstab file and reads the values.
    */
   void openFile();
   /**
    * This method closes the actual changed fstab file and saves it to disc.
    * Before this the administrator is asked if he is sure about this.
    * Comments and disabled entries (for future use) will be saved.
    */
   virtual void closeFile();
   /**
    * This method is allways called when a item has changed.
    */
   void itemChanged( QListViewItem *item );
   /**
    * This method is called when a content has changed.
    */
   void contentChanged();
   /**
    * This method is used whenever a filesystem has changed.
    */
   void filesysChanged();
   /**
    * This method is used when a item is deleted.
    */
   void deleteItem();
   /**
    * This method is called when a item has been added.
    */
   void addItem();
   /**
    * This method starts kdf.
    */
   void callKdf();
   /**
    * This method starts kdu.
    */
   void callKdu();
   /**
    * This method calls the KDE-Help.
    */
   void helpSelected();
   /**
    * This method prints the current /etc/fstab file.
    */
   void printFile();
   /**
    * This method calls the device Preferences Class.
    */
   void devicePreferences();
   /**
    * This method calls the mount point preferences.
    */
   void mountPointPreferences();
   /**
    * This method calls the options Preferences Class.
    */
   void optionsPreferences();
   /**
    * This method is used to call class TestMount which tests
    * if a mount is successful.
    */
   void testMount();
#//   void disableButtonPressed();
//   void disableEntry( bool modus);

 public slots:  
   /**
    * This public slot is used to change text field and listbox of the options
    */
   void optionsPreferencesNew( QString optStr);
   /**
    * This public slot is used to change text field and listbox of the devices
    */
   void devicePreferencesNew( QString devStr );
};

#endif

