/***************************************************************************
                          testmount.h  -  description                              
                             -------------------                                         
    begin                : Mon Jul 12 1999                                           
    copyright            : (C) 1999 by Andreas Reuter                         
    email                : Andreas.Reuter@munich.netsurf.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef TESTMOUNT_H
#define TESTMOUNT_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qmultilinedit.h>

#include <kwizard.h>
#include <kprocess.h>

/**This is class TestMount.
This class makes it possible to test if a filesystem can be mounted.
  *@author Andreas Reuter
  */

class TestMount : public KDialog
{
   Q_OBJECT
 public:
   /** This is the Constructor of class TestMount.
    *
    * It draws the widget we need and calls the mount and umount programs.
    */
   TestMount( QString cmd2, QString cmd3, QString cmd5, QString cmd7,
      QWidget *parent=0, const char *name=0 );
   /**
    * This is the destructor of class TestMount.
    *
    * It cleans up if neccassary by killing a running mount or umount process.
    * If a filesystem is mounted it unmounts it.
    */
   ~TestMount();
 public slots:
   /**
    * This method executeMount is called whenever a mount is to be done.
    */
   void executeMount();
   /**
    * This method executeUmount is called whenever a umount is to be done.
    */
   void executeUmount();
   /**
    * This method calls executeMount and afterwards executeUmount and
    * does some testing if everything went ok.
    */
   void doTestMount();
   /**
    * This method calls executeMount and does some testing if everything went ok.
    * Afterwards the selected partition is mounted.
    */
   void doPermanentMount();
   /**
    * This method calls executeUmount and does some testing if everything went ok.
    * Afterwards the selected partition is unmounted.
    */
   void doPermanentUmount();
 protected:
   /**
    * This MultiLineEdit is used to display the output of mount and umount.
    */
   QMultiLineEdit *QMLEmount;
 protected slots:
   /**
    * This slot is responsable when a KProcess is finished or killed.
    */
   virtual void slotProcessDead( KProcess * );
   /**
    * This slot is called whenever a output of a KProcess is send
    * using stdout or stderr.
    */
   virtual void slotCmdStdout( KProcess *, char *, int );
 private:
   /**
    * This method gives out a KMsgBox as an unstable condition has appeared.
    */
   void unstableCondition();
   /**
    * mountProc holds the KProcess which calls mount / umount.
    */
   KShellProcess mountProc;
   /**
    * This variable stores the 2nd argument for mount.
    * This is usualy the device.
    */
   QString cmd2;
   /**
    * This variable stores the 3rd argument for mount.
    * This is usualy the moint point.
    */
   QString cmd3;
   /**
    * This variable stores the 5th argument for mount.
    * This is usualy the filesystemtype.
    */
   QString cmd5;
   /**
    * This vaiable stores the 7th argument for mount.
    * This are usualy the options.
    */
   QString cmd7;
   /**
    * This variable indicates if weare doing a mount or unmount process.
    * So only one combined method for the stdout and stderr can be used.
    */
   int mounting;
   /**
    * This variable stores if a mount process was successful.
    */
   int mountSuccess;
};

#endif

