////////////////////////////////////////////////////////////////////////
//  Originated by Logikos, Inc.  http://www.logikos.com
//
//  Class       : KGrepOptionDlg
//
//  File Name   : kgrepoptiondlg.cc
//
//  Originated  : 20-Sept-99  - Keith Brown (kbrown@logikos.com)
//
//  Abstract    : See notes in kgrepoptiondlg.h .
//
//  Compiler    : egcs-1.1.2, qt 1.44, KDE 1.1.1
//
//  Revisions   :
//
////////////////////////////////////////////////////////////////////////

// Compiler includes
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>

// Project includes
#include "kgrepoptiondlg.moc"

// Constants

// Globals

// Static attributes


////////////////////////////////////////////////////////////////////////
//
//  Function      : KGrepOptionDlg
//
//  Originated    : 20-Sept-99  - Keith Brown (kbrown@logikos.com)
//
//  Abstract      : Constructor.  Creates widgets.
//
//  Parameters    : parent - pointer to parent QWidget
//                  name   - pointer to internal name string
//                  modal  - boolean value indicating if this dialog is
//                           modal or not
//
//  Return Value  : none
//
//  Exceptions    : none
//
//  Revisions     : none
//
////////////////////////////////////////////////////////////////////////
KGrepOptionDlg::KGrepOptionDlg(QWidget* parent, const char* name, bool modal)
  :QDialog(parent, name, modal)
{
    // BEGIN
    setCaption(i18n("Options"));

    // Set up the external editor list
    m_editorList.setAutoDelete(true);
    m_editorList.append(new Editor("emacs", "+", true));
    m_editorList.append(new Editor("emacs-nox", "+", false));
    m_editorList.append(new Editor("jcc", "+", true));
    m_editorList.append(new Editor("kwrite", "", true));
    m_editorList.append(new Editor("vi", "+", false));
    m_editorList.append(new Editor("xemacs", "+", true));

    // Layout the widgets
    doLayout(this);

    // Hide the dialog after construction
    done(0);

    return;

}   // end KGrepOptionDlg::KGrepOptionDlg


////////////////////////////////////////////////////////////////////////
//
//  Function      : ~KGrepOptionDlg
//
//  Originated    : 20-Sept-99  - Keith Brown (kbrown@logikos.com)
//
//  Abstract      : Destructor.
//
//  Parameters    : none
//
//  Return Value  : none
//
//  Exceptions    : none
//
//  Revisions     : none
//
////////////////////////////////////////////////////////////////////////
KGrepOptionDlg::~KGrepOptionDlg()
{
    // BEGIN
    // NOTE: (From the memory-leak hunting HOWTO) "... when dealing with QWidgets
    //       and derived Qt and KDE subclasses: The destructor of a parent
    //       object destroys all child objects. This saves you from writing your
    //       own clean-up code for widgets that have been constructed with a
    //       pointer to the parent."

    return;

}   // end KGrepOptionDlg::~KGrepOptionDlg


////////////////////////////////////////////////////////////////////////
//
//  Function      : doLayout
//
//  Originated    : 20-Sept-99  - Keith Brown (kbrown@logikos.com)
//
//  Abstract      : Sets up the widgets in the dialog.
//
//  Parameters    : parent - Pointer to QWidget parent
//
//  Return Value  : none
//
//  Exceptions    : none
//
//  Revisions     : none
//
////////////////////////////////////////////////////////////////////////
void KGrepOptionDlg::doLayout(QWidget* parent)
{
    // Local variables
    QPushButton* cancelBtn = new QPushButton(i18n("Cancel"), parent, "cancelbtn");
    Editor*      ed;
    QLabel*      eLabel = new QLabel(i18n("External Editor:"), parent);
    QLabel*      lLabel = new QLabel(i18n("Line Number Argument Specifier:"), parent);
    QPushButton* okBtn  = new QPushButton(i18n("OK"), parent, "okbtn");
    QGridLayout* grid   = new QGridLayout(parent,  // parent is this window
                                          5,       // rows
                                          3,       // cols
                                          20,      // border spacing
                                          5        // widget spacing
                                          );


    // BEGIN
    // Set up the editor combo box
    eLabel->adjustSize();
    eLabel->resize((int)eLabel->sizeHint().width(), (int)eLabel->sizeHint().height()+6);
    eLabel->setMinimumSize(eLabel->size());

    m_editorCombo = new QComboBox(true, this, "editorcombobox");
    for (ed=m_editorList.first(); ed != 0; ed=m_editorList.next())
    {
        m_editorCombo->insertItem(ed->name());
    }   // end for
    m_editorCombo->setMinimumSize(m_editorCombo->sizeHint());

    // Set the pointer back to the first for later use
    ed = m_editorList.first();

    // Set up the line number argument specifier
    lLabel->setBuddy(m_lineNumSpecEdit);
    lLabel->adjustSize();
    lLabel->resize((int)lLabel->sizeHint().width(), (int)lLabel->sizeHint().height()+6);
    lLabel->setMinimumSize(lLabel->size());

    m_lineNumSpecEdit = new QLineEdit(parent, "linenumspecedit");
    m_lineNumSpecEdit->setMinimumSize(20, lLabel->height() + 2);
    m_lineNumSpecEdit->setMaximumSize(800, lLabel->height() + 2);
    m_lineNumSpecEdit->setText(ed->cla());

    // Set up the X application indicator checkbox
    m_xAppChkBox = new QCheckBox(i18n("Editor is X-based (not terminal-based)"), // text
                                 parent,                                         // parent
                                 "xchkbox"                                       // internal name
                                 );
    m_xAppChkBox->setMinimumSize(m_xAppChkBox->sizeHint());
    m_xAppChkBox->setChecked(ed->xapp());

    // Set up the buttons
    cancelBtn->setMinimumSize(cancelBtn->sizeHint());
    okBtn->setMinimumSize(okBtn->sizeHint());
    cancelBtn->setMaximumSize(cancelBtn->sizeHint());   // so I can use alignment on it
    okBtn->setMaximumSize(okBtn->sizeHint());           // so I can use alignment on it

    // Lay out the widgets
    grid->addWidget(eLabel, 0, 0);
    grid->addWidget(m_editorCombo, 0, 1);
    grid->addWidget(lLabel, 1, 0);
    grid->addWidget(m_lineNumSpecEdit, 1, 1);
    grid->addMultiCellWidget(m_xAppChkBox, 2, 2, 0, 1);
    grid->addMultiCellWidget(okBtn, 3, 3, 0, 0, AlignRight | AlignBottom);
    grid->addMultiCellWidget(cancelBtn, 3, 3, 1, 1, AlignRight | AlignBottom);

    grid->addRowSpacing(3, (int)okBtn->sizeHint().height() + 10);
    grid->setRowStretch(4, 1);
    grid->setColStretch(2, 1);
    resize(childrenRect().size());

    // Hook into signals I want
    connect(cancelBtn, SIGNAL(clicked()), this, SLOT(slotCancel()));
    connect(okBtn, SIGNAL(clicked()), this, SLOT(slotOK()));
    connect(m_editorCombo,                           // combo box
            SIGNAL(activated(const char*)),          // item activated
            this,                                    // I'll handle the signal
            SLOT(slotEditorSelected(const char*))    // slot to handle it
            );
    connect(m_lineNumSpecEdit,                       // edit field
            SIGNAL(textChanged(const char*)),        // text has changed
            this,                                    // I'll handle the signal
            SLOT(slotLineNumCLAChanged(const char*)) // slot to handle it
            );
    connect(m_xAppChkBox,                            // check box
            SIGNAL(clicked()),                       // check box clicked
            this,                                    // I'll handle the signal
            SLOT(slotXAppChkBoxClicked())            // slot to handle it
            );

    // Initialize the information strings
    m_extEditor.name(ed->name());
    m_extEditor.cla(ed->cla());
    m_extEditor.xapp(ed->xapp());

    return;

}   // end KGrepOptionDlg::doLayout()


////////////////////////////////////////////////////////////////////////
//
//  Function      : getEditorInfo
//
//  Originated    : 23-Sept-99  - Keith Brown (kbrown@logikos.com)
//
//  Abstract      : Returns protected member with desired info.
//
//  Parameters    : none.
//
//  Return Value  : poiter to class containing editor information.
//
//  Exceptions    : none
//
//  Revisions     : none
//
////////////////////////////////////////////////////////////////////////
const Editor* KGrepOptionDlg::getEditorInfo()
{
    // BEGIN
    return(&m_extEditor);

}   // end KGrepOptionDlg::getEditorInfo


////////////////////////////////////////////////////////////////////////
//
//  Function      : slotCancel
//
//  Originated    : 21-Sept-99  - Keith Brown (kbrown@logikos.com)
//
//  Abstract      : This function cancels the options dialog window.
//
//  Parameters    : none
//
//  Return Value  : none
//
//  Exceptions    : none
//
//  Revisions     : none
//
////////////////////////////////////////////////////////////////////////
void KGrepOptionDlg::slotCancel()
{
    // BEGIN
    done(0);

    return;

}   // end KGrepOptionDlg::slotCancel


////////////////////////////////////////////////////////////////////////
//
//  Function      : slotEditorSelected
//
//  Originated    : 21-Sept-99  - Keith Brown (kbrown@logikos.com)
//
//  Abstract      : This function writes the selected editor name to
//                  the protected member for storage when a new one
//                  is selected.
//
//  Parameters    : editor - Pointer to array of chars containing name
//
//  Return Value  : none
//
//  Exceptions    : none
//
//  Revisions     : none
//
////////////////////////////////////////////////////////////////////////
void KGrepOptionDlg::slotEditorSelected(const char* editor)
{
    // Local variables
    Editor* ed;


    // BEGIN
    for (ed=m_editorList.first(); ed != 0; ed=m_editorList.next())
    {
        if (!strcmp(ed->name(), editor))
        {
            m_lineNumSpecEdit->setText(ed->cla());
            m_xAppChkBox->setChecked(ed->xapp());

            return;
        }   // end if
    }   // end for

    // New editor typed in.  Add it to the list and update the GUI.
    m_editorList.append(new Editor(editor, "", false));
    m_lineNumSpecEdit->setText("");
    m_xAppChkBox->setChecked(false);

    return;

}   // end KGrepOptionDlg::slotEditorSelected


////////////////////////////////////////////////////////////////////////
//
//  Function      : slotLineNumCLAChanged
//
//  Originated    : 21-Sept-99  - Keith Brown (kbrown@logikos.com)
//
//  Abstract      : This function writes the line number command-line
//                  argument to the protected member for storage when
//                  it changes.
//
//  Parameters    : text - new edit field text
//
//  Return Value  : none
//
//  Exceptions    : none
//
//  Revisions     : none
//
////////////////////////////////////////////////////////////////////////
void KGrepOptionDlg::slotLineNumCLAChanged(const char* text)
{
    // Local variables
    Editor* ed;
    QString current;


    // BEGIN
    current = m_editorCombo->currentText();

    for (ed=m_editorList.first(); ed != 0; ed=m_editorList.next())
    {
        if (!strcmp(ed->name(), current))
        {
            // Write the new line number specifier into the list
            ed->cla(text);

            return;
        }   // end if
    }   // end while

    return;

}   // end KGrepOptionDlg::slotLineNumCLAChanged


////////////////////////////////////////////////////////////////////////
//
//  Function      : slotOK
//
//  Originated    : 23-Sept-99  - Keith Brown (kbrown@logikos.com)
//
//  Abstract      : This function is called when the user clicks the
//                  OK button.
//
//  Parameters    : none
//
//  Return Value  : none
//
//  Exceptions    : none
//
//  Revisions     : none
//
////////////////////////////////////////////////////////////////////////
void KGrepOptionDlg::slotOK()
{
    // BEGIN
    m_extEditor.name(m_editorCombo->currentText());
    m_extEditor.cla(m_lineNumSpecEdit->text());
    m_extEditor.xapp(m_xAppChkBox->isChecked());

    done(0);

    return;

}   // end KGrepOptionDlg::slotOK


////////////////////////////////////////////////////////////////////////
//
//  Function      : slotXAppChkBoxClicked
//
//  Originated    : 27-Sept-99  - Keith Brown (kbrown@logikos.com)
//
//  Abstract      : This function writes the value of the X application
//                  check box to the corresponding editor class.
//
//  Parameters    : none
//
//  Return Value  : none
//
//  Exceptions    : none
//
//  Revisions     : none
//
////////////////////////////////////////////////////////////////////////
void KGrepOptionDlg::slotXAppChkBoxClicked()
{
    // Local variables
    Editor* ed;
    QString current;


    // BEGIN
    current = m_editorCombo->currentText();

    for (ed=m_editorList.first(); ed != 0; ed=m_editorList.next())
    {
        if (!strcmp(ed->name(), current))
        {
            // Write the new value to the item in the list
            ed->xapp(m_xAppChkBox->isChecked());

            return;
        }   // end if
    }   // end while

    return;

}   // end KGrepOptionDlg::slotXAppChkBoxClicked



//  end file kgrepoptiondlg.cc