/**
* @short GUI frontend class
*
* KGrepUI provides all the frontend GUI code for this utility.  It sets up
* the menubar (KMenuBar), toolbar (KToolBar), status bar (KStatusBar),
* list box (KTabListBox), and editing window (@see KGrepEdit)
*
* @author Keith Brown <kbrown@logikos.com>, Jeff Cody <jcody@logikos.com>
* @version 0.0.1
**/

////////////////////////////////////////////////////////////////////////
//
//  Originated by Logikos, Inc.  http://www.logikos.com
//
//  Class Name  : KGrepUI
//
//  File Name   : kgrepui.h
//
//  Originated  : 6-Sept-99  Keith Brown (kbrown@logikos.com),
//                           Jeff Cody   (jcody@logikos.com)
//
//  Abstract    : GUI frontend class.  Contains a listbox for grep results,
//                and then a derivative of the KEdit class for file editing.
//                This class also spawns the grep process, and parses the
//                results.
//
//  Compiler    : egcs-1.1.2, qt 1.44, KDE 1.1.1
//
//  Revisions   :
//
////////////////////////////////////////////////////////////////////////
#ifndef KGREPUI_H
#define KGREPUI_H

// Compiler includes
#include <kapp.h>
#include <kmenubar.h>
#include <kmsgbox.h>
#include <knewpanner.h>
#include <kprocess.h>
#include <kstatusbar.h>
#include <ktablistbox.h>
#include <ktoolbar.h>
#include <ktmainwindow.h>
#include <qpixmap.h>
#include <qpopupmenu.h>
#include <qstring.h>

// Project includes

// Types and constants

// Forward declarations
class KGrepEdit;
class KGrepOptionDlg;
class KGrepSearchDlg;



class KGrepUI : public KTMainWindow
{
    // Meta-object compiler thingy
    Q_OBJECT

    // Attributes
    protected:
        KGrepEdit*      m_edit;                 // Display/edit file here
        QPopupMenu*     m_fileMenu;             // "File" menu
        KShellProcess*  m_grepProcess;          // The grep process
        QPopupMenu*     m_helpMenu;             // "Help" menu
        KTabListBox*    m_listbox;              // List of files with/without matches
        KMenuBar*       m_menubar;              // The application's menubar
        int             m_menuItemExtEditorID;  // Ext editor menu item ID
        int             m_menuItemNextID;       // Next match menu item ID
        int             m_menuItemPrevID;       // Previous match menu item ID
        int             m_menuItemSearchID;     // New search menu item ID
        KGrepOptionDlg* m_optionDlg;            // Modal Options dialog
        KNewPanner*     m_panner;               // Panner container for the two windows
        QString         m_prevFilename;         // Previous file loaded into editor
        int             m_resultLength;         // Output length from grep
        QString         m_resultString;         // Output from grep
        KGrepSearchDlg* m_searchDlg;            // Search dialog
        QPopupMenu*     m_searchMenu;           // "Search" menu
        KStatusBar*     m_statusbar;            // The application's statusbar
        KToolBar*       m_toolbar;              // The application's toolbar


    // Methods
    public:
        /** Constructor. */
        KGrepUI();

        /** Destructor. */
        ~KGrepUI();

        /**
         * Override of KTMainWindow::closeEvent.  This is automatically
         * called when the widget is closed.
         **/
        void closeEvent(QCloseEvent *);

    public slots:
        /** Slot for incoming grep strings to fire off the process. */
        void slotDoGrep(QString grep);

        /** Slot (event-hadler) for application exiting. */
        void slotExit();

        /** Slot to open selected file in external editor. */
        void slotExtEditor();

	    /** Slot to receive grep results on stdout. */
        void slotGrepResults(KProcess *proc, char *results, int result_length);

        /** Slot to open of file for editing when user double-clicks on grep results. */
        void slotGrepResultSelected(int row, int col);

        /** Slot to pop up the modal search dialog. */
        void slotNewSearch();

        /** Slot to go to the next match in the results. */
        void slotNextMatch();

        /** Slot to pop up the options dialog. */
        void slotOptions();

        /** Slot to go to the previous match in the results. */
        void slotPrevMatch();

    protected:
        /** Enable/disable widgets that depend on matches existing. */
        void enableDependentBtns(bool enable);

        /** Parse contents of m_resultString into listbox. */
        void processOutput();

};  // end class KGrepUI


// Inline function declarations


#endif // KGREPUI_H

// end file kgrepui.h
