/*
 * heisewrapper.h
 *
 * Copyright (c) 1998 Michael Kropfberger <mkropfbe@edu.uni-klu.ac.at>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef _HEISEWRAPPER_H
#define _HEISEWRAPPER_H


#include <qapp.h>
#include <qpushbt.h>
#include <qscrbar.h>
#include <qlcdnum.h>
#include <qfont.h>
#include <qlayout.h>
#include <qmlined.h>

#include <ktopwidget.h>
#include <kstdaccel.h>
#include <kiconloader.h>
#include <kprocess.h>



class HeiseWrapper : public QWidget {
    Q_OBJECT

 public:
   enum PatternConjunctionMode { AND=1, OR=2 };

   enum Mode { ON=1, OFF=2, AUTO=3 };

   HeiseWrapper(QWidget *parent=0,const char *name=0);

   void startSearch(QStrList *patterns);

   void stopSearch();

   bool isSearching() { return backEndProc->isRunning(); };

   void setPatternConjunctionMode(PatternConjunctionMode pcj)
         {  conjunctPatternsByAND = 
                (pcj==AND); };

   PatternConjunctionMode patternConjunctionMode() 
         { return (conjunctPatternsByAND?AND:OR); };

   void setPhoneticSearchMode(bool mode) {phoneticSearch=mode;};

   bool phoneticSearchMode() {return phoneticSearch;};

   void setElimDuplicatesMode(bool mode) {elimDuplicates=mode;};

   bool elimDuplicatesMode() {return elimDuplicates;};

   void setIgnoreCaseMode(Mode mode) {ignoreCase=mode;};

   Mode ignoreCaseMode() {return ignoreCase;};

   void setRegExprMode(Mode mode) {regExpr=mode;};

   Mode regExprMode() {return regExpr;};

   void setUmlautConversionMode(Mode mode) 
                         {umlautConversion=mode;};

   Mode umlautConversionMode() {return umlautConversion;};

   void updateDB(QString file);

   bool DB_isWritable();

 protected:
   void resizeEvent(QResizeEvent *); 

 signals:
   void searchDone();
 
 public slots:

 private slots:
   void receivedStdErrOutSlot(KProcess *, char *, int);
   void searchDoneSlot();  

 private:
  QMultiLineEdit *outputMLE;
  KProcess       *backEndProc;

  QString        *heisereg_path;
  QString        *heisereg_proggy;
  QString        *heisereg_frm;
  bool           backEndKilled;
  int            nrOfReceivedStdErrOut;

  //parameters
  bool           conjunctPatternsByAND;
  bool           phoneticSearch;
  bool           elimDuplicates;

  Mode           ignoreCase;
  Mode           regExpr;
  Mode           umlautConversion;  
};

#endif  /* ifdef _HEISEWRAPPER_H */
