#include <kapp.h>
#include <kwm.h>
#include <ktopwidget.h>

#include <qwidget.h>
#include <qevent.h>
#include <qpainter.h>

#include "kisdnload.h"



TIsdnLoad::TIsdnLoad( const char *name )
    : KTopLevelWidget ( name ) {

    Menu = new KPopupMenu("KISDNLoad");
    Menu->insertItem( "Quit", kapp, SLOT(quit()) );
    
    pppstat = new PPPStatus();
    connect( pppstat, SIGNAL( sigNewScan(PPPInfo*) ),
    		this, SLOT( updateGraph(PPPInfo*) ) );
    memset( graph, 0, sizeof(graph) );

    dual = false;

}


TIsdnLoad::~TIsdnLoad() {

}


void TIsdnLoad::updateGraph( PPPInfo *stat ) {

  for ( int i = 0; i < kMaxHist-1; i++ ) {
    graph[i] = graph[i+1];
    dual = ( graph[i] > 8.0 );
  }
  if ( ( stat->inRate[0] + stat->inRate[1] ) > 
       ( stat->outRate[0] + stat->outRate[1] ) )
    graph[kMaxHist-1]  = stat->inRate[0] + stat->inRate[1];
  else
    graph[kMaxHist-1]  = stat->outRate[0] + stat->outRate[1];
  
  dual = ( graph[kMaxHist-1] > 8.0 );

  repaint();

}


void TIsdnLoad::paintEvent(QPaintEvent *)
{
    QPainter p;
    int      h;
    int      box_w = kMaxHist;
    int      box_h = kMaxHist;
    float    max = ( dual ? 16.0 : 8.0 );


    p.begin(this);
    p.setWindow( 0, 0, box_w, box_h );
    p.fillRect( 0, 0, box_w, box_h, black );


    p.setPen(green);
    for ( int i=0; i<kMaxHist; i++ ) {
    
      h = (int) ( graph[i]*( (box_h-3) / max ) );
      p.drawLine( i, box_h, i, box_h-h );
    
    }


    p.end();
}


    
void TIsdnLoad::mouseReleaseEvent( QMouseEvent *ev ) {

  if ( ev->button() == RightButton ) {
    Menu->popup( QPoint( this->x(), this->y() ), 6 );
    Menu->exec();
  }

}





int main( int argc, char **argv )
{
  
  KApplication *app;

  app = new KApplication( argc, argv, "kisdnload" );
    
  TIsdnLoad  *iload = new TIsdnLoad( "KISDNLoad" );

  if ( app->isRestored() ) {
    
    if ( KTopLevelWidget::canBeRestored(1) )
      iload->restore(1);
    
  }

  app->setMainWidget( iload );

  KWM::setDockWindow( iload->winId() );
  iload->show();
  
  return app->exec();
  
}


#include "kisdnload.moc"
