//////////////////////////////////////////////////////////////////////////////
// This software is distributed under the terms of the General Public License.
//
// Class   : kless
// Author  : Norbert Drees
// E-Mail  : norbert@et-inf.fho-emden.de
//////////////////////////////////////////////////////////////////////////////

#include "about.h"

AboutWindow::AboutWindow(	
					const char *title,
					const char *text,
					const uint lines,
					const uint speed,
					const uint width,
					const uint height,
					const char *picture,
					QWidget *parent,
					const char *name
		)
		: QDialog( parent, name , true ), str( text ), pos( 0 ), w( width ), h( height ) {

	
	#ifdef ABOUT_WITH_KDE
		setCaption( klocale->translate( title ) );
	#else
		setCaption( title );
	#endif

	QPixmap pm;
	bool pix = pm.load( picture );
	uint pm_height;
	scroll_height = lines * 100;
	sp = speed;

	if( pix ) {
	
		pm_height = pm.height() + 10;
	
		QLabel *Show_Picture = new QLabel( this );
		Show_Picture->setFixedSize( pm.width(), pm.height() );
		Show_Picture->setFrameStyle( QFrame::Panel | QFrame::Raised );
		Show_Picture->setAlignment( AlignCenter );
		Show_Picture->setPixmap( pm );
		
		w = (uint)pm.width() > w ? pm.width() : w;		
		Show_Picture->move( w / 2 - pm.width() / 2 + 10, 10 );
		
	} else {
		pm_height = 0;
	}	

	scroll_label = new QPushButton( this );
//	scroll_label->setFrameStyle( QFrame::Panel | QFrame::Sunken );
	scroll_label->setToggleButton( true );
	scroll_label->toggle();
	scroll_label->setFixedSize( w, h );
	scroll_label->move( 10, pm_height + 10 );
	connect( scroll_label, SIGNAL( toggled( bool ) ), this, SLOT( setScrolling( bool ) ) );

	QPushButton *OK_Button = new QPushButton( this );
	#ifdef ABOUT_WITH_KDE
		OK_Button->setText( klocale->translate( "Dismiss" ) );
	#else
		OK_Button->setText( "Dismiss" );
	#endif
	OK_Button->setFont( QFont( "helvetica", 12, QFont::Normal ) );
	connect( OK_Button, SIGNAL( released() ), this, SLOT( accept() ) );

	OK_Button->setFixedSize( w, 25 );
	OK_Button->move( 10, pm_height + h + 20 );

	timer = new QTimer( scroll_label );
	connect( timer, SIGNAL( timeout() ), SLOT( scrollText() ) );
	setScrolling( true );

	resize( w + 20, pm_height + h + 55 );
	setFixedSize( size() );
}

void AboutWindow::setScrolling( bool state ) {
	if( state ) timer->start( sp );
	else {
		timer->stop();
		repaint( false );
	}
}

void AboutWindow::scrollText() {

	if( isVisible() ) {
		pos += 1;
	}
	repaint( false );
} 

void AboutWindow::paintEvent( QPaintEvent * ) {

	QPixmap pm( w, h );
	pm.fill( white );
	QPainter p( &pm );
	p.setFont( QFont( "Helvetica", 12, QFont::Normal ) );
	QRect rc = p.boundingRect(
		0,
		0,
		w,
		scroll_height,
		AlignHCenter|AlignTop,
		str
	);
	p.drawText(
		0,
		h - pos,
		w,
		rc.height(),
		AlignHCenter | AlignTop,
		str
	);
	if( pos > h + rc.height() ) {
		pos = 0;
	}
	p.end();
	bitBlt( scroll_label, 1, 1, &pm, 1, 1, w - 2, h - 2 );
}
