#include <klibreta.h>
#include <klibreta.moc>
#include <kiconloader.h>

#include <dirent.h>
#include <sys/stat.h>
#include <qpainter.h>
#include <qclipbrd.h>
#include <limpiador.h>
#include <kapp.h>

//function from Kget 0.4 and changed by me

void testDir( const char *_name ) 
{
  DIR *dp;
  QString c =kapp->localkdedir();
  c += _name;
  dp = opendir(c.data());
  if (dp == NULL)
    ::mkdir(c.data(), S_IRWXU);
  else
    closedir(dp);
}


KLibreta::KLibreta(QWidget *parent, const char *name)
	: KTopLevelWidget(name)
{
	setMinimumSize(524,200);
	KApplication *myapp;
	
	view = new KLibretaWidget(this);
	setView(view);

	QPopupMenu *file_menu = new QPopupMenu();
	file_menu->insertItem(i18n("E&xit"), kapp, SLOT(quit()));
	
	QPopupMenu *edicion= new QPopupMenu();
	edicion->insertItem(i18n("&Add"),view, SLOT(newContact()));

	edicion->insertItem(i18n("&Properties"),view,
		SLOT(PreparaPropiedades()));

 	edicion->insertItem(i18n("&Clear"),view, 
		SLOT(eliminaContacto()));

	edicion->insertItem(i18n("&Send mail"),view, 
		SLOT(notimplemented()));
/*
	QPopupMenu *help_menu = new QPopupMenu();
	help_menu->insertItem(i18n("&Contents"), this, SLOT(invokeHelp()));
*/

 // *********************  build the help menu  ***************************

    char* help = new char [400];
    QPopupMenu *helpmenu = new QPopupMenu();
    strcpy (help, "KLibreta  ");
    strcat (help, VERSION);
    strcat (help, 
	    i18n("\n\n(c) 1998 by\nTobeSoft. A Division of The Mushroom"));
    strcat (help, 
	  i18n("\n\nWritten by Pablo Montesinos.Icons by Kenny Lim."));
    strcat (help, 
	   i18n("\n\nEmail: jmontesinosp@nexo.es"));
    strcat (help, i18n("\nHomepage: http://www.est.unileon.es/klibreta"));
    strcat (help, i18n("\n\nThanks to all translators!"));

    helpmenu = KApplication::getKApplication()->getHelpMenu (TRUE, 
						 i18n(help));
    delete help;

	menuBar = new KMenuBar(this, "menubar");
	menuBar->insertItem(i18n("&File"), file_menu);
	menuBar->insertItem(i18n("&Contact"), edicion);
	menuBar->insertItem(i18n("&Help"), helpmenu);
	setMenu(menuBar);

	statusBar = new KStatusBar(this);
	setStatusBar(statusBar);

	

	//test and prepare the directory
	
	testDir("/share");
  	testDir("/share/apps");
  	testDir("/share/apps/klibreta");


	
			 
}

KLibreta::~KLibreta()
{
	delete statusBar;
	delete menuBar;
	delete view;
	QString c=kapp->localkdedir();
	c+=(const char*)"/share/apps/klibreta/";
	tenn limpia((const char*)c,(const char*)"file.out");
	
}

void KLibreta::invokeHelp()
{
	kapp->invokeHTMLHelp("klibreta/klibreta.html", "");
}


