/*
 *            klm: A lm_sensors front end for the KDE project
 *
 * $Id: LMStats.h,v 1.20 1999/02/13 11:45:59 humphrey Exp $
 *
 *            Copyright (C) 1998 Brendon Humphrey
 *                   brendy@swipnet.se
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef LMSTATS_H
#define LMSTATS_H

#include <qtimer.h>
#include <kstatusbar.h>


class Sensor;
class VertItem;

#define MAX_SENSORS 100

typedef struct 
{
  int    		num_sensors;
  Sensor 		*sensors[MAX_SENSORS];
  VertItem	*graphs[MAX_SENSORS];
} MachineType;


class LMStats : public QWidget
{
  Q_OBJECT
  
private:
  int 		temp;
  MachineType	*m;
  
public:
  
  LMStats
  (
    QWidget *parent = NULL,
    const char *name = NULL,
    MachineType *machine = NULL,	
    KStatusBar *statusBar = NULL	);
  
  ~LMStats();
  
  void update();
  
public slots:
  void saveQuit();
  void graphDisabled();
  
signals:
  void reloadMe();	
};



#endif // LMStats_included
