/*
 *            klm: A lm_config front end for the KDE project
 *
 * $Id: Settings.cpp,v 1.3 1999/02/03 22:19:37 humphrey Exp $
 *
 *            Copyright (C) 1998 Brendon Humphrey
 *                   brendy@swipnet.se
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <qslider.h>

#include "Settings.h"

#define Inherited SettingsData

Settings::Settings
(
  QWidget* parent,
  const char* name
  )
:
Inherited( parent, name )
{
  setCaption( "Klm Settings" );
}


Settings::~Settings()
{
}

void Settings::newSliderValue( int val )
{
  QString str;
  
  str.sprintf("%d", val);
  txtInterval->setText(str.data());
  emit( newInterval( val ));
}

void Settings::beepButtonToggled( bool state )
{
  emit beepOnFault( state );
}

void Settings::execScriptToggled( bool state )
{
  emit scriptOnFault( state );
}

void Settings::setScriptStr( QString &str )
{
  txtScriptCmd->setText( str.data() );
}

QString Settings::getScriptStr()
{
  return txtScriptCmd->text();
}

void Settings::setBeepOnAlarm( bool s )
{
  cbBeep->setChecked( s );
}

void Settings::setInterval( int val )
{
  QString str;
  
  str.sprintf("%d", val);
  txtInterval->setText(str.data());
  updateSlider->setValue(val);	
}

void Settings::setScriptOnAlarm( bool s )
{
  cbExecScript->setChecked( s );
  txtScriptCmd->setEnabled( s );
}

void Settings::okClicked()
{
  emit okPressed();
}

#include "Settings.moc.cpp"
