/*
 *            klm: A lm_config front end for the KDE project
 *
 * $Id: Settings.h,v 1.6 1999/02/07 02:18:32 humphrey Exp $
 *
 *            Copyright (C) 1998 Brendon Humphrey
 *                   brendy@swipnet.se
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef Settings_included
#define Settings_included

#include "SettingsData.h"

class Settings : public SettingsData
{
  Q_OBJECT
  
public:
  
  Settings
  (
    QWidget* parent = NULL,
    const char* name = NULL
      );
  
  virtual ~Settings();
  
  void setInterval( int val );	
  void setScriptStr( QString &str );
  QString getScriptStr();
  void setBeepOnAlarm( bool );
  void setScriptOnAlarm( bool );
  
signals:
  void newInterval( int );
  void beepOnFault( bool );
  void scriptOnFault( bool );
  void okPressed();
  
public slots:
  void beepButtonToggled( bool );
  void newSliderValue( int );
  void execScriptToggled( bool );
  void okClicked();
};

#endif 
