#ifndef KLOOKUPWIDGET_H 
#define KLOOKUPWIDGET_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <qwidget.h>
#include <kapp.h>
#include <ktablistbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <klined.h>
#include <kstatusbar.h>
#include <ktmainwindow.h>

#include "backend.h"

/**
 * This class is the main view for KLookup.  Most non-menu, non-toolbar,
 * and non-status bar GUI code should go here.
 *
 * @short Main view
 * @author Arun Sharma <adsharma@home.com>
 * @version 0.1
 */
class KLookupWidget : public QWidget
{
	Q_OBJECT
public:
	/**
	 * Default constructor
	 */
	KLookupWidget(QWidget *parent = 0, const char *name = 0,
		      KTMainWindow *m = 0);

	/**
	 * Destructor
	 */
	virtual ~KLookupWidget();

public slots:
	int Lookup();
	
private:
	QVBoxLayout 		*layout;
	QHBoxLayout		*queryBox;
	KLined	    		*queryText;
	QLabel	    		*queryLabel;
	KTabListBox 		*addrList;
	Backend			*backEnd;
	KTMainWindow		*mainw;
};

#endif // KLOOKUPWIDGET_H 
