/*
	This file is part of `klp', a KDE Line Printer queue manager

	Copyright (C) 1998
	Frans van Dorsselaer
	<dorssel@MolPhys.LeidenUniv.nl>

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <qpixmap.h>
#include <qpopupmenu.h>
#include <qcursor.h>
#include <qmenudata.h>
#include <qtooltip.h>

#include <kapp.h>
#include <kwm.h>

#include "mainw.h"
#include "dock.h"

#include "pixmaps/dock_ready.xpm"
#include "pixmaps/dock_fault.xpm"
#include "pixmaps/dock_stop.xpm"
#include "pixmaps/dock_pause.xpm"
#include "pixmaps/dock_play.xpm"
#include "pixmaps/dock_busy.xpm"
#include "pixmaps/dock_play_busy.xpm"
#include "pixmaps/dock_pause_busy.xpm"
#include "pixmaps/dock_stop_busy.xpm"
#include "pixmaps/dock_fault_busy.xpm"


DockWindow::DockWindow(MainWindow *mw) : QLabel() , main_window(mw)
{
	setActivePrinter(main_window->getActivePrinter());
	setBusy(main_window->getBusy());
	setPrinterState(main_window->getPrinterState());

	drop_zone = new KDNDDropZone(this, DndURL);
	connect(drop_zone, SIGNAL(dropAction(KDNDDropZone *)), main_window, SLOT(dropAction(KDNDDropZone *)));

	connect(main_window, SIGNAL(printerStateChanged(PrinterState)), SLOT(setPrinterState(PrinterState)));
	connect(main_window, SIGNAL(activePrinterChanged(int)), SLOT(setActivePrinter(int)));
	connect(main_window, SIGNAL(busyChanged(bool)), SLOT(setBusy(bool)));

	KWM::setDockWindow(winId());
}


DockWindow::~DockWindow()
{
	delete drop_zone;
}


void DockWindow::setPrinterState(PrinterState ps)
{
	printer_state = ps;
	setPixmap();
}


void DockWindow::setBusy(bool b)
{
	busy = b;
	setPixmap();
}


void DockWindow::setPixmap()
{
	const char **s;

	switch(printer_state) {
		case printer_ready:
			s = (const char **)(busy ? dock_busy : dock_ready);
			break;
		case printer_pause:
			s = (const char **)(busy ? dock_pause_busy : dock_pause);
			break;
		case printer_stop:
			s = (const char **)(busy ? dock_stop_busy : dock_stop);
			break;
		case printer_play:
			s = (const char **)(busy ? dock_play_busy : dock_play);
			break;
		case printer_fault:
		default:
			s = (const char **)(busy ? dock_fault_busy : dock_fault);
	}
	QLabel::setPixmap(QPixmap(s));
}


void DockWindow::mousePressEvent(QMouseEvent *event)
{
	if (event->button() == LeftButton)
		main_window->updateQueue();
	else if (event->button() == RightButton) {
		QPopupMenu menu;

		menu.insertItem(i18n("Show &queue"), main_window, SLOT(show()), -2);
		menu.insertItem(i18n("&Update queue"), main_window, SLOT(updateQueue()), -2);
		menu.insertSeparator();

		QPopupMenu printer_menu;
		PrinterList &pl = main_window->getPrinters();
		Printer *p;
		for (p = pl.first() ; p ; p = pl.next()) {
			printer_menu.insertItem(p->description, pl.at());
		}
		int i = main_window->getActivePrinter();
		if (i >= 0)
			printer_menu.setItemChecked(i, true);
		connect(&printer_menu, SIGNAL(activated(int)), main_window, SLOT(setActivePrinter(int)));

		int idx = menu.insertItem(i18n("Select &printer"), &printer_menu, -2);
		menu.setItemEnabled(idx, (pl.count() > 0) && !busy);

		menu.insertSeparator();
		menu.insertItem(i18n("E&xit"), main_window, SLOT(exit()), -2);
		menu.exec(QCursor::pos());
	}
}


void DockWindow::mouseDoubleClickEvent(QMouseEvent *event)
{
	if (event->button() == LeftButton)
		main_window->show();
}


void DockWindow::setActivePrinter(int ap)
{
	if (ap >= 0) {
		description = main_window->getPrinters().at((unsigned int)ap)->description;
	} else
		description = i18n("(no printer selected)");
	QToolTip::remove(this);
	QToolTip::add(this, description);
}


#include "dock.moc"
