#ifndef INTER_H
#define INTER_H

#ifdef __cplusplus
extern "C" {
#endif

extern int check_root(void);
extern void drop_root(void);
extern int tmp_as_root(void);
extern void tmp_drop_root(void);

extern int start_server(void);

extern int pipe_r;
extern int pipe_w;

extern const char * const username;

extern int iwrite_char(char c);
extern int iwrite_string(const char *fmt, ...);
extern int iwrite_int(int i);
extern int iread_char(char *c);
extern int iread_string(char **s);
extern int iread_int(int *i);


struct queue_item {
	int rank;
	char *job_name;
	char *user;
	char *job_id;
	int size;
};

struct queue {
	int no_print;
	int no_queue;
	int item_count;
	struct queue_item **items;
};

extern const struct queue_item empty_queue_item;
extern const struct queue empty_queue;

extern void free_queue_item(struct queue_item *item);
extern void free_queue(struct queue *queue);


struct server {
	const char *description;
	char *(*set_printer)(const char *host, const char *printer);
	int (*q_main)(void);
	int (*p_main)(const char * const files[]);
	int (*r_main)(const char * const jobids[]);
	struct queue *(*q_parse)(char *reply, char *errors, int retval);
	void (*p_parse)(const char * const files[], char *reply, char *errors, int retval);
	void (*r_parse)(const char * const jobids[], char *reply, char *errors, int retval);
	char **(*printer_list)(void);
	int local;
	int remote;
};


#define SERVER_COUNT	3
extern const struct server servers[];

#ifdef __cplusplus
}
#endif

#endif /* INTER_H */
