#ifndef MAINW_H
#define MAINW_H

#include <ktmainwindow.h>

#include "common.h"

class QSocketNotifier;
class KConfig;
class KDNDDropZone;
class QLabel;
class QTimer;
class QStrList;

class DockWindow;
class QueueBox;
struct options;


class MainWindow : public KTMainWindow
{
	Q_OBJECT
public:
	MainWindow(struct options *opts = NULL);
	virtual ~MainWindow();
	virtual bool close(bool forceKill = false);
	int getActivePrinter() { return active_printer; }
	PrinterList &getPrinters() { return printers; }
	bool getBusy() { return busy; }
	PrinterState getPrinterState() { return printer_state; }
	bool shouldShow() { return should_show; }
signals:
	void printerStateChanged(PrinterState new_printer_state);
	void printersChanged();
	void activePrinterChanged(int active);
	void busyChanged(bool b);
public slots:
	void toggleDock();
	void toggleStatusBar();
	void toggleToolBar();
	void autoUpdate();
	void exit();
	void dropAction(KDNDDropZone *drop_zone);
	void readServer();
	void selectPrinter();
	void saveOptions();
	void setActivePrinter(int i);
	void removeJobs();
	void abortAction();
	void updateQueue();
	void highlighted(int, int);
	void popupMenu(int, int);
protected:
	virtual void saveProperties(KConfig* config);
	virtual void readProperties(KConfig* config);
	void readProperties(KConfig* config, struct options *opts);
	void setPrinterState(PrinterState new_printer_state);
	void setBusy(bool new_busy);
	void readConfig(KConfig *config, struct options *opts);
	void writeConfig(KConfig *config);
	void readPrinters(KConfig *config);
	void writePrinters(KConfig *config);
	void updateCombo();
	QSocketNotifier *socket_notifier;
	DockWindow *dock_window;
	PrinterState printer_state;
	bool busy;
	QueueBox *queue_box;
	PrinterList printers;
	int active_printer;
	bool auto_update;
	int update_interval;
	QLabel *printer_status;
	QLabel *busy_status;
	void saneUpdateQueue();
	void saneRemoveJobs();
	void saneStop();
	void saneSelectPrinter();
	void saneGUI();
	char current_command;
	bool expect_abort;
	QTimer *update_timer;
	void sendJob(QStrList &files);
	bool should_show;
};


#endif // MAINW_H
