#ifndef SELECT_H
#define SELECT_H

#include <qdialog.h>

#include "common.h"

class QPushButton;
class QListBox;


class SelectDialog : public QDialog {
	Q_OBJECT
public:
	SelectDialog(PrinterList &p, int a, QWidget *parent = 0, const char *name = 0);
	int activePrinter() { return active; }
	bool activeChanged() { return active_changed; }
	bool printersChanged() { return printers_changed; }
protected:
	virtual void resizeEvent(QResizeEvent *event);
protected slots:
	virtual void done(int r);
	void addPrinter();
	void editPrinter();
	void removePrinter();
	void highlighted(int i);
private:
	QPushButton *ok;
	QPushButton *cancel;
	QPushButton *add;
	QPushButton *edit;
	QPushButton *remove;
	QListBox *listbox;
	PrinterList &printers;
	int active;
	bool active_changed;
	bool printers_changed;
};


#endif // SELECT_H
