#include <stdio.h>
#include <time.h>
#include <kapp.h>
#include <qpushbutton.h>
#include <math.h>
#include "dlgdetails.h"

DetailsDlg::DetailsDlg(SetiPtr iSP, const char* name=0):
     KTMainWindow (name)
{
char Strg[128];

   setBackgroundColor(QRgb(0));
   SP=iSP;
   setFixedSize(750,480);
   sprintf(Strg,"Data Garbage Window - %s",SP->Name);
   setCaption(Strg);
   Line=100; // 100=Kennung: nicht Initialisiert
   SetupColors();
   QTime Q=QTime::currentTime();
   srand(Q.msec());
   DisplayCount=0;

   Painter = new QPainter();
   Pnts4 = new QPointArray(4);

   ProgressRect=new QRect(12,200,370,20);  // Statusbar
   MiscAnalysisRect= new QRect(10,78, 385,26);  // Frequency resolution
   //PeakRect= new QRect(10,118,250,25);     // Strongest Peak
   GaussianRect= new QRect(10,105, 385,65);// Strongest Gaussian
   DataInfoRect= new QRect(440,74, 300,57);// Data Info
   UserInfoRect= new QRect(440,166,300,40);// Data Info
   DataGarbageRect= new QRect(0,230,750,250);// DataGarbage

   StartupFlag=TRUE;
   Timer = new QTimer();
   connect(Timer,SIGNAL(timeout()),SLOT(TimerTic()));
   Timer->start(2000);

   //QPushButton* CloseBtn = new QPushButton("Close", this);
   //CloseBtn->setGeometry(10,450,50,25);
   //connect(CloseBtn,SIGNAL(clicked()), this, SLOT(CloseBtnClick()));
//debug("DetailsDlg::DetailsDlg - Ende");
}

void DetailsDlg::paintEvent( QPaintEvent * qep) {
debug("paintEvent type=%d  %d %d %d %d",qep->type(),qep->rect().left(),qep->rect().right(),qep->rect().top(),qep->rect().bottom());
QFont Font;

//debug("DetailsDlg::paintEvent");
   Painter->begin(this);
   Font = Painter->font();
   Painter->setPen(NoPen);

   Painter->setBrush(QColor(64,64,255));
   Painter->drawRect(5, 44,740,7);
   Painter->drawRect(5,220,740,7);
   Painter->drawRect(400,44,30,180);  // senk. mitte
   Painter->drawRect(430,136,315,7);  // waag. links mitte

   // Bereich Userinfo aktualisieren
   Painter->setPen(SolidLine);
   Painter->setPen(QColor(255,255,255));
   Painter->drawText(10,20, "look@seti   blablabla...");
   Font.setBold(TRUE);
   Painter->setFont(Font);
   Painter->drawText(120,57, 150,20, AlignHCenter, i18n("Analysis"));
   Painter->drawText(510,57, 150,20, AlignHCenter, i18n("Data Info"));
   Painter->drawText(510,150,150,20, AlignHCenter, i18n("User Info"));
   Font.setBold(FALSE);
   Painter->setFont(Font);

   if (DataInfoRect->intersects(qep->rect()))
      DataInfoAnzeige();

   if (UserInfoRect->intersects(qep->rect()))
      UserInfoAnzeige();

   if (MiscAnalysisRect->intersects(qep->rect()))
      MiscAnalysisAnzeige();

   // Peak-Werte
   //if (PeakRect->intersects(qep->rect()))
   //   PeakAnzeige();
   if (GaussianRect->intersects(qep->rect()))
      GaussianAnzeige();

   if (DataGarbageRect->intersects(qep->rect()))
      DataGarbageAnzeige(FALSE);

   if (ProgressRect->intersects(qep->rect())) {
      debug("Draw Satusbar");
      Bar3dGrid(12,200, 360,20, 8,8,  64,64,64);
      FortschrittsAnzeige();
   }
   Painter->end();
}

void DetailsDlg::PeakValueAnzeige(int x, int y, int Val, int Peak) {
// Pixelanzeige darstellen
int Lauf;

   Painter->setPen(NoPen);
   for (Lauf=0; Lauf<12; Lauf++) {
      if ( (Lauf<Val) || (Lauf==Peak)) {
         if (Lauf<4)
            Painter->setBrush(QColor(0,255,0));
         else
         if (Lauf<8)
            Painter->setBrush(QColor(255,255,0));
         else
            Painter->setBrush(QColor(255,0,0));
      } else {
         if (Lauf<4)
            Painter->setBrush(QColor(0,96,0));
         else
         if (Lauf<8)
            Painter->setBrush(QColor(64,64,0));
         else
            Painter->setBrush(QColor(128,0,0));
      }
      Painter->drawRect(x+Lauf*8,y, 5,10);
   }
}

/*void DetailsDlg::PeakAnzeige() {
char Strg[128];
   // Peak-Werte aktualisieren
   if (SP->Bs_Power>0.0) {
      int Sk=(int)(SP->Bs_Score/0.08333333333333333333);

      Painter->eraseRect(*PeakRect);
      Painter->setPen(SolidLine);
      Painter->setPen(QColor(255,255,255));
      sprintf(Strg,"Strongest Peak: power: %0.2f", SP->Bs_Power);
      Painter->drawText(10,127, Strg);
      sprintf(Strg,"(drift rate: %0.3f Hz/sec)", SP->Bs_Chirp_Rate);
      Painter->drawText(10,140, Strg);
      PeakValueAnzeige(290,117, Sk,Sk);
   }
}*/

void DetailsDlg::GaussianAnzeige() {
char Strg[128];
int Lauf,Letzt,Curr;
float Max=0,Scale,Avg=0;
float X,D,A=0,B=1,C;

   // Gaussian-Werte
   if (SP->Bg_Power) {
      int Sk=(int)(SP->Bg_Score/1.66666666666666666667);

      Painter->eraseRect(*GaussianRect);
      //Painter->fillRect(*GaussianRect,QColor(100,100,100));
      Painter->setPen(SolidLine);
      Painter->setPen(QColor(255,255,255));
      sprintf(Strg,"Best Gaussian: power: %0.2f, fit %0.3f", SP->Bg_Power,SP->Bg_Chisq);
      Painter->drawText(10,116, Strg);
      //sprintf(Strg,"(drift rate: %0.3f Hz/sec)", SP->Bg_Chirp_Rate);
      //Painter->drawText(200,117, Strg);
      PeakValueAnzeige(290,108, Sk,Sk);
      
      // Skyline
      // Maximalwert fr Skalierung bestimmen
      for (Lauf=0; Lauf<GARRMAX; Lauf++) {
         if (Max<SP->GArr[Lauf])
            Max=SP->GArr[Lauf];
         Avg+=SP->GArr[Lauf];
      }
      
      if (Max==0) Max=1;
      Avg=Avg/GARRMAX;
      Scale = 45.0/Max;
      Avg*=0.5*Scale;
      
      Painter->setBrush(NoBrush);
      Painter->setPen(SolidLine);
      Painter->setPen(QColor(255,0,0));
      //Ausgabe
      Letzt=165;
      for (Lauf=0; Lauf<GARRMAX; Lauf++) {
         Curr=165-(int)(SP->GArr[Lauf]*Scale);
         Painter->drawLine(10+Lauf*6,Letzt, 10+Lauf*6,Curr);  // senkrecht
         Painter->drawLine(10+Lauf*6,Curr, 16+Lauf*6, Curr);  // waagerecht
         Letzt=Curr;
         //Painter->drawRect(10+Lauf*6, 165, 7, -SP->GArr[Lauf]*Scale-1);
      }
      Painter->drawLine(10+GARRMAX*6,Letzt, 10+GARRMAX*6,165);  // senkrecht
      
      // Kurve
      //Letzt=exp(-(Lauf-32)*(Lauf-32));
      Painter->setPen(QColor(255,255,200));
      Letzt=(int)Avg;
      X=0.0;
      D=1/385.0;
      A=SP->Bg_Fft_Ind/64.0;   // Verschiebung auf X-Achse
      B=SP->Bg_Chisq*0.001;    // Fit
      C=SP->Bg_Power*15;
      if (C>40) C=40;
      if (B>0.1) B=0.1;
      for (Lauf=0; Lauf<385; Lauf++) {
         Curr=(int)(Avg+exp(-(X-A)*(X-A)/B)*C);
         X+=D;
         Painter->drawLine(10+Lauf,165-Letzt,10+Lauf,165-Curr);
         Letzt=Curr;
      }
      //Painter->drawLine(10,165-(Avg*Scale,380,165-Avg*Scale);
   }
}

int Char2Hex(char c) {
  switch (c) {
    case '0' : return 0;
    case '1' : return 1;
    case '2' : return 2;
    case '3' : return 3;
    case '4' : return 4;
    case '5' : return 5;
    case '6' : return 6;
    case '7' : return 7;
    case '8' : return 8;
    case '9' : return 9;
    case 'A' :
    case 'a' : return 10;
    case 'B' :
    case 'b' : return 11;
    case 'C' :
    case 'c' : return 12;
    case 'D' :
    case 'd' : return 13;
    case 'E' :
    case 'e' : return 14;
    case 'F' :
    case 'f' : return 15;
  }
  return 0;
}

int Char2Hex(char c1, char c2) {
  return Char2Hex(c1)*16+Char2Hex(c2);
}

void DetailsDlg::PulseAnzeige() {
char Strg[128];
int Lauf,L2;
int X1,X2,Y1,Y2;
float Max=0,ScaleX,ScaleY;
int Values[PARRMAX];
int p=0;
   // Pulse-Werte
   if (SP->Bp_Power) {

      Painter->eraseRect(*GaussianRect);
      Painter->setPen(SolidLine);
      Painter->setPen(QColor(255,255,255));
      sprintf(Strg,"Best Pulse: power: %0.2f, period %0.3f, score %0.3f", SP->Bp_Power,SP->Bp_Period,SP->Bp_Score);
      Painter->drawText(10,116, Strg);

      // Textzeile mit den Hex-Werten scannen und umwandeln
      for (Lauf=0; Lauf<PARRMAX; Lauf++) {
        //Values[Lauf] = Char2Hex(SP->Bp_Data[Lauf+Lauf+1],SP->Bp_Data[Lauf+Lauf]);
        L2=Lauf+Lauf;
        Values[Lauf] = Char2Hex(SP->Bp_Data[L2],SP->Bp_Data[L2+1]); //+
                       //256*    Char2Hex(SP->Bp_Data[L2+2],SP->Bp_Data[L2+3]);
        // Maximalwert merken
        if (Max<Values[Lauf]) {
          Max=Values[Lauf];
          p=Lauf;
        }
      }
debug("Max=%0.2f, p=%d",Max,p);
      if (Max!=0)
        ScaleY=45.0/Max;
      else
        ScaleY=1;
      ScaleX=375.0/PARRMAX;

      Painter->setBrush(NoBrush);
      Painter->setPen(SolidLine);
      Painter->setPen(QColor(255,0,0));

      X1=10;
      Y1=165-(int)(Values[0]*ScaleY);
      for (Lauf=1; Lauf<PARRMAX; Lauf++) {
         Y2=165-(int)(Values[Lauf]*ScaleY);
         X2=10+(int)(Lauf*ScaleX);
         Painter->drawLine(X1,Y1, X2,Y2);  // waagerecht
         X1=X2;   Y1=Y2;
      }

   }
}

void DetailsDlg::TripletAnzeige() {
char Strg[128];
int Lauf,L2;
int X1,X2,Y;
float Max=0,ScaleX,ScaleY;
int Values[TARRMAX];

   // Triplet-Werte
   if (SP->Bt_Power) {

      Painter->eraseRect(*GaussianRect);
      Painter->setPen(SolidLine);
      Painter->setPen(QColor(255,255,255));
      sprintf(Strg,"Best Triplet: power: %0.2f, period %0.3f", SP->Bt_Power,SP->Bt_Period);
      Painter->drawText(10,116, Strg);

      // Textzeile mit den Hex-Werten scannen und umwandeln
      for (Lauf=0; Lauf<TARRMAX; Lauf++) {
        L2=Lauf*4;
        Values[Lauf] = //256*Char2Hex(SP->Bt_Data[L2],SP->Bt_Data[L2+1])+
                           Char2Hex(SP->Bt_Data[L2+2],SP->Bt_Data[L2+3]);
      if (Lauf<20)
      debug("%d",Values[Lauf]);
        // Maximalwert merken
        if (Max<Values[Lauf])
          Max=Values[Lauf];
      }
      if (Max!=0)
        ScaleY=45.0/Max;
      else
        ScaleY=1;
      ScaleX=375.0/TARRMAX;

      Painter->setBrush(NoBrush);
      Painter->setPen(SolidLine);
      Painter->setPen(QColor(255,0,0));

      X1=10;
      //Y1=165-(int)(Values[0]*ScaleY);
      for (Lauf=0; Lauf<TARRMAX; Lauf++) {
        if ((Lauf==SP->Bt_Ind0) || (Lauf==SP->Bt_Ind1) ||(Lauf==SP->Bt_Ind2))
          Y=130;
        else
          Y=165-(int)(Values[Lauf]*ScaleY);
        X2=10+(int)(Lauf*ScaleX);
        Painter->drawLine(X2,165, X2,Y);  // waagerecht
        if (X2-X1>1)
          Painter->drawLine(X2-1,165, X2-1,Y);  // waagerecht dick
        X1=X2;
      }

      Painter->setPen(QColor(0,255,0));
      X2=10+(int)(SP->Bt_Ind0*ScaleX);
      Painter->drawLine(X2,120, X2,128);
      X2=10+(int)(SP->Bt_Ind1*ScaleX);
      Painter->drawLine(X2,120, X2,128);
      X2=10+(int)(SP->Bt_Ind2*ScaleX);
      Painter->drawLine(X2,120, X2,128);
   }
}

void DetailsDlg::MiscAnalysisAnzeige() {
char Strg[128];
   // Doppler Drift
   Painter->eraseRect(*MiscAnalysisRect);
   Painter->setPen(SolidLine);
   Painter->setPen(QColor(255,255,255));
   switch (SP->Status) {
      case S_RECEIVING : sprintf(Strg,i18n("Status: Receiving data: %0.0f Kb"),SP->Progress);
                         Painter->drawText(10,87, Strg);
                         break;
      case S_WORKING   : Painter->drawText(10,87, i18n("Status: Analysing data..."));
                         break;
      case S_READY     : Painter->drawText(10,87, i18n("Status: WU Finished"));
                         break;
      case S_WAITING   : Painter->drawText(10,87, i18n("Status: Not processing"));
                         break;
   }
   if (SP->Status==S_WORKING) {
      sprintf(Strg,"Doppler drift rate: %0.4f Hz/s",SP->Cr);
      Painter->drawText(10,101, Strg);

      if (SP->Fl!=0) {
         sprintf(Strg,i18n("resolution: %0.6f Hz"),SP->Subband_Sample_Rate/SP->Fl);
         //Painter->drawText(10,114, Strg);
         Painter->drawText(200,101, Strg);
      }
   }
}

void DetailsDlg::DataInfoAnzeige() {
char Strg[128];
int h1,m1,s1,h2,m2,s2;
double t1,t2;


   // Recording Time
   Painter->eraseRect(*DataInfoRect);
   Painter->setPen(SolidLine);
   Painter->setPen(QColor(255,255,255));

   t1=SP->Start_Ra;
   h1=(int)t1;
   t1-=h1;t1*=60.0;
   m1=(int)t1;
   t1-=m1;t1*=60.0;
   s1=(int)t1;

   t2=SP->End_Dec;
   h2=(int)t2;
   t2-=h2;t2*=60.0;
   m2=(int)t2;
   t2-=m2;t2*=60.0;
   s2=(int)t2;
   sprintf(Strg,i18n("From: %d h %d m %d s RA, + %d deg %d m %d s Dec"),h1,m1,s1,h2,m2,s2);
   Painter->drawText(440,84, Strg);

   sprintf(Strg,i18n("Recorded on: %s"),SP->Time_Recorded);
   Painter->drawText(440,98, Strg);

   sprintf(Strg,i18n("Source: %s"),SP->Receiver);
   Painter->drawText(440,112, Strg);

   sprintf(Strg,i18n("Base Frequency: %0.9f GHz"),SP->Subband_Base*1e-9);
   Painter->drawText(440,127, Strg);
}

void DetailsDlg::UserInfoAnzeige() {
char Strg[128];
int h1,m1,s1;
double t1;

   // Userdata
   Painter->eraseRect(*UserInfoRect);
   Painter->setPen(SolidLine);
   Painter->setPen(QColor(255,255,255));
   sprintf(Strg,i18n("Name: %s"), SP->UserName);
   Painter->drawText(440,176, Strg);
   sprintf(Strg,i18n("Data units completed: %d"), SP->NumResults);
   Painter->drawText(440,190, Strg);

   t1=SP->TotalCpu/3600.0;
   h1=(int)t1;
   t1-=h1;t1*=60.0;
   m1=(int)t1;
   t1-=m1;t1*=60.0;
   s1=(int)t1;
   sprintf(Strg,i18n("Total computer time: %d hr %d min %0.1f sec"), h1,m1,t1);
   Painter->drawText(440,204, Strg);
}

void DetailsDlg::DataGarbageAnzeige(int NewLine) {
int Rnd,Ofs,Lauf,Lines;
int LineX,LineY,LineDeep,LineSide;
int ColRnd;
char Strg[128];
int Base;
int Intv;  // Updateintervall

//debug("DetailsDlg::DataGarbage - Start");
   if (SP->Progress!=0) {
      Intv=(int)(0.03333*SP->Cpu/SP->Progress);
      if (Intv<500) Intv=500;
      if (Intv>10000) Intv=10000;
      //debug("%d",Intv);
      if ((SP->Ncfft % 10)==0)  // Updategeschw. an Rechnergeschw. anpassen
         Timer->changeInterval(Intv);
   }
   if (NewLine) { //normale Anzeige
      StartupFlag=FALSE;
      if (Line>=7) {
         Line=0;
         Side = rand()%50 + 20;  // seitliche Ansicht
         if ((rand()%2)==1)
            Side=-Side;
         Deep = rand()%70;  // Tiefenansicht

         PosX=85-(Side>>1);
         PosY=440;
         Width=MAXVAL*WIDTH;
         Height=100-Deep;
         Deep+=100;
      
         Painter->eraseRect(*DataGarbageRect);

         // Texte ausjeben
         Painter->setPen(SolidLine);
         Painter->setPen(QColor(255,255,255));
         // Frequency
         Painter->drawText(PosX+10,PosY+20, "0.0");
         Painter->drawText(PosX+230, PosY+20, i18n("Frequency (Hz)"));
         sprintf(Strg,"%0.3f", SP->Subband_Sample_Rate);
         Painter->drawText(PosX+Width-60, PosY+20, Strg);
         // Power
         if (Side<0) { // Time links, Power rechts
            Base = PosX+Width+10;
         } else {  // Time rechts, Power links
            Base = PosX-46;
         }
         Painter->drawText(Base,PosY,i18n("Power"));
         Painter->drawLine(Base+20,PosY-20, Base+20,PosY-60);
         Painter->drawLine(Base+15,PosY-55, Base+20,PosY-60);
         Painter->drawLine(Base+25,PosY-55, Base+20,PosY-60);
         // Time
         if (Side<0) { // Time links, Power rechts
            Base = PosX;
            Painter->drawText(Base-25,PosY-5, "0");
            Painter->drawText(Base+Side-40,PosY-Deep+10,"107.4");
            Painter->drawText(Base+Side/2-65,PosY-Deep/2+5, i18n("Time (sec)"));
         } else {  // Time rechts, Power links
            Base = PosX+Width;
            Painter->drawText(Base+20,PosY-5, "0");
            Painter->drawText(Base+Side+20,PosY-Deep+10,"107.4");
            Painter->drawText(Base+Side/2+20,PosY-Deep/2+5, i18n("Time (sec)"));
         }

         Bar3dGrid(PosX,PosY, Width,Height, Deep,Side,  64,64,64);
         //Bar3dGrid(PosX,PosY, Width,Height, Deep,Side,  64,200,64);
      } else
         Line++;

      // Zufallszeile erzeugen :-)))
      Rnd=3*Height/4;
      Ofs=Height-Rnd;
      for (Lauf=0; Lauf<MAXVAL; Lauf++)
         Values[Lauf][Line]=rand()%Rnd+Ofs;
      LineX=PosX+Side-((Line+1)*Side/8);
      LineY=PosY-(Deep-((Line+1)*Deep/8));
      LineDeep=Deep/8;
      LineSide=Side/8;
      //Bar3d(LineX,LineY,  3,Height, LineDeep,LineSide, 0,0,255, 1.0);
      Painter->setPen(NoPen);
      if (Side<0) {
         for (Lauf=MAXVAL-1; Lauf>0; Lauf--) {
            ColRnd=rand()%30-15;
            //ColRnd=(int)((Values[Lauf][Line])*0.333);
            Bar3d(LineX+WIDTH*Lauf,LineY,  WIDTH,Values[Lauf][Line], LineDeep,LineSide, 
                  ColorLine[Lauf].red()+ColRnd,
                  ColorLine[Lauf].green()+ColRnd,
                  ColorLine[Lauf].blue()+ColRnd,
                  0.666);
         }
      } else {
         for (Lauf=0; Lauf<MAXVAL; Lauf++) {
            ColRnd=(rand()%30)-15;
            Bar3d(LineX+WIDTH*Lauf,LineY,  WIDTH,Values[Lauf][Line], LineDeep,LineSide,
                  ColorLine[Lauf].red()+ColRnd,
                  ColorLine[Lauf].green()+ColRnd,
                  ColorLine[Lauf].blue()+ColRnd,
                  0.666);
         }
      }
   } else
   {  // update Anzeige
//debug("XX PosX=%d  PosY=%d Deep=%d Side=%d",PosX,PosY,Deep,Side);
      if (!StartupFlag){
         Painter->eraseRect(*DataGarbageRect);
         Bar3dGrid(PosX,PosY, Width,Height, Deep,Side,  64,64,64);
         if (Line!=100)
         for (Lines=0; Lines<=Line; Lines++) {
            LineX=PosX+Side-((Lines+1)*Side/8);
            LineY=PosY-(Deep-((Lines+1)*Deep/8));
            LineDeep=Deep/8;
            LineSide=Side/8;
            Painter->setPen(NoPen);
            if (Side<0) {
               for (Lauf=MAXVAL-1; Lauf>0; Lauf--) {
                  ColRnd=rand()%30-15;
                  Bar3d(LineX+WIDTH*Lauf,LineY,  WIDTH,Values[Lauf][Lines], LineDeep,LineSide, 
                        ColorLine[Lauf].red()+ColRnd,
                        ColorLine[Lauf].green()+ColRnd,
                        ColorLine[Lauf].blue()+ColRnd,
                        0.666);
               }
            } else {
               for (Lauf=0; Lauf<MAXVAL; Lauf++) {
                  ColRnd=(rand()%30)-15;
                  Bar3d(LineX+WIDTH*Lauf,LineY,  WIDTH,Values[Lauf][Lines], LineDeep,LineSide,
                        ColorLine[Lauf].red()+ColRnd,
                        ColorLine[Lauf].green()+ColRnd,
                        ColorLine[Lauf].blue()+ColRnd,
                        0.666);
               }
            }
         }
      }
   }
//   Bar3dGrid(60,460, 600,100, 80,-30,  64,64,64);
}

void DetailsDlg::FortschrittsAnzeige() {
// Fortschrittsbalken aktualisieren
int X,X1,X2;
double D;
char Text[64];

   Painter->setPen(NoPen);
   if (SP->Status==S_RECEIVING)
      D=0;
   else
      D=360.0*SP->Progress;

   X=(int)(D);
   if (X>0)
      Bar3d(12,200, X,20, 8,8,   200,0,0, 1.0);

   D-=X;
   X1=(int)(8.0*D);
   if (X1>0)
      Bar3d(12+X+(8-X1),200-(8-X1), 1,20, X1,X1,   200,0,0, 1.0);

   D=8.0*D-X1;
   X2=(int)(20.0*D);
   if (X2>0)
      Bar3d(12+X+(8-X1)-1,200-(8-X1)+1, 1,X2, 0,0,   200,0,0, 1.0);

   // Lschen der alten Ausgaben
   Painter->eraseRect(12,205,370,10);
   Painter->setPen(SolidLine);
   Painter->setPen(QColor(255,255,255));
   if (SP->Status==S_RECEIVING)
      sprintf(Text,i18n("Overall: 0%% done"));
   else
      sprintf(Text,i18n("Overall: %0.3f%% done"), (SP->Progress<0)?0.0:100.0*SP->Progress);
   Painter->drawText(12,215, Text);
   {
   int Hour,Minute,Second;
   double T;

      if (SP->Status==S_RECEIVING)
         T=0;
      else
         T=SP->Cpu;
      Hour=(int)(T/3600);
      T-=(Hour*3600);
      Minute=(int)(T/60);
      T-=(Minute*60);
      Second=(int)T;
      sprintf(Text,i18n("CPU total: %d hr %02d min %02d sec"),Hour,Minute,Second);
   }
   Painter->drawText(200,215,Text);
}

void DetailsDlg::closeEvent( QCloseEvent *q) {
   debug("closeEvent");
   delete Pnts4;
   delete Painter;
   SP->DetailWindow=NULL;
   KTMainWindow::closeEvent(q);
}

void DetailsDlg::TimerTic() {
//   if (SP->Status==S_WORKING) {
      Painter->begin(this);
      MiscAnalysisAnzeige();
      //PeakAnzeige();

//      PulseAnzeige();
      DisplayCount++;
      if (DisplayCount<10) {
        if (SP->Bg_Power!=0.0)
          GaussianAnzeige();
        else
          DisplayCount=10;
      } else
      if (DisplayCount<20) {
        if (SP->Bp_Power!=0.0)
          PulseAnzeige();
        else
          DisplayCount=20;
      } else {
        if (SP->Bt_Power!=0.0)
          TripletAnzeige();
        else
          DisplayCount=30;
      }
      if (DisplayCount>=30)
        DisplayCount=0;

      FortschrittsAnzeige();
      if (SP->Status==S_WORKING)
         DataGarbageAnzeige(TRUE);
      Painter->end();
//   }
}

void DetailsDlg::CloseBtnClick() {
//   debug("close");
//   close();
   Painter->begin(this);
   //Painter->setPen(QRgb(0x00FFFFFF));
   Painter->setPen(NoPen);
   //Painter->drawLine(0,0,100,100);
   Bar3d(50,50, 30,30, 15,10,   200,0,0, 1.0);
   Painter->end();
}

void DetailsDlg::Bar3d(int x, int y, int w, int h, int t, int a, int rot, int gruen, int blau, double Shade) {
//debug("Dar3b");

   if (w<0) return;
   // Vorderseite
   Pnts4->setPoint(0,  x,  y);
   Pnts4->setPoint(1,  x+w,y);
   Pnts4->setPoint(2,  x+w,y-h);
   Pnts4->setPoint(3,  x,  y-h);
   QBrush B(QColor(rot, gruen, blau));
   Painter->setBrush(B);
   Painter->drawPolygon(*Pnts4);

   // Oberseite
   Pnts4->setPoint(0,  x,    y-h);
   Pnts4->setPoint(1,  x+w,  y-h);
   Pnts4->setPoint(2,  x+w+a,y-h-t);
   Pnts4->setPoint(3,  x+a,  y-h-t);
   B.setColor(QColor((int)(Shade*0.7*rot), (int)(Shade*0.7*gruen), (int)(Shade*0.7*blau)));
   Painter->setBrush(B);
   Painter->drawPolygon(*Pnts4);

   // Seite
   if (a<0) {
      Pnts4->setPoint(0,  x,    y);
      Pnts4->setPoint(1,  x+a,  y-t);
      Pnts4->setPoint(2,  x+a,  y-h-t);
      Pnts4->setPoint(3,  x,    y-h);
   } else {
      Pnts4->setPoint(0,  x+w,  y);
      Pnts4->setPoint(1,  x+w+a,y-t);
      Pnts4->setPoint(2,  x+w+a,y-h-t);
      Pnts4->setPoint(3,  x+w,  y-h);
   }
   B.setColor(QColor((int)(Shade*0.8*rot), (int)(Shade*0.8*gruen), (int)(Shade*0.8*blau)));
   Painter->setBrush(B);
   Painter->drawPolygon(*Pnts4);
}

void DetailsDlg::Bar3dGrid(int x,int y, int w,int h, int t,int a, int rot, int gruen, int blau) {
//debug("Dar3b");

   Painter->setPen(SolidLine);
   Painter->setPen(QColor(rot,gruen,blau));

   Painter->drawLine(x,y,      x+w,y);     // waggerecht unten vorne
   Painter->drawLine(x+a,y-t,  x+a+w,y-t); // waagerecht unten hinten
   Painter->drawLine(x+a,y-t-h,x+a+w,y-t-h);//waagerecht oben hinten

   Painter->drawLine(x,y,      x+a,y-t);   // links unten
   Painter->drawLine(x+a,y-t,  x+a,y-t-h); // links hinten
   
   if (a>0) {
      Painter->drawLine(x,y-h,    x+a,y-t-h); // links oben
      Painter->drawLine(x,y,      x,y-h);     // links vorne
   } else {
      Painter->drawLine(x+w,y-h,  x+a+w,y-t-h); // rechts oben
      Painter->drawLine(x+w,y,    x+w,y-h);     // rechts vorne
   }
   Painter->drawLine(x+w,y,    x+w+a,y-t);  // rechts hinten
   Painter->drawLine(x+w+a,y-t,x+w+a,y-t-h);// rechts unten
}

void DetailsDlg::SetupColors() {
int Lauf;

   for (Lauf=0; Lauf<MAXVAL/2; Lauf++) {
      ColorLine[Lauf]=QColor(20, 220-200*Lauf/(MAXVAL/2), 220);
   }
   for (Lauf=0; Lauf<MAXVAL/2; Lauf++) {
      ColorLine[MAXVAL/2+Lauf]=QColor(20+Lauf*200/(MAXVAL/2), 20, 220-200*Lauf/(MAXVAL/2));
   }
}

void DetailsDlg::focusInEvent( QFocusEvent *) {
//kein repaint()
   //debug("focusIn");
}

void DetailsDlg::focusOutEvent( QFocusEvent *) {
   //debug("focusOut");
}