#ifndef DLGDETAILS_H
#define DLGDETAILS_H

#include <qlabel.h>
#include <qprogressbar.h>
#include <ktmainwindow.h>
#include "chart.h"

#define WIDTH  2             // Breite eines Balkens
#define MAXVAL 280  //280    // Anzahl Werte/Zeile
class DetailsDlg : public KTMainWindow
{
Q_OBJECT
public:

   DetailsDlg(SetiPtr iSP, const char* name=0);
protected:
   void closeEvent( QCloseEvent *);
   void paintEvent( QPaintEvent *);
   void focusInEvent( QFocusEvent *);
   void focusOutEvent( QFocusEvent *);
   
signals:

private slots:
   void TimerTic();
   void CloseBtnClick();

private:
   SetiPtr SP;   // Pointer auf den zugehrigen Seti
   QTimer *Timer;
   QPainter *Painter;
   QPointArray *Pnts4;
   QRect *ProgressRect, *FreqResRect, /**PeakRect,*/ *GaussianRect,
         *MiscAnalysisRect, *DataInfoRect, *UserInfoRect, *DataGarbageRect;

   // Garbage
   int Persp;  // Ansichtsfaktor
   int PosX,PosY,Width,Height,Deep,Side;
   short int Values[MAXVAL][8]; //Array mit den Datenwerten
   int Line;  // aktuelle Zeile
   QColor ColorLine[MAXVAL];
   int StartupFlag; //Ausgabe unterdrcken, wenn Paintevent VOT dem ersten
                    // Timertic kommt
   int DisplayCount;   // Zhler fr das Umschalten der Gaussian/Pulse/Triplet-Anzeige
   
   void Bar3d    (int x,int y, int w,int h, int t,int a, int rot, int gruen, int blau, double Shade);
   void Bar3dGrid(int x,int y, int w,int h, int t,int a, int rot, int gruen, int blau);
   void PeakValueAnzeige(int x, int y, int Val, int Peak);
   void FortschrittsAnzeige();
   void MiscAnalysisAnzeige();
   //void PeakAnzeige(); giftsnischmerr
   void GaussianAnzeige();
   void PulseAnzeige();
   void TripletAnzeige();
   void DataInfoAnzeige();
   void UserInfoAnzeige();
   void DataGarbageAnzeige(int NewLine);
   void SetupColors();
};

#endif