/* kmemstat.cpp
 *
 */

#include <qkeycode.h>
#include <qpopupmenu.h>
#include <qevent.h>
#include <qcursor.h>
 
#include <kiconloader.h>
#include <kconfig.h>
#include <kmsgbox.h>
#include <kaccel.h>
#include <kkeydialog.h>

#include "kmemstat.h"
#include "dialogs.h"
#include "meminfo.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

KMemStat::KMemStat( char *name )
	: KTMainWindow( name )
{
	view = new KMemStatWidget( this, 0 );

	/* tell the KTMainWindow that this is indeed the main widget */
	setView(view);
	connect( view, SIGNAL(notifyMousePressEvent(QMouseEvent*)),
			this, SLOT(mousePressEvent(QMouseEvent*)) ) ;

	/* used for Drag&Drop */
	connect(new KDNDDropZone(this , DndURL), 
	        SIGNAL(dropAction(KDNDDropZone *)), 
	        SLOT(slotDropEvent(KDNDDropZone *)));

	createAccel() ;
	createMenu();
	createToolBar();
	createStatusBar() ;

	/* hack, TODO */
	readProperties( kapp->getConfig() ) ;
  
	/* now start some timers */
	this->startTimer( STATUSBAR_UPDATE_TIME ) ;

	setMinimumSize( 180, 240 ) ;
	resize( 450, 500 ) ;
}

KMemStat::~KMemStat()
{
}

void KMemStat::quitApplication()
{
	/* hack! this should be done by KTMainWindow */
	this->saveProperties( kapp->getConfig() ) ;

	KTMainWindow::deleteAll() ;
	kapp->quit() ; 
}

void KMemStat::createMenu()
{
	QString tmp ;
	int id ;

	/* here we create the menubar */

	/* first make a popupmenu */
	file_menu = new QPopupMenu;
	id = file_menu->insertItem(i18n("&Quit"),
			this, SLOT(quitApplication()));
	accel->changeMenuAccel(file_menu, id, KAccel::Quit );

	/* put the popupmenu into the menu bar */
	menuBar()->insertItem(i18n("&File"), file_menu);

	options_menu = new QPopupMenu;
	id = options_menu->insertItem(i18n("Configure keys"),
			this, SLOT(configKeys()) );
//	accel->changeMenuAccel(options_menu, id, ?? ); 
	id = options_menu->insertItem(i18n("Configure..."),
				this, SLOT(configProgram()) ); 
	accel->changeMenuAccel(options_menu, id, "CTRL+C" ); 
	menuBar()->insertItem(i18n("&Options"), options_menu);

	/* move menu to right */
	menuBar()->insertSeparator();

	/* and make the help menu */
	help_menu = kapp->getHelpMenu(true, 
			i18n( PACKAGE " " VERSION "\n\n"
 					"(c) 1998 Pieter Eendebak\n\n"
					"A memory viewer for Linux/KDE."));
 	menuBar()->insertItem(i18n("&Help"), help_menu);

	/* create the menu for the mouse */
	mouse_menu = new QPopupMenu;
	id = mouse_menu->insertItem(i18n("Quit"),
			this, SLOT(quitApplication()));
	accel->changeMenuAccel(mouse_menu, id, KAccel::Quit );
}

void KMemStat::createToolBar()
{
	//---------------------------------------------------
	// build a small toolbar

	// insert some buttons, the icons are from the standard KDE toolbar.
	toolBar()->insertButton(Icon("exit.xpm"),TOOLBAR_EXIT, true,i18n("Exit"));
	toolBar()->insertButton(Icon("help.xpm"),
		TOOLBAR_HELP, true, i18n("Show online help"));

	// Hint: toolBar() returns toolBar(0). If you want another toolbar, simply
	//       use toolBar(1), toolBar(2) and so on.

	// we connect the entire toolbar to one single slot. We could also
	// connect the single toolbar buttons to special slots in the 
	// insertButton call above, for example:
	//   insertButton(Icon("exit.xpm"),TOOLBAR_EXIT, 
	//                SIGNAL(clicked()), kapp, SLOT(quit()),
	//                true,"Exit")
	// This would be even better for this simple toolbar. We have chosen
	// the other design --- which is more flexible for bigger toolbars ---
	// for demonstration purposes in kless.
	connect(toolBar(), SIGNAL(clicked(int)),
		SLOT(slotToolbarClicked(int)));

	enableToolBar();
}

void KMemStat::createStatusBar()
{
	statusbar = new KStatusBar(this) ; // = statusBar() ;

	/* don't have more that 999 MB of memory! */  
	statusbar->insertItem( i18n("Free memory: 000.00 MB"),
			STATUSBAR_MEM_FREE ) ;
	statusbar->insertItem( i18n("Free swap: 0000.00 MB"),
			STATUSBAR_MEM_SWAP ) ;
  	statusbar->insertItem( "", STATUSBAR_REST ) ;

	statusbar->setInsertOrder( KStatusBar::LeftToRight ) ;

	setStatusBar( statusbar ) ;

	updateStatusBar() ;
}

void KMemStat::updateStatusBar()
{
	QString tmp ;

	MemInfo::updateInfo() ;
	
	float freeram = MemInfo::getFreeRam()/(1024.0*1024) ;
	float totalswap = MemInfo::getFreeSwap()/(1024.0*1024) ;

	tmp.sprintf( i18n("Free memory: %3.2f MB"), freeram ) ;
	statusbar->changeItem( tmp.data(), STATUSBAR_MEM_FREE ) ;
	tmp.sprintf( i18n("Free swap: %3.2f MB"), totalswap ) ;
	statusbar->changeItem( tmp.data(), STATUSBAR_MEM_SWAP ) ;
}

void KMemStat::createAccel()
{
	accel = new KAccel( this ) ;

	accel->connectItem(KAccel::Quit, this, SLOT( quitApplication() ) );
	accel->insertItem( i18n("Configure..."), "configure", "CTRL+C" );
	accel->connectItem("configure", this, SLOT( configProgram() ) );
}

void KMemStat::slotToolbarClicked(int item)
{
	switch (item)
	{
		case TOOLBAR_EXIT:
			this->quitApplication();
			break;
		case TOOLBAR_HELP:
			this->showHelp() ;
			break;
		default:
			printf("error: mail to <pte@ddsw.nl>\n");
			break ;
	}
}

void KMemStat::timerEvent( QTimerEvent * )
{
	updateStatusBar() ;
}

void KMemStat::mousePressEvent( QMouseEvent *m )
{
	#ifdef DEBUG
	printf("KMemStat: mouse pressed %d\n", m->button() ) ; 
	#endif

	if ( m->button() & RightButton )
		mouse_menu->popup( QCursor::pos() ) ;
}

void KMemStat::readProperties( KConfig *config )
{
	debug("readProperties");

	int p ;
	QString tmp;


	/* read colors in MemZone */
	for( int i=0; i<MemZone::number_of_colors; i++ )
	{
		tmp.sprintf("Color %d", i ) ;
		if( config->hasKey(tmp.data()) ) 
			view->memzone->setColor(
				config->readColorEntry(tmp.data()), i ) ; 
	}
	printf("done reading\n");
	
	/* read display options */
	if ( config->hasKey("Pages On Row") ) 
	{
		p = config->readNumEntry( "Pages On Row" ) ;
		view->memzone->setPagesOnRow( p )  ;
	}
	p = config->readNumEntry( "Update time",
			MemData::DEFAULT_UPDATE_TIME ) ;
	view->memdata->setUpdateTime( p )  ;

}

void KMemStat::saveProperties( KConfig *config )
{
	printf("saveProperties\n");

	int p ;
	QString tmp;

	/* save colors in MemZone */
	for( int i=0; i<MemZone::number_of_colors; i++ )
	{
		tmp.sprintf("Color %d", i ) ;
		config->writeEntry( tmp.data(),
			view->memzone->getColor(i) ) ; 
	}
	/* save display options */
	p = view->memzone->pagesOnRow() ; 
	config->writeEntry( "Pages On Row", p ) ;
	p = view->memdata->updateTime() ; 
	config->writeEntry( "Update time", p ) ;
}


void KMemStat::notImpl()
{
	KMsgBox::message(this, PACKAGE,
	klocale->translate("Sorry, this function hasn't been implemented yet.")  );
}

void KMemStat::configKeys()
{
	KKeyDialog::configureKeys( accel ) ;
}

void KMemStat::configProgram()
{
	debug("configure()");

	int x, i ;
	QColor c ;

	ConfigureWidget *config_widget = new ConfigureWidget( this, 0 ) ;

	/* first set all the properties */
	/* display */
	config_widget->display_tab->pagesOnRow( view->memzone->pagesOnRow() ) ;
	config_widget->display_tab->updateTime( view->memdata->updateTime() ) ;

	/* colors */
	for(i=0;i<MemZone::number_of_colors;i++)
		config_widget->color_tab->
			setColor( view->memzone->getColor(i), i ) ;

	/* now show the widget! */
	if ( config_widget->exec() )
	{
		/* update display */
		x = config_widget->display_tab->pagesOnRow() ; 
		view->memzone->setPagesOnRow( x ) ;
		x = config_widget->display_tab->updateTime() ; 
		view->memdata->setUpdateTime( x ) ;

		/* update colors */
		for(i=0;i<MemZone::number_of_colors;i++)
		{
			c = config_widget->color_tab->
				getColor( i ) ;
			view->memzone->setColor( c, i) ;
		}
		view->redraw() ;
	}
	
	delete config_widget ;
}

void KMemStat::showHelp()
{
	kapp->invokeHTMLHelp("","");
}

void KMemStat::slotDropEvent(KDNDDropZone *zone)
{
  // the user dropped something on our window.
  // handle it
  QString u = zone->getURLList().first();
}
