#include "kmemstatwidget.h"

#include <qmsgbox.h>
#include <qcolor.h>
#include <qpainter.h>
#include <qscrbar.h>
#include <qevent.h>

#include "mem_zone.h"
#include "memdata.h"

KMemStatWidget::KMemStatWidget(QWidget *parent, const char *name)
	: QWidget(parent, name)
{
	memdata = new MemData( this, 0 ) ;
	memzone = new MemZone( memdata, this, 0 ) ;  

	connect( memdata, SIGNAL(dataChanged()),
			memzone, SLOT( redrawBuffer() ) ) ;

	QString tmp ;
	tmp.sprintf( i18n("Number of pages in memory: %d"),
			memdata->numberOfPages() ) ; 
	status = new QLabel( tmp, this, 0 ) ; 

	/* TODO */
	scrollbar = new QScrollBar( 0, memdata->numberOfPages(),
		memzone->pagesOnRow(), 10*memzone->pagesOnRow(),
		0, QScrollBar::Vertical, this, 0 ) ;
	connect( scrollbar, SIGNAL(valueChanged(int)),
			memzone, SLOT(setScrollOffset(int)) ) ;
	connect( memzone, SIGNAL( scrollOffsetChanged(int)),
			this, SLOT(setScrollbarValue(int)) ) ;

	connect( memzone, SIGNAL(notifyMousePressEvent(QMouseEvent *)),
			this, SLOT(mousePressEvent(QMouseEvent *)) ) ;
	setMinimumSize( 80, 120 ) ;
}

KMemStatWidget::~KMemStatWidget()
{
	#ifdef DEBUG
	printf("Deleting KMemStatWidget\n");
	#endif

	delete memdata ;
	delete memzone ;
}

void KMemStatWidget::setScrollbarValue(int v)
{
	scrollbar->setValue(v) ;
}

void KMemStatWidget::redraw()
{
	update() ;
	memzone->redraw() ;
}

void KMemStatWidget::mousePressEvent( QMouseEvent *m )
{
	#ifdef DEBUG
	printf("KMemStatWidget: mouse pressed %d\n", m->button() ) ;
	#endif
 
	emit notifyMousePressEvent( m ) ;
}

void KMemStatWidget::resizeEvent( QResizeEvent *r )
{
	#ifdef DEBUG
	//printf("KMemStatWidget: resizeEvent()\n" ) ;
 	#endif

	int voffset=0 ;

	status->setGeometry( 10, 10, wi()-40, 30 ) ;
	voffset+=50 ;

/*
	int align = memzone->pagesOnRow() ;
	int br = int( (wi()-50)/align ) ;
	int memzone_width=br*align ;
*/
	int memzone_width= wi()-50 ;

	memzone->setGeometry(10, voffset, memzone_width, he()-voffset-10 ) ;
	scrollbar->setGeometry( 10+memzone_width+10, voffset,
			16, he()-voffset-10 ) ;
}


int KMemStatWidget::he()
{
	return this->height() ;
}

int KMemStatWidget::wi()
{
	return this->width() ;
}


