#ifndef MEMINFO_H 
#define MEMINFO_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <sys/sysinfo.h>
#include <kapp.h>


class MemInfo : public QObject
{
	Q_OBJECT
public:
	MemInfo( QWidget *parent=0, const char *name=0) ; 
	virtual ~MemInfo();

	static unsigned long getTotalMem() ;
	static unsigned long getTotalRam() ;
	static unsigned long getFreeRam() ;
	static unsigned long getBufferRam() ;
	static unsigned long getSharedRam() ;
	static unsigned long getTotalSwap() ;
	static unsigned long getFreeSwap() ;
	
	static void updateInfo() ;
	static struct sysinfo *info ;
};

#endif // MEMINFO_H 
