/*
    KMLOCfg
    
    A utility to configure the ELSA MicroLink(tm) Office modem.

    Copyright (C) 2000 Oliver Gantz (o.gantz@tu-bs.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ------
    ELSA and MicroLink are trademarks of ELSA AG, Aachen.
*/

#include "global.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 


#include <sys/stat.h>
#include <sys/types.h>
#include <limits.h>
#include <dirent.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>

#include <kapp.h>


static char path_buff[PATH_MAX];


KApplication * mykapp;


void test_dir( const char * name )
{
	DIR * dd;

	sprintf(path_buff, "%s/%s", getenv("HOME"), name);
	if ((dd = opendir(path_buff)))
		closedir(dd);
	else
		mkdir(path_buff, S_IRWXU);
}


char * expand_path( const char * fname )
{
	sprintf(path_buff, "%s/%s/%s", getenv("HOME"), KMLOCFG_DIR, fname);

	return path_buff;
}
