/*
    KMLOCfg
    
    A utility to configure the ELSA MicroLink(tm) Office modem.

    Copyright (C) 2000 Oliver Gantz (o.gantz@tu-bs.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ------
    ELSA and MicroLink are trademarks of ELSA AG, Aachen.
*/

#ifndef KMLOCFG_H 
#define KMLOCFG_H 

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <qlabel.h>

#include <ktopwidget.h>
#include <kmenubar.h>
#include <ktoolbar.h>
#include <kstatusbar.h>
#include <kconfig.h>

#include "preferences.h"
#include "loaddlg.h"
#include "setupdlg.h"


class KMLOCfg : public KTopLevelWidget
{
	Q_OBJECT
public:
	KMLOCfg( const char * name = 0 );
	~KMLOCfg();

public slots:
	void downloadCfg();
	void uploadCfg();

	void newPrefs();
	void showPrefs();
	void newSetup();
	void showSetup();

	void invokeHelp();
	void showAbout();

private slots:
	void toggleToolbar();
	void toggleStatusbar();
	void quit();
	void fetchDownDone( bool );
	void fetchUpDone( bool );

private:
	KConfig * KsConfig;

	KMenuBar * menuBar;
	KToolBar * toolBar;
	bool toolBarOn;
	KStatusBar * statusBar;
	bool statusBarOn;
	QLabel * view;
	Preferences * prefs;
	LoadDlg * loaddlg;
	SetupDlg * setupdlg;

	bool has_config;

	int menu_item_dl;
	int menu_item_ul;
	int menu_item_edit;
	int menu_item_tool;
	int menu_item_status;
};

#endif // KMLOCFG_H 
