/*
    KMLOFax
    
    A utility to process facsimile received with the ELSA
    MicroLink(tm) Office modem.

    Copyright (C) 1999-2000 Oliver Gantz <o.gantz@tu-bs.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ------
    ELSA and MicroLink are trademarks of ELSA AG, Aachen.
*/


#ifndef GLOBAL_H
#define GLOBAL_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <kapp.h>


#define PAPER_A4        0
#define PAPER_B4        1
#define PAPER_B5        2
#define PAPER_LETTER    3
#define PAPER_LEGAL     4
#define PAPER_EXECUTIVE 5


#define KMLOFAX_DIR       ".kde/share/apps/kmlofax"
#define KMLOFAX_FAXDIR    "faxdir"
#define KMLOFAX_ALIASLIST "aliases"

#define PREF_GEN_TOOLTIPS  TRUE
#define PREF_GEN_LOADNEW   FALSE
#define PREF_GEN_DELETEFAX TRUE

#define PREF_MOD_DEVICE   "/dev/modem"
#define PREF_MOD_SPEED    4		// 38400 Bps

#define PREF_PRT_COMMAND  "lpr -Plp"
#define PREF_PRT_PAPER    PAPER_A4
#define PREF_PRT_LMARGIN  5
#define PREF_PRT_RMARGIN  5
#define PREF_PRT_TMARGIN  10
#define PREF_PRT_BMARGIN  10
#define PREF_PRT_INTERPOL FALSE

#define PREF_MAIL_SERVER ""
#define PREF_MAIL_PORT   25
#define PREF_MAIL_NAME   ""
#define PREF_MAIL_ORG    ""
#define PREF_MAIL_EMAIL  ""
#define PREF_MAIL_REPLY  ""


extern KApplication * mykapp;

extern const uchar xchg_endian[];

void test_dir( const char * name );

char * expand_path( const char * fname );

char * replace_quotes( char * str );

char * strtrim( char * str );

#endif // GLOBAL_H
