/*
    KMLOFax
    
    A utility to process facsimile received with the ELSA
    MicroLink(tm) Office modem.

    Copyright (C) 1999-2000 Oliver Gantz <Oliver.Gantz@epost.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ------
    ELSA and MicroLink are trademarks of ELSA AG, Aachen.
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>

#include <qglobal.h>

#include <kapp.h>
#include <ktmainwindow.h>

#include "kmlofax.h"
#include "global.h"



void sighandler(int sig)
{
	signal(SIGPIPE, sighandler);
}


void print_version()
{
	fprintf(stderr, "kmlofax %s\n", VERSION);
}


void print_help()
{
	fprintf(stderr, "Usage: kmlofax [-help] [-version] [generic Qt or KDE arguments]\n");
}


int main(int argc, char *argv[])
{
	int i;

	for (i=1; i < argc; i++) {
		if (strcmp(argv[i], "-help") == 0) {
			print_help();
			exit(1);
		}
		else if (strcmp(argv[i], "-version") == 0) {
			print_version();
			exit(1);
		}
	}

	testDir("share");
	testDir("share/apps");
	testDir("share/apps/kmlofax");

	signal(SIGPIPE, sighandler);

	KMLOFaxApp a(argc, argv, "kmlofax");
	KMLOFax *kmlofax = new KMLOFax("kmlofaxtop");
	CHECK_PTR(kmlofax);

	a.setMainWidget(kmlofax);
	kmlofax->show();

	return a.exec();
}
