/*	 taken from:
 *   khexedit - Versatile hex editor
 *   Copyright (C) 1999  Espen Sand, espensa@online.no
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <qclipbrd.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qmessagebox.h>
#include <qmultilinedit.h> 

#include <kapp.h>
#include <kbuttonbox.h>
#include <kfm.h>
#include <kiconloader.h>

#include "aboutdialog.h"
#include "dialogmargin.h"


CAboutDialog::CAboutDialog( QWidget *parent, const char *name )
  : QDialog( parent, name, false, WStyle_Customize|WStyle_DialogBorder ) 
{
  QVBoxLayout *topLayout = new QVBoxLayout( this, OUTER_SEP, INNER_SEP ); 
  if( topLayout == 0 ) { return; }

  QString captionText;
  captionText.sprintf( i18n("About %s"), PACKAGE );
  setCaption( captionText );

  QFont titleFont = kapp->generalFont;
  titleFont.setBold( true );
  titleFont.setPointSize( 16 );

  QFont authorFont = kapp->generalFont;
  authorFont.setBold( true );

  QString appName( i18n("KDE USR Message Modem application") );
  QLabel *title = new QLabel( appName.data(), this );
  title->setFont(titleFont);
  title->setFixedHeight( title->sizeHint().height() );
  title->setFixedWidth( title->sizeHint().width() );
  title->setAlignment(AlignCenter);
  topLayout->addWidget( title );

  topLayout->addSpacing( INNER_SEP );

  QHBoxLayout *hbox = new QHBoxLayout();
  if( hbox == 0 ) { return; }
  topLayout->addLayout( hbox );

  KIconLoader &loader = *kapp->getIconLoader();
  QLabel *pixmap = new QLabel( this );
  pixmap->setPixmap( loader.loadIcon( "kmsgmodem.xpm" ) );
  pixmap->setFixedHeight( pixmap->sizeHint().height() );
  pixmap->setMinimumWidth( pixmap->sizeHint().width() );
  hbox->addWidget( pixmap, 0, AlignCenter );
  
  QVBoxLayout *vbox = new QVBoxLayout();
  if( vbox == 0 ) { return; }
  hbox->addLayout( vbox );

  QString versionString;
  versionString.sprintf( i18n("Version: %s %s (KDE %s)"), PACKAGE, VERSION,
			 KDE_VERSION_STRING );
  
  QLabel *version = new QLabel( versionString, this );
  version->setFont(authorFont);
  version->setFixedHeight( version->sizeHint().height() );
  version->setMinimumWidth( version->sizeHint().width() );
  vbox->addWidget( version, 0, AlignLeft );

  QString authorString;
  authorString.sprintf( i18n(" 1999 - 2000, Torsten Uhlmann") );
  QLabel *author = new QLabel( authorString, this );
  author->setFont(authorFont);
  author->setFixedHeight( author->sizeHint().height() );
  author->setMinimumWidth( author->sizeHint().width() );
  vbox->addWidget( author, 0, AlignLeft );
  hbox->addStretch(10);

  topLayout->addSpacing( INNER_SEP );

  mTabControl = new KTabCtl( this );
  if( mTabControl == 0 ) { return; }
  topLayout->addWidget( mTabControl, 10 );

  mPage[ page_general ] = addPage( QString(i18n("General")) );
  mPage[ page_contributor ] = addPage( QString(i18n("Contributors")) );
  mPage[ page_licence ] = addPage( QString(i18n("Licence agreement")) );

  topLayout->addSpacing( ACTION_SPACE );  
  KButtonBox *buttonBox = new KButtonBox( this, KButtonBox::HORIZONTAL, 0, 
					  INNER_SEP );
  buttonBox->addStretch();
  QPushButton *closeButton = buttonBox->addButton( i18n("&Cancel"), false );
  connect( closeButton, SIGNAL(clicked()),this,SLOT(reject()) );
  buttonBox->layout();
  buttonBox->setMinimumSize( buttonBox->sizeHint() );
  topLayout->addWidget( buttonBox );

  createGeneralPage();
  createContributorPage();
  createLicencePage();

  //
  // Compute the size of the tab widget. This will ensure that
  // the dialog is positioned (almost) correct the first time
  //
  QSize s( 0,0 );
  for( uint i=0; i<page_MAX; i++)
  {
    s = s.expandedTo( mPage[i]->minimumSize() );
  }
  s.setHeight( s.height()+20 ); // Tabs (bad practice!)
  mTabControl->setMinimumSize( s );

  topLayout->activate();
  setGeometry( x(), y(), minimumSize().width(), minimumSize().height() );
  setMinimumSize( s );
}

CAboutDialog::~CAboutDialog( void )
{

}


QFrame *CAboutDialog::addPage( const QString &title )
{
  QFrame *page = new QFrame( mTabControl, title.data() );
  page->setFrameStyle( QFrame::NoFrame );
  page->setEnabled( false );
  page->hide();

  mTabControl->addTab( page, title.data() );
  return( page );
}


void CAboutDialog::createGeneralPage( void )
{
  QFrame *page = mPage[ page_general ];

  QVBoxLayout *topLayout = new QVBoxLayout( page, INNER_SEP, INNER_SEP ); 
  if( topLayout == 0 ) { return; }
  
  topLayout->addStretch(5);

  QHBoxLayout *hbox = new QHBoxLayout(0);
  if( hbox == 0 ) { return; }
  topLayout->addLayout( hbox );

  QVBoxLayout *vbox = new QVBoxLayout(0);
  if( hbox == 0 ) { return; }
  hbox->addStretch(5);
  hbox->addLayout(vbox);
  hbox->addStretch(5);

  static QString reasonToMailMe = i18n(""
    "This is a work in progress. If you\n\n"
    "1. have a suggestion for improvement\n"
    "2. have found a bug\n"
    "3. want to contribute with something\n"
    "4. just want to tell me how nice or useful KMsgModem is\n\n"
    "then feel free to send me a mail.\n");

  QLabel *label;
  label = new QLabel( reasonToMailMe, page ); 
  label->setFixedHeight( label->sizeHint().height() );
  label->setFixedWidth( label->sizeHint().width() );
  vbox->addWidget( label, 0, AlignLeft );

  QGridLayout *gbox = new QGridLayout( 2, 2, INNER_SEP );
  vbox->addLayout( gbox );

  label = new QLabel( "Email:", page ); 
  label->setFixedHeight( label->sizeHint().height() );
  label->setFixedWidth( label->sizeHint().width() );
  gbox->addWidget( label, 0, 0, AlignLeft );

  CURLLabel *email = new CURLLabel( page, "email" );
  email->setText("TUhlmann@gmx.de");
  email->setURL("mailto:TUhlmann@gmx.de");
  email->setFloat(true);
  email->setUnderline(true);
  email->setFixedHeight( label->sizeHint().height() );
  email->setFixedWidth( email->sizeHint().width() );
  connect(email, SIGNAL(leftClick(const QString &)), 
	  SLOT(urlClick(const QString &)));
  gbox->addWidget( email, 0, 1, AlignLeft );

  label = new QLabel( "Homepage:", page ); 
  label->setFixedHeight( label->sizeHint().height() );
  label->setFixedWidth( label->sizeHint().width() );
  gbox->addWidget( label, 1, 0, AlignLeft );

  CURLLabel *homepage = new CURLLabel( page, "homePage" );
  homepage->setText("http://www.tuhlmann.purespace.de/projects/kmsgmodem");
  homepage->setURL("http://www.tuhlmann.purespace.de/projects/kmsgmodem");
  homepage->setFloat(true);
  homepage->setUnderline(true);
  homepage->setFixedHeight( label->sizeHint().height() );
  homepage->setFixedWidth( homepage->sizeHint().width() );
  connect(homepage, SIGNAL(leftClick(const QString &)), 
	  SLOT(urlClick(const QString &)));
  gbox->addWidget( homepage, 1, 1, AlignLeft );

  topLayout->addStretch(5);
  topLayout->activate();
}


void CAboutDialog::createContributorPage( void )
{
  QFrame *page = mPage[ page_contributor ];
  QVBoxLayout *topLayout = new QVBoxLayout( page, INNER_SEP, INNER_SEP ); 
  if( topLayout == 0 ) { return; }
  
  static QString contrbutorText = i18n("\n"
    "This program uses modified code and techniques from other KDE programs,\n"
    "specifically the About Dialog of khexedit. Credit goes to his author\n"
    "and others who contributed to KDE.\n"
    "\n"
    "Thomas Scheuermann, t.h.s@gmx.de, who wrote xsmp, another USR control\n"
    "program where I borrowed code from.\n");

  QMultiLineEdit *contrbutorTextArea = new QMultiLineEdit(page);
  contrbutorTextArea->setReadOnly(true);
  contrbutorTextArea->setText( contrbutorText.data() );

  //
  // Add 20 pixels to (hopefully) avoid the vertical scrollbar
  //
  contrbutorTextArea->setMinimumWidth(contrbutorTextArea->maxLineWidth()+20);
  topLayout->addWidget( contrbutorTextArea );
  topLayout->activate();
}


void CAboutDialog::createLicencePage( void )
{
  QFrame *page = mPage[ page_licence ];
  QVBoxLayout *topLayout = new QVBoxLayout( page, INNER_SEP, INNER_SEP ); 
  if( topLayout == 0 ) { return; }

  static QString licenseText = i18n("\n"
    "This program is free software; you can redistribute it and/or modify\n"
    "it under the terms of the GNU General Public License as published by\n"
    "the Free Software Foundation; either version 2 of the License, or\n"
    "(at your option) any later version.\n"
    "\n"
    "This program is distributed in the hope that it will be useful,\n"
    "but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
    "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
    "GNU General Public License for more details.\n"
    "\n"
    "You should have received a copy of the GNU General Public License\n"
    "along with this program; if not, write to the Free Software\n"
    "Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.\n");


  QMultiLineEdit *licenseTextArea = new QMultiLineEdit(page);
  licenseTextArea->setReadOnly(true);
  licenseTextArea->setText( licenseText.data() );

  //
  // Add 20 pixels to (hopefully) avoid the vertical scrollbar
  //
  licenseTextArea->setMinimumWidth(licenseTextArea->maxLineWidth()+20);
  topLayout->addWidget( licenseTextArea );
  topLayout->activate();
}


void CAboutDialog::urlClick( const QString &url ) 
{
  KFM kfm;
  if( kfm.isKFMRunning() == false )
  {
    QApplication::clipboard()->setText( url.data() );

    static QString msg = i18n(""
      "Unable to execute request: KFM is not running.\n\n"
      "The url has been written to the clipboard.\n"
      "You can paste it into your mail client or web browser.");
    
    QMessageBox::warning(
      this,
      i18n("Operation failed"),
      msg.data(),
      i18n("&OK"),
      "",
      "",
      0,0 );
  }
  else
  {
    kfm.openURL( url );
  }

}



CURLLabel::CURLLabel( QWidget *parent, const char *name )
  :KURLLabel( parent, name )
{
  installEventFilter( this );
}

CURLLabel::~CURLLabel( void )
{
}

bool CURLLabel::eventFilter( QObject *object, QEvent *e )
{
  if( e->type() == Event_MouseButtonPress ) 
  {
    QMouseEvent &m = *(QMouseEvent*)e;
    if( m.button() == LeftButton )
    {
      emit leftClick( url() );
    }
  }

  return( false );
}
