/***************************************************************************
                          headerview.h  -  description                              
                             -------------------                                         
    begin                : Tue May 18 1999                                           
    copyright            : (C) 1999 by Norbert Weuster                         
    email                : weuster@uni-duisburg.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KHEADERVIEW_H
#define KHEADERVIEW_H

#include <qwidget.h>
#include <qlineedit.h>
#include <qscrollbar.h>

#include <string>

#include <sys/types.h>
// #include <netinet/ether.h> not needed anymore
#include <netinet/tcp.h>
#include <netinet/udp.h>
#include <netinet/ip.h>
#include <netinet/ip_icmp.h>
// #include <linux/if_tr.h>
#include "knetdumpdoc.h"
#include "EtherLayout.h"
#include "Ether802_2Layout.h"
#include "TokenLayout.h"
#include "IPLayout.h"
#include "ARPLayout.h"
#include "TCPLayout.h"
#include "UDPLayout.h"
#include "ICMPLayout.h"
#include "IPXLayout.h"
#include "SPXLayout.h"
#include "NETBIOSLayout.h"

/**
  *@author Norbert Weuster
  */

class KHeaderView : public QWidget  {
   Q_OBJECT
public: 
   KHeaderView(QWidget *parent=0, KnetdumpDoc* doc=0, const char *name=0);
   ~KHeaderView();
   
signals:
   void gotData();

public slots:
   void startslot (); 
   void slotDocIsStarted ();
   void slotDocIsPaused  ();
   void slotErase();
   void draw ();

private:
    void drawLinkHeader (QPainter& p);
    void drawEther (QPainter& p);
    void drawNetwHeader (QPainter& p);
    void drawIPHeader (QPainter& p);
    void drawARPHeader (QPainter& p);
    void drawTCPHeader (QPainter& p);
    void drawUDPHeader (QPainter& p);
    void drawICMPHeader (QPainter& p);
    void drawNETBIOSHeader (QPainter& p);
    void drawSPXHeader (QPainter& p);
    void drawIPXHeader (QPainter& p);
    void drawData (QPainter& p);
  
private:
    bool drawing;
    KnetdumpDoc *pdoc;
    int hmax;
    QString anymore;
    u_int16_t bytesRemain;
    QWidget *pParent;
    
    const u_char* pData; // pointer to unknown raw data
    QWidget *pLinkLayout;
    QWidget *pOldLinkLayout;
    QWidget *pNetwLayout;
    QWidget *pTranspLayout;

    TokenLayout *pTokenLayout;
    EtherLayout *pEtherLayout;
    Ether802_2Layout *pEther802_2Layout;
    IPLayout *pIPLayout;
    ARPLayout *pARPLayout;
    TCPLayout *pTCPLayout;
    UDPLayout *pUDPLayout;
    ICMPLayout *pICMPLayout;
    IPXLayout *pIPXLayout;
    SPXLayout *pSPXLayout;
    NETBIOSLayout *pNETBIOSLayout;
    QLabel *pDataLayout;

    QScrollBar *pPacketScroller;
};



#endif



