#include "clientbase.h"
#include "filterconfigdlg.h"

#include <kapp.h>
#include <kconfig.h>
#include <klocale.h>

ClientBase::ClientBase(QWidget* parent)
{
  fParent = parent;

  fProgress = NULL;
  fClientSocket = NULL;
}

ClientBase::~ClientBase()
{
}

bool ClientBase::checkMail(QList<HeaderStruct>* headerList, ServerStruct *serverInfo)
{
  cout << "ClientBase::checkMail -> Checking this type of mailbox is not implemented." << endl;

  return false;
}

void ClientBase::setDate(HeaderStruct* headerInfo, QString dateString)
{
  QString day, monthString, year, hour, minute, second;
  int month;

  //cout << "Date:" << dateString << endl;

    // First we will get rid of the starting characters. The will be
  // " Fri, "  (no quotes) or sometimes without the day.
  if (dateString.contains(",", FALSE) > 0)
    dateString = dateString.remove(0, dateString.find(',', 0, FALSE) + 1);

  dateString = dateString.remove(0, 1);
 
  // we need to construct a qdate now.
  QDate date;
  day = dateString.left(dateString.find(' ', 0, FALSE));
  dateString = dateString.remove(0, dateString.find(' ', 0, FALSE) + 1);
  
  monthString =  dateString.left(dateString.find(' ', 0, FALSE));
  dateString = dateString.remove(0, dateString.find(' ', 0, FALSE) + 1);

  if (monthString == "Jan")
    month = 1;
  else if (monthString == "Feb")
    month = 2;
  else if (monthString == "Mar")
    month = 3;
  else if (monthString == "Apr")
    month = 4;
  else if (monthString == "May")
    month = 5;
  else if (monthString == "Jun")
    month = 6;
  else if (monthString == "Jul")
    month = 7;
  else if (monthString == "Aug")
    month = 8;
  else if (monthString == "Sep")
    month = 9;
  else if (monthString == "Oct")
    month = 10;
  else if (monthString == "Nov")
    month = 11;
  else            // (monthString == "Dec")
    month = 12;

  year = dateString.left(dateString.find(' ', 0, FALSE));
  dateString = dateString.remove(0, dateString.find(' ', 0, FALSE) + 1);

  //cout << "YEAR: " << year.toInt() << endl;

  // Because of the y2k problem in some email headers, knewmail will
  // assume that anymail received after the 50th decade belones to 1900
  // and anymail before that belongs to the year 2000. This means that knewmail
  // will no longer work right after 2050, but hopefully it will be really 
  // outdated by then!

  if (year.toInt() < 1900)
    {
      if (year.toInt() > 50)
	date.setYMD(year.toInt() + 1900, month, day.toInt());

      else
	date.setYMD(year.toInt() + 2000, month, day.toInt());

    }
  else
    date.setYMD(year.toInt(), month, day.toInt());


  // Now we need to get the time and create a qtime
  QTime time;
  
  hour = dateString.left(dateString.find(':', 0, FALSE));
  dateString = dateString.remove(0, dateString.find(':', 0, FALSE) + 1);
  
  minute = dateString.left(dateString.find(':', 0, FALSE));
  dateString = dateString.remove(0, dateString.find(':', 0, FALSE) + 1);
  
  second = dateString.left(dateString.find(' ', 0, FALSE));
  dateString = dateString.remove(0, dateString.find(' ', 0, FALSE) + 1);

  time.setHMS(hour.toInt(), minute.toInt(), second.toInt());
  

  // Now set them into the header struct
  headerInfo->datetime.setDate(date);
  headerInfo->datetime.setTime(time);

  //cout << "TIME:" << time.toString()  << endl;
}

void ClientBase::initProgressDialog(QString address)
{
  QString progressMsg = "Retrieving from ";
  progressMsg += address;
  fProgress = new QProgressDialog(i18n(progressMsg), i18n("Abort Check"), 100, fParent, "Progress", TRUE);
  fProgress->setGeometry((fParent->width()/2) - (fProgress->width()/2),
		       (fParent->height()/2) - (fProgress->height()/2),
		       fProgress->width(),
		       fProgress->height());
  fProgress->setCaption(i18n("knewmail Status"));
  fProgress->setMinimumDuration( 1000 );
}

void ClientBase::destroyProgrssDialog()
{
  delete (fProgress);
  fProgress = NULL;
}

bool ClientBase::runThroughFilter(HeaderStruct* headerInfo)
{
  KConfig *config = kapp->getConfig();
  QString containingText, yearString, dayString, monthString, dateString;
  QDate date, headerDate;
  config->setGroup("FILTER");
  
  //  Check to see what kind of filtering should be done on the 
  switch (config->readNumEntry("Field", COMBO_ID_FROM)) 
    {
    case COMBO_ID_FROM:
      containingText = config->readEntry("ContainingText", "");
      if ((!containingText.isEmpty()) && (headerInfo->from.contains(containingText)))
	return true;
      break;

    case COMBO_ID_SUBJECT:
      containingText = config->readEntry("ContainingText", "");
      if ((!containingText.isEmpty()) && (headerInfo->subject.contains(containingText)))
	return true;
      break;

    case COMBO_ID_DATE:
      dateString = config->readEntry("SelectedDate", "");

      if (dateString.isEmpty())
	return false;

      yearString = dateString.left(4);
      dateString = dateString.remove(0, 4);
      monthString = dateString.left(2);
      dateString = dateString.remove(0, 2);
      dayString = dateString;

      date.setYMD(yearString.toInt(), monthString.toInt(), dayString.toInt());
      headerDate = headerInfo->datetime.date();

      switch (config->readNumEntry("DateOption", COMBO_ID_BEFORE_DATE))
	{
	case COMBO_ID_BEFORE_DATE:
	  //cout << "before" << endl;
	  return (headerDate < date);
	  break;
	  
	case COMBO_ID_AFTER_DATE:
	  //cout << "After" << endl;
	  return (headerDate > date);
	  break;

	case COMBO_ID_SAMEAS_DATE:
	  //cout << headerDate.toString() << endl;
	  return (headerDate == date);
	  break;
	}
      break;

    default:
      return false;
      break;
    }
  return false;
}

bool ClientBase::openConnection(ServerStruct* serverInfo)
{
  QString errorString;
  KConfig* config = kapp->getConfig();
  config->setGroup("BASE");
  fTimeOutLength = config->readNumEntry("TimeOutLength", 8);

  fClientSocket = new KSocket(serverInfo->address, serverInfo->port);
  
  if (fClientSocket->socket() <= -1)
    {
      errorString = "Could not create a socket. Address " + serverInfo->address;
      errorString += " couldn't be reached.";
      ERROR(errorString);

      delete (fClientSocket);
      fClientSocket = NULL;
      return false;
    }

  // We know we have a good connections, so we will setup all the socket stuff
  /* Used to watch the socket to see when it has input. */
  FD_ZERO(&fRfds);
  FD_SET(fClientSocket->socket(), &fRfds);
  /* Wait up to timeoutlength seconds. */
  fTv.tv_sec = fTimeOutLength;
  fTv.tv_usec = 0;

  return true;
}

void ClientBase::destroyConnection()
{
  delete(fClientSocket);
  fClientSocket = NULL;

}

bool ClientBase::readLine(QString& response)
{
  char buffer, intToString[5];
  int bytes, retval;
  QString errorString;

  response = "";

  // It seems that we need to set this each time we read a line. THis is because it seems to 'tick'
  // down while the socket waits. Once it gets too low, like zero, things go to hell!
  fTv.tv_sec = fTimeOutLength;
  fTv.tv_usec = 0;

  // This method of reading from the socket was roughly based on the method used in KBiff
  retval = select(fClientSocket->socket()+1,  &fRfds, NULL, NULL, &fTv);
  while ((retval) && ( (((bytes = ::read(fClientSocket->socket(), &buffer, 1)) > 0) && (buffer != '\n')) || (bytes < 0)  ))
    {
      if (bytes > 0)
	{
	  response += buffer;
	}
      retval = select(fClientSocket->socket()+1,  &fRfds, NULL, NULL, &fTv);
    }
 
  if (retval == 0)
    {
      errorString = "Time out Error. No input come across the socket in " ;
      sprintf(intToString, "%d", (int)fTv.tv_sec);
      errorString += intToString;
      errorString += " seconds. Nothing to read.";
      ERROR(errorString);
      
      return false;
    }

  //cout << "RESPONSE: " << response << endl;
  
  return true;
}

void ClientBase::writeLine(QString command)
{
  write(fClientSocket->socket(), (const char*)command, command.length());
}

void ClientBase::parseHeaderLine(QString headerLine, HeaderStruct* headerInfo)
{
  if (headerLine.contains("Date:", TRUE) > 0)
    {
      headerLine = headerLine.remove(0, headerLine.find(' ', 0, FALSE) + 1);
      setDate(headerInfo, headerLine);
    }
  
  else if (headerLine.contains("From:", TRUE) > 0)
    {
      headerInfo->from = headerLine.remove(0, headerLine.find(' ', 0, FALSE) + 1);
    }
  
  else if (headerLine.contains("To:", TRUE) > 0)
    {
      headerInfo->to = headerLine.right(headerLine.length() - 3);
    }
  
  else if (headerLine.contains("Subject:", TRUE) > 0)
    {
      headerInfo->subject = headerLine.right(headerLine.length() - 8);
    }
}
