#include "clientpop3.h"
#include "knewmail.h"
#include "filterconfigdlg.h"
#include "resource.h"

#include <iostream.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>

ClientPop3::ClientPop3(QWidget* parent) : ClientBase(parent)
{
}

ClientPop3::~ClientPop3()
{
}

bool ClientPop3::checkMail(QList<HeaderStruct>* headerList, ServerStruct *serverInfo)
{
  QString response, command;

  if (!openConnection(serverInfo))
    return false;
      
  int numMsgs = 0;
  KConfig* config = kapp->getConfig();

  initProgressDialog(serverInfo->address);

 

  // ************************** GET WELCOME MSG FROM SERVER  ***************************

  if (!readLine(response))
    {
      return 0;
    }

  // ****************************** END WELCOME MESSGAE ********************************



  // *************************** SEND USERNAME ********************************************

  // Send the login name 
  command = "USER ";
  command += serverInfo->username;
  command +="\r\n\0";
  
  writeLine(command);
  
  if ((!readLine(response)) || (!checkResponse(response)))
    {
      return 0;
    }

  //************************ END SEND USERNAME *****************************
  

  //**************************** SEND PASS *********************************
     
   command = "PASS ";
   
   if (serverInfo->save)
     command += serverInfo->password;
   else
     command += KNewMailApp::showPassDialog(serverInfo->address);
   command += "\r\n\0";
   
   writeLine(command);
   
    // Wait for results from that command
   if ((!readLine(response)) || (!checkResponse(response)))
     {
       return 0;
     }
   
  //************************ END SEND PASS *****************************

   
   //***************************** SEND STAT ********************************

   command = "STAT\r\n";

   writeLine(command);

   // Wait for results from that command
   if ((!readLine(response)) || (!checkResponse(response)))
     {
       return 0;
     }
   
   // Get the number of messages from the string that was returned
   QString statReturn = response;

   statReturn = statReturn.remove(0, 4);
   statReturn = statReturn.left((statReturn.find(' ', 0, FALSE)));
   statReturn = statReturn.stripWhiteSpace();
   numMsgs = statReturn.toInt();  

   // For debugging
   // cout << "** User has " << numMsgs << " message waiting on server.**" << endl;
   
   // **************************** END SEND STAT ******************************** 


   
   // ***************************** SEND TOP COMMAND ****************************
   
   int i = 0;

   config->setGroup("NOTIFICATION");
   if ((fParent->isVisible()) && (config->readBoolEntry("ShowStatusDlg", TRUE)))
     {
       fProgress->setTotalSteps(numMsgs);
       for (i=0; i< numMsgs; i++) 
	 {
	   kapp->processEvents();
	   fProgress->setProgress( i );
	   if ( fProgress->wasCancelled() )
	     break;
	   
	   if (!retrieveHeaders(i, serverInfo, config, headerList))
	     {
	       fProgress->setProgress( numMsgs );
	       destroyProgrssDialog();
	       return false;
	     }
	   
	   fProgress->setProgress( numMsgs );
	 }
       
       destroyProgrssDialog();
     }
   
   else
     {
       
       // Same as code above, but with no progress bar support
       for (i = 0; i < numMsgs; i++)
	 {
	    kapp->processEvents();
	   if (!retrieveHeaders(i, serverInfo, config, headerList))
	     return false;
	 }
     }
   // ************************* END SEND TOP ****************************
   

   //************************* SEND QUIT *******************************
   
   command = "QUIT\r\n";
   writeLine(command);

   // ************************ END SEND QUIT ***************************

   destroyConnection();

   return true;


}


bool ClientPop3::checkResponse(QString response)
{
  QString errorString;

  // Every read will give us a result, either ok or err. We need
  // to get that value now.
  
  if (response.left(3) == "+OK")
    {
      return true;
    }
  
  else if (response.left(3) == "-ER")
    {
      errorString = "Server returned an error. Error was: ";
      errorString += response;
      ERROR(errorString);
      
      return false;
    }
}

bool ClientPop3::retrieveHeaders(int msgNum, ServerStruct* serverInfo, KConfig* config, QList<HeaderStruct>* headerList)
{
  HeaderStruct *headerInfo;
  QString command, response;
  char intToString[5];
  bool validReadLine = true;
  int loopCount = 0;

  headerInfo = new HeaderStruct;
  headerInfo->address = serverInfo->username + "@" + serverInfo->address;
  
  command = "TOP ";
  sprintf(intToString, "%d", msgNum+1);
  command += intToString;
  command += " 0\r\n";
  
  //cout << "Now Sending " << topCommand << endl;
  
  writeLine(command);
  
  validReadLine = readLine(response);
  while ((validReadLine) && (response[0] != '.') && (loopCount < 5000))
    {
      parseHeaderLine(response, headerInfo);
      validReadLine = readLine(response);
      loopCount++;
    }
    
  if (loopCount > 5000)
    ERROR("Attempted to read from the socket 5000 times. Breaking out of loop.");
  
  // Now run it through the filter
  config->setGroup("FILTER");
  if (config->readBoolEntry("UseFiltering", false))
    if (runThroughFilter(headerInfo))
      {
	switch (config->readNumEntry("Command", COMBO_ID_IGNORE))
	  {
	  case COMBO_ID_IGNORE:
	    //cout << "Header being ignored" << endl;
	    delete (headerInfo);
	    break;
	    
	  case COMBO_ID_DELETE:
	    command = "DELE ";
	    sprintf(intToString, "%d", msgNum+1);
	    command += intToString;
	    command += "\r\n";
	    //cout << "Now Sending " << topCommand << endl;
	    writeLine(command);
	    delete(headerInfo);
	    
	    // Wait for results from that command
	    if ((!readLine(response)) || (!checkResponse(response)))  
	      return 0;
	    
	    break;
	  }
      }
    else
      headerList->append(headerInfo);
  else
    headerList->append(headerInfo);

  return true;
}

